/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import svenhjol.charm.recipe.WoodcuttingRecipe;
import svenhjol.charm.screenhandler.WoodcutterScreenHandler;

@Environment(value=EnvType.CLIENT)
public class WoodcutterScreen
extends class_465<WoodcutterScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("textures/gui/container/stonecutter.png");
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;
    private boolean canCraft;

    public WoodcutterScreen(WoodcutterScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        --this.field_25268;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        this.method_25420(matrices);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_22787.method_1531().method_22813(TEXTURE);
        int i = this.field_2776;
        int j = this.field_2800;
        this.method_25302(matrices, i, j, 0, 0, this.field_2792, this.field_2779);
        int k = (int)(41.0f * this.scrollAmount);
        this.method_25302(matrices, i + 119, j + 15 + k, 176 + (this.shouldScroll() ? 0 : 12), 0, 12, 15);
        int l = this.field_2776 + 52;
        int m = this.field_2800 + 14;
        int n = this.scrollOffset + 12;
        this.renderRecipeBackground(matrices, mouseX, mouseY, l, m, n);
        this.renderRecipeIcons(l, m, n);
    }

    protected void method_2380(class_4587 matrices, int x, int y) {
        super.method_2380(matrices, x, y);
        if (this.canCraft) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.scrollOffset + 12;
            List<WoodcuttingRecipe> list = ((WoodcutterScreenHandler)this.field_2797).getAvailableRecipes();
            for (int l = this.scrollOffset; l < k && l < ((WoodcutterScreenHandler)this.field_2797).getAvailableRecipeCount(); ++l) {
                int m = l - this.scrollOffset;
                int n = i + m % 4 * 16;
                int o = j + m / 4 * 18 + 2;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                this.method_25409(matrices, list.get(l).method_8110(), x, y);
            }
        }
    }

    private void renderRecipeBackground(class_4587 matrixStack, int i, int j, int k, int l, int m) {
        for (int n = this.scrollOffset; n < m && n < ((WoodcutterScreenHandler)this.field_2797).getAvailableRecipeCount(); ++n) {
            int o = n - this.scrollOffset;
            int p = k + o % 4 * 16;
            int q = o / 4;
            int r = l + q * 18 + 2;
            int s = this.field_2779;
            if (n == ((WoodcutterScreenHandler)this.field_2797).getSelectedRecipe()) {
                s += 18;
            } else if (i >= p && j >= r && i < p + 16 && j < r + 18) {
                s += 36;
            }
            this.method_25302(matrixStack, p, r - 1, 0, s, 16, 18);
        }
    }

    private void renderRecipeIcons(int x, int y, int scrollOffset) {
        List<WoodcuttingRecipe> list = ((WoodcutterScreenHandler)this.field_2797).getAvailableRecipes();
        for (int i = this.scrollOffset; i < scrollOffset && i < ((WoodcutterScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            this.field_22787.method_1480().method_4023(list.get(i).method_8110(), k, m);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int m = l - this.scrollOffset;
                double d = mouseX - (double)(i + m % 4 * 16);
                double e = mouseY - (double)(j + m / 4 * 18);
                if (!(d >= 0.0) || !(e >= 0.0) || !(d < 16.0) || !(e < 18.0) || !((WoodcutterScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, l)) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                this.field_22787.field_1761.method_2900(((WoodcutterScreenHandler)this.field_2797).field_7763, l);
                return true;
            }
            i = this.field_2776 + 119;
            j = this.field_2800 + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 14;
            int j = i + 54;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            this.scrollAmount = (float)((double)this.scrollAmount - amount / (double)i);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean shouldScroll() {
        return this.canCraft && ((WoodcutterScreenHandler)this.field_2797).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((WoodcutterScreenHandler)this.field_2797).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    private void onInventoryChange() {
        this.canCraft = ((WoodcutterScreenHandler)this.field_2797).canCraft();
        if (!this.canCraft) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }
}

