/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class InventoryTidyingHandler {
    public static final int BE = 0;
    public static final int PLAYER = 1;
    private static final Map<Predicate<class_1799>, Comparator<class_1799>> testCompare = new HashMap<Predicate<class_1799>, Comparator<class_1799>>();

    public static void init() {
        testCompare.clear();
        testCompare.put(InventoryTidyingHandler.clazzTest(class_1747.class).negate(), InventoryTidyingHandler.anyCompare());
        testCompare.put(InventoryTidyingHandler.clazzTest(class_1747.class), InventoryTidyingHandler.blockCompare());
    }

    public static void sort(class_1263 inventory, int startSlot, int endSlot) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        InventoryTidyingHandler.populate(inventory, stacks, startSlot, endSlot);
        InventoryTidyingHandler.mergeInventory(stacks);
        InventoryTidyingHandler.sortInventory(stacks);
        InventoryTidyingHandler.setInventory(inventory, stacks, startSlot, endSlot);
    }

    public static void populate(class_1263 inventory, List<class_1799> stacks, int startSlot, int endSlot) {
        for (int i = startSlot; i < endSlot; ++i) {
            class_1799 stackInSlot = inventory.method_5438(i);
            if (stackInSlot.method_7960()) continue;
            stacks.add(stackInSlot.method_7972());
        }
    }

    public static void mergeInventory(List<class_1799> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 stack2 = stacks.get(i);
            if (stack2.method_7960()) continue;
            for (int j = 0; j < stacks.size(); ++j) {
                class_1799 stack1;
                if (i == j || (stack1 = stacks.get(j)).method_7960() || stack1.method_7947() >= stack1.method_7914() || !class_1799.method_7987((class_1799)stack2, (class_1799)stack1) || !class_1799.method_7975((class_1799)stack2, (class_1799)stack1)) continue;
                int setSize = stack1.method_7947() + stack2.method_7947();
                int carryover = Math.max(0, setSize - stack1.method_7914());
                stack1.method_7939(carryover);
                stack2.method_7939(setSize - carryover);
                if (stack2.method_7947() == stack2.method_7914()) break;
            }
            stacks.set(i, stack2);
        }
        stacks.removeIf(stack -> stack.method_7960() || stack.method_7947() == 0);
    }

    public static void sortInventory(List<class_1799> stacks) {
        stacks.sort(InventoryTidyingHandler::compare);
    }

    private static boolean setInventory(class_1263 inventory, List<class_1799> stacks, int startSlot, int endSlot) {
        for (int i = startSlot; i < endSlot; ++i) {
            int j = i - startSlot;
            class_1799 stack = j >= stacks.size() ? class_1799.field_8037 : stacks.get(j);
            inventory.method_5434(i, inventory.method_5444());
            if (stack.method_7960()) continue;
            inventory.method_5447(i, stack);
        }
        return true;
    }

    private static int compare(class_1799 stack1, class_1799 stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1.method_7960()) {
            return -1;
        }
        if (stack2.method_7960()) {
            return 1;
        }
        int index1 = 1;
        int index2 = -1;
        int index = 0;
        for (Predicate<class_1799> predicate : testCompare.keySet()) {
            if (predicate.test(stack1)) {
                index1 = index;
            }
            if (predicate.test(stack2)) {
                index2 = index;
            }
            if (index1 >= 0 && index1 == index2) {
                return testCompare.get(predicate).compare(stack1, stack2);
            }
            ++index;
        }
        return index1 - index2;
    }

    private static Comparator<class_1799> blockCompare() {
        return InventoryTidyingHandler.compare(Comparator.comparing(s -> class_1792.method_7880((class_1792)s.method_7909())), (s1, s2) -> s2.method_7947() - s1.method_7947(), (s1, s2) -> s2.hashCode() - s1.hashCode());
    }

    private static Comparator<class_1799> anyCompare() {
        return InventoryTidyingHandler.compare(Comparator.comparing(s -> class_1792.method_7880((class_1792)s.method_7909())), (s1, s2) -> s2.method_7947() - s1.method_7947(), (s1, s2) -> s2.hashCode() - s1.hashCode());
    }

    @SafeVarargs
    private static Comparator<class_1799> compare(Comparator<class_1799> ... comparators) {
        return (stack1, stack2) -> {
            for (Comparator comparator : comparators) {
                int res = comparator.compare(stack1, stack2);
                if (res == 0) continue;
                return res;
            }
            return 0;
        };
    }

    private static Predicate<class_1799> clazzTest(Class<? extends class_1792> clazz) {
        return stack -> !stack.method_7960() && clazz.isInstance(stack.method_7909());
    }
}

