/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_3915;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Removes minimum and maximum XP costs on the anvil. Anvils are also less likely to break.")
public class AnvilImprovements
extends CharmModule {
    @Config(name="Remove Too Expensive", description="If true, removes the maximum cost of 40 XP when working items on the anvil.")
    public static boolean removeTooExpensive = true;
    @Config(name="Stronger anvils", description="If true, anvils are 50% less likely to take damage when used.")
    public static boolean strongerAnvils = true;

    public static boolean allowTooExpensive() {
        return ModuleHandler.enabled("charm:anvil_improvements") && removeTooExpensive;
    }

    public static boolean allowTakeWithoutXp(class_1657 player, class_3915 levelCost) {
        return ModuleHandler.enabled("charm:anvil_improvements") && (player.field_7503.field_7477 || player.field_7520 >= levelCost.method_17407() && levelCost.method_17407() > -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tryDamageAnvil() {
        if (!ModuleHandler.enabled("charm:anvil_improvements")) return false;
        if (!strongerAnvils) return false;
        Random random = new Random();
        if (!(random.nextFloat() < 0.5f)) return false;
        return true;
    }
}

