/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.Collections;
import java.util.HashMap;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1614;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.MobHelper;
import svenhjol.charm.base.helper.PosHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.block.EnderPearlBlock;
import svenhjol.charm.entity.goal.FormEndermiteGoal;
import svenhjol.charm.event.AddEntityCallback;

@Module(mod="charm", description="Ender pearl storage. Eating a chorus fruit will teleport you to the nearest ender pearl block.")
public class BlockOfEnderPearls
extends CharmModule {
    public static EnderPearlBlock ENDER_PEARL_BLOCK;
    @Config(name="Chorus teleport range", description="A chorus fruit will teleport you to an ender pearl block within this range (in blocks).")
    public static int teleportRange;
    @Config(name="Chorus fruit teleport", description="If true, eating a chorus fruit while in range of an ender pearl block will teleport you to it.")
    public static boolean chorusTeleport;
    @Config(name="Convert silverfish to endermite", description="If true, a silverfish has a chance to be converted into an endermite when it is next to an ender pearl block.")
    public static boolean convertSilverfish;

    @Override
    public void register() {
        ENDER_PEARL_BLOCK = new EnderPearlBlock(this);
    }

    @Override
    public void init() {
        AddEntityCallback.EVENT.register(this::addGoalToSilverfish);
    }

    public static boolean tryChorusTeleport(class_1309 entity, class_1799 stack) {
        double z;
        double y;
        if (!ModuleHandler.enabled("charm:block_of_ender_pearls") || !chorusTeleport) {
            return false;
        }
        if (!(entity instanceof class_1657)) {
            return false;
        }
        if (entity.field_6002.field_9236) {
            return false;
        }
        class_3222 player = (class_3222)entity;
        class_2338 playerPos = player.method_24515();
        class_1937 world = player.field_6002;
        HashMap foundPositions = new HashMap();
        class_2338.method_20437((class_2338)playerPos.method_10069(-teleportRange, -teleportRange, -teleportRange), (class_2338)playerPos.method_10069(teleportRange, teleportRange, teleportRange)).forEach(blockPos -> {
            class_2338 abovePos = blockPos.method_10086(1);
            class_2680 stateAtPos = world.method_8320(blockPos);
            if (stateAtPos.method_26204() != ENDER_PEARL_BLOCK) {
                return;
            }
            if (abovePos.equals((Object)playerPos)) {
                return;
            }
            class_2680 state1 = world.method_8320(blockPos.method_10086(1));
            class_2680 state2 = world.method_8320(blockPos.method_10086(2));
            if (state1.method_26207() != class_3614.field_15959 || state2.method_26207() != class_3614.field_15959) {
                return;
            }
            double dist = PosHelper.getDistanceSquared(playerPos, abovePos);
            foundPositions.put(dist, abovePos);
        });
        if (foundPositions.isEmpty()) {
            return false;
        }
        class_2338 targetPos = (class_2338)foundPositions.get(Collections.min(foundPositions.keySet()));
        if (targetPos == null) {
            return false;
        }
        double x = (double)targetPos.method_10263() + 0.5;
        boolean didTeleport = player.method_6082(x, y = (double)targetPos.method_10264(), z = (double)targetPos.method_10260() + 0.5, true);
        if (!didTeleport) {
            return false;
        }
        class_3414 teleportSound = class_3417.field_14890;
        world.method_8465(null, x, y, z, teleportSound, class_3419.field_15248, 1.0f, 1.0f);
        player.method_5783(teleportSound, 1.0f, 1.0f);
        player.method_7357().method_7906(class_1802.field_8233, 20);
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        return true;
    }

    private class_1269 addGoalToSilverfish(class_1297 entity) {
        if (!convertSilverfish) {
            return class_1269.field_5811;
        }
        if (!(entity instanceof class_1614)) {
            return class_1269.field_5811;
        }
        class_1614 silverfish = (class_1614)entity;
        class_1355 goalSelector = MobHelper.getGoalSelector((class_1308)silverfish);
        if (goalSelector.method_19048().noneMatch(g -> g.method_19058() instanceof FormEndermiteGoal)) {
            goalSelector.method_6277(2, (class_1352)new FormEndermiteGoal(silverfish));
        }
        return class_1269.field_5812;
    }

    static {
        teleportRange = 8;
        chorusTeleport = true;
        convertSilverfish = true;
    }
}

