/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.base.enums.VanillaVariantMaterial;
import svenhjol.charm.base.handler.ClientRegistryHandler;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.base.helper.ItemHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.block.CrateBlock;
import svenhjol.charm.blockentity.CrateBlockEntity;
import svenhjol.charm.client.CratesClient;
import svenhjol.charm.gui.CrateScreen;
import svenhjol.charm.screenhandler.CrateScreenHandler;

@Module(mod="charm", description="A smaller storage solution with the benefit of being transportable.")
public class Crates
extends CharmModule {
    public static final class_2960 ID = new class_2960("charm", "crate");
    public static final Map<IVariantMaterial, CrateBlock> CRATE_BLOCKS = new HashMap<IVariantMaterial, CrateBlock>();
    public static class_3917<CrateScreenHandler> SCREEN_HANDLER;
    public static class_2591<CrateBlockEntity> BLOCK_ENTITY;
    public static final List<Class<? extends class_2248>> INVALID_CRATE_BLOCKS;
    public static final List<Class<? extends class_2248>> INVALID_SHULKER_BOX_BLOCKS;
    @Config(name="Show tooltip", description="If true, hovering over a crate will show its contents in a tooltip.")
    public static boolean showTooltip;
    public static boolean isEnabled;

    @Override
    public void register() {
        for (VanillaVariantMaterial type : VanillaVariantMaterial.values()) {
            CRATE_BLOCKS.put(type, new CrateBlock(this, type));
        }
        INVALID_CRATE_BLOCKS.add(class_2480.class);
        INVALID_CRATE_BLOCKS.add(CrateBlock.class);
        INVALID_SHULKER_BOX_BLOCKS.add(CrateBlock.class);
        SCREEN_HANDLER = RegistryHandler.screenHandler(ID, CrateScreenHandler::new);
        BLOCK_ENTITY = RegistryHandler.blockEntity(ID, CrateBlockEntity::new, new class_2248[0]);
        isEnabled = this.enabled;
    }

    @Override
    public void clientInit() {
        new CratesClient(this);
        ClientRegistryHandler.screenHandler(SCREEN_HANDLER, CrateScreen::new);
    }

    public static boolean canCrateInsertItem(class_1799 stack) {
        return !isEnabled || !INVALID_CRATE_BLOCKS.contains(ItemHelper.getBlockClass(stack));
    }

    public static boolean canShulkerBoxInsertItem(class_1799 stack) {
        return !isEnabled || !INVALID_SHULKER_BOX_BLOCKS.contains(ItemHelper.getBlockClass(stack));
    }

    public static CrateBlock getRandomCrateBlock(Random rand) {
        ArrayList<CrateBlock> values = new ArrayList<CrateBlock>(CRATE_BLOCKS.values());
        return (CrateBlock)values.get(rand.nextInt(values.size()));
    }

    static {
        INVALID_CRATE_BLOCKS = new ArrayList<Class<? extends class_2248>>();
        INVALID_SHULKER_BOX_BLOCKS = new ArrayList<Class<? extends class_2248>>();
        showTooltip = true;
        isEnabled = false;
    }
}

