/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3098;
import net.minecraft.class_3341;
import net.minecraft.class_3353;
import net.minecraft.class_3443;
import net.minecraft.class_3749;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.blockentity.CrateBlockEntity;
import svenhjol.charm.mixin.accessor.MineshaftGeneratorAccessor;
import svenhjol.charm.mixin.accessor.StructurePieceAccessor;
import svenhjol.charm.module.Crates;

@Module(mod="charm", description="Adds decoration and more ores to mineshafts.")
public class MineshaftImprovements
extends CharmModule {
    public static List<class_2680> commonFloorBlocks = new ArrayList<class_2680>();
    public static List<class_2680> commonCeilingBlocks = new ArrayList<class_2680>();
    public static List<class_2680> rareFloorBlocks = new ArrayList<class_2680>();
    public static List<class_2680> rareCeilingBlocks = new ArrayList<class_2680>();
    public static List<class_2680> pileBlocks = new ArrayList<class_2680>();
    public static List<class_2680> roomBlocks = new ArrayList<class_2680>();
    public static List<class_2680> roomDecoration = new ArrayList<class_2680>();
    public static List<class_2960> crateLootTables = new ArrayList<class_2960>();
    public static float floorBlockChance = 0.04f;
    public static float ceilingBlockChance = 0.02f;
    public static float rareBlockChance = 0.08f;
    public static float roomBlockChance = 0.3f;
    public static float blockPileChance = 0.1f;
    public static float crateChance = 0.1f;
    private static boolean isEnabled = false;
    @Config(name="Corridor blocks", description="If true, stone, ore, lanterns and TNT will spawn inside mineshaft corridors.")
    public static boolean generateCorridorBlocks = true;
    @Config(name="Corridor block piles", description="If true, occasionally there will be piles of ore in mineshaft corridors.")
    public static boolean generateCorridorPiles = true;
    @Config(name="Room blocks", description="If true, precious ores will spawn in the central mineshaft room.")
    public static boolean generateRoomBlocks = true;
    @Config(name="Add crates", description="If true, loot crates will be added to mineshaft corridors.")
    public static boolean generateCrates = true;

    @Override
    public void init() {
        isEnabled = true;
        commonFloorBlocks.addAll(Arrays.asList(class_2246.field_10212.method_9564(), class_2246.field_10418.method_9564(), class_2246.field_10571.method_9564()));
        rareFloorBlocks.addAll(Arrays.asList(class_2246.field_10375.method_9564(), class_2246.field_16541.method_9564()));
        pileBlocks.addAll(Arrays.asList(class_2246.field_10212.method_9564(), class_2246.field_10418.method_9564(), class_2246.field_10080.method_9564(), class_2246.field_10571.method_9564(), class_2246.field_10445.method_9564(), class_2246.field_10253.method_9564(), class_2246.field_10255.method_9564()));
        commonCeilingBlocks.addAll(Arrays.asList(class_2246.field_10343.method_9564(), (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true)), class_2246.field_10212.method_9564(), class_2246.field_10418.method_9564()));
        rareCeilingBlocks.addAll(Arrays.asList(class_2246.field_10571.method_9564()));
        roomBlocks.addAll(Arrays.asList(class_2246.field_10442.method_9564(), class_2246.field_10571.method_9564(), class_2246.field_10090.method_9564()));
        roomDecoration.addAll(Arrays.asList(class_2246.field_9989.method_9564(), class_2246.field_10405.method_9564(), class_2246.field_10566.method_9564()));
        crateLootTables.addAll(Arrays.asList(class_39.field_472, class_39.field_356, class_39.field_16751, class_39.field_17010, class_39.field_17107, class_39.field_434));
    }

    public static void generatePiece(class_3443 piece, class_5281 world, class_5138 accessor, class_2794 chunkGenerator, Random rand, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        if (!isEnabled) {
            return;
        }
        if (((MineshaftGeneratorAccessor)piece).getMineshaftType() == class_3098.class_3100.field_13691) {
            return;
        }
        if (piece instanceof class_3353.class_3354) {
            MineshaftImprovements.corridor((class_3353.class_3354)piece, world, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        } else if (piece instanceof class_3353.class_3357) {
            MineshaftImprovements.room((class_3353.class_3357)piece, (class_5425)world, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        }
    }

    private static void corridor(class_3353.class_3354 piece, class_5281 world, class_5138 accessor, class_2794 chunkGenerator, Random rand, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        int z;
        int bx = box.field_14378 - box.field_14381;
        int bz = box.field_14376 - box.field_14379;
        if (generateCorridorBlocks) {
            if (bx <= 0) {
                bx = 3;
            }
            if (bz <= 0) {
                bz = 7;
            }
            for (int x = 0; x < bx; ++x) {
                if (x == 1 && rand.nextFloat() < 0.08f) continue;
                for (int z2 = 0; z2 < bz; ++z2) {
                    if (MineshaftImprovements.validFloorBlock((class_3443)piece, (class_5425)world, x, 0, z2, box) && rand.nextFloat() < floorBlockChance) {
                        ((StructurePieceAccessor)piece).callAddBlock(world, MineshaftImprovements.getFloorBlock(rand), x, 0, z2, box);
                    }
                    if (!MineshaftImprovements.validCeilingBlock((class_3443)piece, (class_5425)world, x, 2, z2, box) || !(rand.nextFloat() < ceilingBlockChance)) continue;
                    ((StructurePieceAccessor)piece).callAddBlock(world, MineshaftImprovements.getCeilingBlock(rand), x, 2, z2, box);
                }
            }
        }
        if (generateCorridorPiles && rand.nextFloat() < blockPileChance && MineshaftImprovements.validFloorBlock((class_3443)piece, (class_5425)world, 1, 0, z = rand.nextInt(bz), box)) {
            class_2680 block1 = MineshaftImprovements.getRandomBlockFromList(pileBlocks, rand);
            class_2680 block2 = MineshaftImprovements.getRandomBlockFromList(pileBlocks, rand);
            for (int iy = 0; iy < 3; ++iy) {
                for (int ix = 0; ix <= 2; ++ix) {
                    for (int iz = -1; iz <= 1; ++iz) {
                        boolean valid = MineshaftImprovements.validFloorBlock((class_3443)piece, (class_5425)world, ix, iy, iz, box);
                        if (!valid || !(rand.nextFloat() < 0.75f)) continue;
                        ((StructurePieceAccessor)piece).callAddBlock(world, (double)rand.nextFloat() < 0.5 ? block1 : block2, ix, iy, iz, box);
                    }
                }
            }
        }
        if (generateCrates && ModuleHandler.enabled("charm:crates") && rand.nextFloat() < crateChance && rand.nextFloat() < 0.9f) {
            int z3;
            int r = rand.nextInt(3) + 12;
            int y = ((StructurePieceAccessor)piece).callApplyYTransform(0);
            int x = ((StructurePieceAccessor)piece).callApplyXTransform(1, r);
            class_2338 blockpos = new class_2338(x, y, z3 = ((StructurePieceAccessor)piece).callApplyZTransform(1, r));
            if (box.method_14662((class_2382)blockpos)) {
                class_2680 state = Crates.getRandomCrateBlock(rand).method_9564();
                class_2960 loot = crateLootTables.get(rand.nextInt(crateLootTables.size()));
                world.method_8652(blockpos, state, 2);
                class_2586 blockEntity = world.method_8321(blockpos);
                if (blockEntity instanceof CrateBlockEntity) {
                    ((CrateBlockEntity)blockEntity).method_11285(loot, rand.nextLong());
                    blockEntity.method_11007(new class_2487());
                }
            }
        }
    }

    private static void room(class_3353.class_3357 piece, class_5425 world, class_5138 accessor, class_2794 chunkGenerator, Random rand, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        if (generateRoomBlocks) {
            int bx = box.field_14378 - box.field_14381;
            int bz = box.field_14376 - box.field_14379;
            if (bx <= 0) {
                bx = 15;
            }
            if (bz <= 0) {
                bz = 15;
            }
            for (int y = 1; y <= 2; ++y) {
                for (int x = 0; x <= bx; ++x) {
                    for (int z = 0; z <= bz; ++z) {
                        class_2680 state;
                        if (!(rand.nextFloat() < roomBlockChance)) continue;
                        if (y == 1) {
                            state = rand.nextFloat() < 0.5f ? MineshaftImprovements.getRandomBlockFromList(roomBlocks, rand) : MineshaftImprovements.getRandomBlockFromList(roomDecoration, rand);
                        } else {
                            if (rand.nextFloat() < 0.5f) continue;
                            state = MineshaftImprovements.getRandomBlockFromList(roomBlocks, rand);
                        }
                        class_2338 pos = new class_2338(((StructurePieceAccessor)piece).getBoundingBox().field_14381 + x, ((StructurePieceAccessor)piece).getBoundingBox().field_14380 + y, ((StructurePieceAccessor)piece).getBoundingBox().field_14379 + z);
                        if (!world.method_22347(pos) || !world.method_8320(pos.method_10074()).method_26234((class_1922)world, pos.method_10074()) || world.method_22348(pos)) continue;
                        world.method_8652(pos, state, 11);
                    }
                }
            }
        }
    }

    private static boolean validCeilingBlock(class_3443 piece, class_5425 world, int x, int y, int z, class_3341 box) {
        class_2338 blockpos = new class_2338(((StructurePieceAccessor)piece).callApplyXTransform(x, z), ((StructurePieceAccessor)piece).callApplyYTransform(y), ((StructurePieceAccessor)piece).callApplyZTransform(x, z));
        return box.method_14662((class_2382)blockpos) && world.method_8320(blockpos.method_10084()).method_26225() && world.method_22347(blockpos.method_10074());
    }

    private static boolean validFloorBlock(class_3443 piece, class_5425 world, int x, int y, int z, class_3341 box) {
        class_2338 blockpos = new class_2338(((StructurePieceAccessor)piece).callApplyXTransform(x, z), ((StructurePieceAccessor)piece).callApplyYTransform(y), ((StructurePieceAccessor)piece).callApplyZTransform(x, z));
        boolean vecInside = box.method_14662((class_2382)blockpos);
        boolean solidBelow = world.method_8320(blockpos.method_10074()).method_26225();
        boolean notSlabBelow = !(world.method_8320(blockpos.method_10074()).method_26204() instanceof class_2482);
        boolean airAbove = world.method_22347(blockpos.method_10084());
        return vecInside && solidBelow && notSlabBelow && airAbove;
    }

    private static class_2680 getFloorBlock(Random rand) {
        return rand.nextFloat() < rareBlockChance ? MineshaftImprovements.getRandomBlockFromList(rareFloorBlocks, rand) : MineshaftImprovements.getRandomBlockFromList(commonFloorBlocks, rand);
    }

    private static class_2680 getCeilingBlock(Random rand) {
        return rand.nextFloat() < rareBlockChance ? MineshaftImprovements.getRandomBlockFromList(rareCeilingBlocks, rand) : MineshaftImprovements.getRandomBlockFromList(commonCeilingBlocks, rand);
    }

    private static class_2680 getRandomBlockFromList(List<class_2680> blocks, Random rand) {
        return blocks.get(rand.nextInt(blocks.size()));
    }
}

