/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.PosHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.PlayerStateClient;
import svenhjol.charm.event.PlayerTickCallback;

@Module(mod="charm", description="Synchronize additional state from server to client.", alwaysEnabled=true)
public class PlayerState
extends CharmModule {
    public static final class_2960 MSG_SERVER_UPDATE_PLAYER_STATE = new class_2960("charm", "server_update_player_state");
    public static final class_2960 MSG_CLIENT_UPDATE_PLAYER_STATE = new class_2960("charm", "client_update_player_state");
    public static List<BiConsumer<class_3222, class_2487>> listeners = new ArrayList<BiConsumer<class_3222, class_2487>>();
    public static PlayerStateClient client;
    @Config(name="Server state update interval", description="Interval (in ticks) on which additional world state will be synchronised to the client.")
    public static int serverStateInverval;

    @Override
    public void register() {
        ServerSidePacketRegistry.INSTANCE.register(MSG_SERVER_UPDATE_PLAYER_STATE, (context, data) -> context.getTaskQueue().execute(() -> {
            class_3222 player = (class_3222)context.getPlayer();
            if (player == null) {
                return;
            }
            PlayerState.serverCallback(player);
        }));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientRegister() {
        client = new PlayerStateClient();
        PlayerTickCallback.EVENT.register(player -> {
            if (player.field_6002.field_9236 && player.field_6002.method_8510() % (long)serverStateInverval == 0L) {
                ClientSidePacketRegistry.INSTANCE.sendToServer(MSG_SERVER_UPDATE_PLAYER_STATE, new class_2540(Unpooled.buffer()));
            }
        });
        ClientSidePacketRegistry.INSTANCE.register(MSG_CLIENT_UPDATE_PLAYER_STATE, (context, data) -> {
            class_2487 tag = new class_2487();
            try {
                byte[] byteData = Base64.getDecoder().decode(data.method_19772());
                tag = class_2507.method_10629((InputStream)new ByteArrayInputStream(byteData));
            }
            catch (IOException e) {
                Charm.LOG.warn("Failed to decompress player state");
            }
            class_2487 finalTag = tag;
            context.getTaskQueue().execute(() -> PlayerState.clientCallback(finalTag));
        });
    }

    public static void serverCallback(class_3222 player) {
        class_3218 world = player.method_14220();
        class_2338 pos = player.method_24515();
        long dayTime = world.method_8532() % 24000L;
        class_2487 tag = new class_2487();
        tag.method_10556("mineshaft", PosHelper.isInsideStructure(world, pos, class_3195.field_24844));
        tag.method_10556("stronghold", PosHelper.isInsideStructure(world, pos, class_3195.field_24852));
        tag.method_10556("fortress", PosHelper.isInsideStructure(world, pos, class_3195.field_24855));
        tag.method_10556("shipwreck", PosHelper.isInsideStructure(world, pos, class_3195.field_24850));
        tag.method_10556("village", world.method_19500(pos));
        tag.method_10556("day", dayTime > 0L && dayTime < 12700L);
        listeners.forEach(action -> action.accept(player, tag));
        class_2540 buffer = new class_2540(Unpooled.buffer());
        String serialized = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)tag, (OutputStream)out);
            serialized = Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (IOException e) {
            Charm.LOG.warn("Failed to compress player state");
        }
        if (serialized != null) {
            buffer.method_10814(serialized);
            ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)player, MSG_CLIENT_UPDATE_PLAYER_STATE, buffer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientCallback(class_2487 data) {
        PlayerState.client.mineshaft = data.method_10577("mineshaft");
        PlayerState.client.stronghold = data.method_10577("stronghold");
        PlayerState.client.fortress = data.method_10577("fortress");
        PlayerState.client.shipwreck = data.method_10577("shipwreck");
        PlayerState.client.village = data.method_10577("village");
        PlayerState.client.isDaytime = data.method_10577("day");
    }

    static {
        serverStateInverval = 120;
    }
}

