/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.mixin.accessor.ServerWorldAccessor;

@Module(mod="charm", description="Allows the night to pass when a specified number of players are asleep.")
public class SleepImprovements
extends CharmModule {
    @Config(name="Faster sleep", description="If true, the sleeping player does not need to wait as long before ending the night.")
    public static boolean fasterSleep = false;
    @Config(name="Number of required players", description="The number of players required to sleep in order to bring the next day.")
    public static int requiredPlayers = 1;

    @Override
    public void init() {
        ServerTickEvents.END_WORLD_TICK.register(this::tryEndNight);
    }

    private void tryEndNight(class_3218 world) {
        if (world == null || world.method_8510() % 20L != 0L || !world.method_27983().equals(class_1937.field_25179)) {
            return;
        }
        MinecraftServer server = world.method_8503();
        int currentPlayerCount = world.method_8503().method_3788();
        if (currentPlayerCount < requiredPlayers) {
            return;
        }
        List validPlayers = server.method_3760().method_14571().stream().filter(p -> !p.method_7325() && (fasterSleep ? p.method_6113() : p.method_7276())).collect(Collectors.toList());
        if (validPlayers.size() < requiredPlayers) {
            return;
        }
        if (world.method_8450().method_8355(class_1928.field_19396)) {
            long l = world.method_8532() + 24000L;
            world.method_29199(l - l % 24000L);
        }
        ((ServerWorldAccessor)world).callWakeSleepingPlayers();
        if (world.method_8450().method_8355(class_1928.field_19406)) {
            ((ServerWorldAccessor)world).callResetWeather();
        }
    }
}

