/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1477;
import net.minecraft.class_1493;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.enums.ICharmEnum;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.VariantMobTexturesClient;

@Module(mod="charm", description="Mobs may spawn with different textures.")
public class VariantMobTextures
extends CharmModule {
    private static final String PREFIX = "textures/entity/";
    private static final class_2960 DEFAULT_SHEEP = new class_2960("textures/entity/sheep/sheep.png");
    public static List<class_2960> chickens = new ArrayList<class_2960>();
    public static List<class_2960> cows = new ArrayList<class_2960>();
    public static List<class_2960> snowGolems = new ArrayList<class_2960>();
    public static List<class_2960> squids = new ArrayList<class_2960>();
    public static List<class_2960> pigs = new ArrayList<class_2960>();
    public static List<class_2960> wolves = new ArrayList<class_2960>();
    public static List<class_2960> rareChickens = new ArrayList<class_2960>();
    public static List<class_2960> rareCows = new ArrayList<class_2960>();
    public static List<class_2960> rareSquids = new ArrayList<class_2960>();
    public static List<class_2960> rarePigs = new ArrayList<class_2960>();
    public static List<class_2960> rareWolves = new ArrayList<class_2960>();
    public static Map<class_2960, class_2960> wolvesTame = new HashMap<class_2960, class_2960>();
    public static Map<class_2960, class_2960> wolvesAngry = new HashMap<class_2960, class_2960>();
    public static Map<class_1767, class_2960> sheep = new HashMap<class_1767, class_2960>();
    private static VariantMobTexturesClient client;
    @Config(name="Variant cows", description="If true, cows may spawn with different textures.")
    public static boolean variantCows;
    @Config(name="Variant chickens", description="If true, chickens may spawn with different textures.")
    public static boolean variantChickens;
    @Config(name="Variant pigs", description="If true, pigs may spawn with different textures.")
    public static boolean variantPigs;
    @Config(name="Variant sheep", description="If true, sheep face and 'shorn' textures match their wool color.")
    public static boolean variantSheep;
    @Config(name="Variant snow golems", description="If true, snow golems may spawn with different derp faces.")
    public static boolean variantSnowGolems;
    @Config(name="Variant squids", description="If true, squids may spawn with different textures.")
    public static boolean variantSquids;
    @Config(name="Variant wolves", description="If true, wolves may spawn with different textures.")
    public static boolean variantWolves;
    @Config(name="Rare variants", description="If true, all animals have a chance to spawn as a rare variant.")
    public static boolean rareVariants;
    @Config(name="Rarity of rare variants", description="Approximately 1 in X chance of a mob spawning as a rare variant.")
    public static int rarity;

    @Override
    public void clientInit() {
        client = new VariantMobTexturesClient(this);
    }

    @Override
    public void clientJoinWorld(class_310 client) {
        int i;
        chickens = new ArrayList<class_2960>();
        cows = new ArrayList<class_2960>();
        pigs = new ArrayList<class_2960>();
        snowGolems = new ArrayList<class_2960>();
        squids = new ArrayList<class_2960>();
        wolves = new ArrayList<class_2960>();
        wolvesTame = new HashMap<class_2960, class_2960>();
        wolvesAngry = new HashMap<class_2960, class_2960>();
        rareChickens = new ArrayList<class_2960>();
        rareCows = new ArrayList<class_2960>();
        rarePigs = new ArrayList<class_2960>();
        rareSquids = new ArrayList<class_2960>();
        rareWolves = new ArrayList<class_2960>();
        chickens.add(new class_2960("textures/entity/chicken.png"));
        cows.add(new class_2960("textures/entity/cow/cow.png"));
        pigs.add(new class_2960("textures/entity/pig/pig.png"));
        snowGolems.add(new class_2960("textures/entity/snow_golem.png"));
        squids.add(new class_2960("textures/entity/squid.png"));
        class_2960 wolf = new class_2960("textures/entity/wolf/wolf.png");
        wolves.add(wolf);
        wolvesTame.put(wolf, new class_2960("textures/entity/wolf/wolf_tame.png"));
        wolvesAngry.put(wolf, new class_2960("textures/entity/wolf/wolf_angry.png"));
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(chickens, MobType.CHICKEN, "chicken" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(rareChickens, MobType.CHICKEN, "rare_chicken" + i);
        }
        for (i = 1; i <= 7; ++i) {
            this.addCustomTextures(cows, MobType.COW, "cow" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareCows, MobType.COW, "rare_cow" + i);
        }
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(pigs, MobType.PIG, "pig" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rarePigs, MobType.PIG, "rare_pig" + i);
        }
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(snowGolems, MobType.SNOW_GOLEM, "snow_golem" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(squids, MobType.SQUID, "squid" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareSquids, MobType.SQUID, "rare_squid" + i);
        }
        for (i = 1; i <= 25; ++i) {
            this.addCustomTextures(wolves, MobType.WOLF, "nlg_wolf" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareWolves, MobType.WOLF, "rare_wolf" + i);
        }
        this.addCustomTextures(wolves, MobType.WOLF, "brownwolf", "greywolf", "blackwolf", "amotwolf", "jupiter1390");
        for (class_1767 color : class_1767.values()) {
            class_2960 res = this.createResource(MobType.SHEEP, "sheep_" + color.toString());
            sheep.put(color, res);
        }
    }

    public void addCustomTextures(List<class_2960> set, MobType type, String ... names) {
        ArrayList<String> textures = new ArrayList<String>(Arrays.asList(names));
        textures.forEach(texture -> {
            class_2960 res = this.createResource(type, (String)texture);
            set.add(res);
            if (type == MobType.WOLF) {
                wolvesTame.put(res, this.createResource(type, texture + "_tame"));
                wolvesAngry.put(res, this.createResource(type, texture + "_angry"));
            }
        });
    }

    public static class_2960 getChickenTexture(class_1428 entity) {
        return VariantMobTextures.getRandomTexture((class_1297)entity, chickens, rareChickens);
    }

    public static class_2960 getCowTexture(class_1430 entity) {
        return VariantMobTextures.getRandomTexture((class_1297)entity, cows, rareCows);
    }

    public static class_2960 getPigTexture(class_1452 entity) {
        return VariantMobTextures.getRandomTexture((class_1297)entity, pigs, rarePigs);
    }

    public static class_2960 getSheepTexture(class_1472 entity) {
        class_1767 fleeceColor = entity.method_6633();
        return sheep.getOrDefault(fleeceColor, DEFAULT_SHEEP);
    }

    public static class_2960 getSnowGolemTexture(class_1473 entity) {
        return VariantMobTextures.getRandomTexture((class_1297)entity, snowGolems, (List<class_2960>)ImmutableList.of());
    }

    public static class_2960 getSquidTexture(class_1477 entity) {
        return VariantMobTextures.getRandomTexture((class_1297)entity, squids, rareSquids);
    }

    public static class_2960 getWolfTexture(class_1493 entity) {
        class_2960 res = VariantMobTextures.getRandomTexture((class_1297)entity, wolves, rareWolves);
        if (entity.method_6181()) {
            res = wolvesTame.get(res);
        } else if (entity.method_29923(entity.field_6002)) {
            res = wolvesAngry.get(res);
        }
        return res;
    }

    public static class_2960 getRandomTexture(class_1297 entity, List<class_2960> normalSet, List<class_2960> rareSet) {
        UUID id = entity.method_5667();
        boolean isRare = rareVariants && !rareSet.isEmpty() && (id.getLeastSignificantBits() + id.getMostSignificantBits()) % (long)rarity == 0L;
        List<class_2960> set = isRare ? rareSet : normalSet;
        int choice = Math.abs((int)(id.getMostSignificantBits() % (long)set.size()));
        return set.get(choice);
    }

    private class_2960 createResource(MobType type, String texture) {
        return new class_2960("charm", PREFIX + type.method_15434() + "/" + texture + ".png");
    }

    static {
        variantCows = true;
        variantChickens = true;
        variantPigs = true;
        variantSheep = true;
        variantSnowGolems = true;
        variantSquids = true;
        variantWolves = true;
        rareVariants = true;
        rarity = 1000;
    }

    public static enum MobType implements ICharmEnum
    {
        WOLF,
        COW,
        PIG,
        CHICKEN,
        SQUID,
        SHEEP,
        SNOW_GOLEM;

    }
}

