/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_20;
import net.minecraft.class_2338;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import net.minecraft.class_3922;
import net.minecraft.class_5321;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.BiomeHelper;
import svenhjol.charm.base.helper.MapHelper;
import svenhjol.charm.base.helper.VillagerHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Wandering traders only appear near signal campfires and sell maps to biomes and structures.")
public class WanderingTraderImprovements
extends CharmModule {
    public static final List<TraderMap> traderMaps = new ArrayList<TraderMap>();
    @Config(name="Spawn near signal fire", description="If true, wandering traders will only spawn if the player is near a signal fire.")
    public static boolean spawnNearSignalFire = true;
    @Config(name="Trade biome maps", description="If true, wandering traders will sell maps to biomes.")
    public static boolean tradeBiomeMaps = true;
    @Config(name="Trade structure maps", description="If true, wandering traders will sell maps to structures.")
    public static boolean tradeStructureMaps = true;
    @Config(name="Frequent spawning", description="If true, makes wandering traders more likely to spawn after one Minecraft day.")
    public static boolean frequentSpawn = false;

    @Override
    public void init() {
        if (tradeStructureMaps) {
            traderMaps.addAll(Arrays.asList(new StructureMap(class_3195.field_24849, false), new StructureMap(class_3195.field_24858, false), new StructureMap((class_3195<?>)class_3195.field_24851, false), new StructureMap(class_3195.field_24850, false), new StructureMap(class_3195.field_24854, false), new StructureMap(class_3195.field_24843, false), new StructureMap(class_3195.field_24844, false), new StructureMap(class_3195.field_24848, false), new StructureMap(class_3195.field_24846, true), new StructureMap(class_3195.field_24847, true)));
        }
        if (tradeBiomeMaps) {
            traderMaps.addAll(Arrays.asList(new BiomeMap((class_5321<class_1959>)class_1972.field_9408, false), new BiomeMap((class_5321<class_1959>)class_1972.field_9452, false), new BiomeMap((class_5321<class_1959>)class_1972.field_9424, false), new BiomeMap((class_5321<class_1959>)class_1972.field_9455, false), new BiomeMap((class_5321<class_1959>)class_1972.field_9435, false), new BiomeMap((class_5321<class_1959>)class_1972.field_9415, true), new BiomeMap((class_5321<class_1959>)class_1972.field_9414, true), new BiomeMap((class_5321<class_1959>)class_1972.field_9462, true), new BiomeMap((class_5321<class_1959>)class_1972.field_9440, true), new BiomeMap((class_5321<class_1959>)class_1972.field_9453, true)));
        }
        for (int i = 0; i < 3; ++i) {
            VillagerHelper.addWanderingTrade(new StructureMapForEmeraldsTrade(), false);
        }
    }

    public static boolean checkSpawnConditions(class_1937 world, class_2338 pos) {
        class_2338 pos2;
        if (!ModuleHandler.enabled("charm:wandering_trader_improvements")) {
            return true;
        }
        if (!spawnNearSignalFire) {
            return true;
        }
        class_2338 pos1 = pos.method_10069(-24, -24, -24);
        boolean foundFire = class_2338.method_20437((class_2338)pos1, (class_2338)(pos2 = pos.method_10069(24, 24, 24))).anyMatch(p -> {
            class_2680 state = world.method_8320(p);
            return state.method_26204() instanceof class_3922 && state.method_28498((class_2769)class_3922.field_17353) && (Boolean)state.method_11654((class_2769)class_3922.field_17353) != false;
        });
        Charm.LOG.debug(foundFire ? "Found signal fire within range of player, attempting to spawn Wandering Trader." : "No signal fire within range of player, not spawning Wandering Trader.");
        return foundFire;
    }

    public static boolean shouldSpawnFrequently() {
        return ModuleHandler.enabled("charm:wandering_trader_improvements") && frequentSpawn;
    }

    public static class StructureMap
    implements TraderMap {
        public class_3195<?> structure;
        public boolean rare;

        public StructureMap(class_3195<?> structure, boolean rare) {
            this.structure = structure;
            this.rare = rare;
        }

        @Override
        public class_1799 getMap(class_3218 world, class_2338 pos) {
            int color = 0x662200;
            class_2338 nearestStructure = world.method_8487(this.structure, pos, 2000, true);
            if (nearestStructure == null) {
                return null;
            }
            class_2588 structureName = new class_2588("structure.charm." + this.structure.method_14019());
            class_2588 mapName = new class_2588("filled_map.charm.trader_map", new Object[]{structureName});
            return MapHelper.getMap(world, nearestStructure, mapName, class_20.class_21.field_84, color);
        }

        @Override
        public int getCost(Random rand) {
            return this.rare ? rand.nextInt(4) + 6 : rand.nextInt(2) + 2;
        }
    }

    public static class BiomeMap
    implements TraderMap {
        public class_5321<class_1959> biomeKey;
        public boolean rare;

        public BiomeMap(class_5321<class_1959> biomeKey, boolean rare) {
            this.biomeKey = biomeKey;
            this.rare = rare;
        }

        @Override
        public class_1799 getMap(class_3218 world, class_2338 pos) {
            int color = 8806;
            class_2338 nearestBiome = BiomeHelper.locateBiome(this.biomeKey, world, pos);
            String biomeName = this.biomeKey.method_29177().method_12832();
            if (nearestBiome == null) {
                return null;
            }
            class_2588 mapName = new class_2588("filled_map.charm.trader_map", new Object[]{new class_2588("biome.minecraft." + biomeName)});
            return MapHelper.getMap(world, nearestBiome, mapName, class_20.class_21.field_84, color);
        }

        @Override
        public int getCost(Random rand) {
            return this.rare ? rand.nextInt(3) + 3 : rand.nextInt(1) + 1;
        }
    }

    public static class StructureMapForEmeraldsTrade
    implements class_3853.class_1652 {
        public class_1914 method_7246(class_1297 trader, Random rand) {
            class_1799 map;
            TraderMap traderMap = traderMaps.get(rand.nextInt(traderMaps.size()));
            if (!trader.field_6002.field_9236 && (map = traderMap.getMap((class_3218)trader.field_6002, trader.method_24515())) != null) {
                class_1799 in1 = new class_1799((class_1935)class_1802.field_8687, traderMap.getCost(rand));
                class_1799 in2 = new class_1799((class_1935)class_1802.field_8251);
                return new class_1914(in1, in2, map, 1, 5, 0.2f);
            }
            return null;
        }
    }

    public static interface TraderMap {
        public class_1799 getMap(class_3218 var1, class_2338 var2);

        public int getCost(Random var1);
    }
}

