/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker;

import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private int flashStartTime;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ClearDespawn")) {
            this.loadConfig();
        }
    }

    public void onConfigChanging(ConfigChangedEvent.OnConfigChangingEvent event) {
        if (event.getModID().equals("ClearDespawn")) {
            switch (event.getItem()) {
                case "cleardespawn.config.timeleft": {
                    this.flashStartTime = (Integer)event.getNewValue();
                }
            }
        }
    }

    private void loadConfig() {
        this.flashStartTime = this.config.getInt("cleardespawn.config.timeleft", 0, 20, 0, 300, "cleardespawn.config.tt.timeleft");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static int getFlashStartTime() {
        return ConfigurationHandler.getInstance().flashStartTime;
    }
}

