/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.client.core;

import java.util.HashSet;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketStopPlayingTrack;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.play.NotePlayThread;
import me.ichun.mods.clef.common.util.abc.play.PlayedNote;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerClient {
    public HashSet<Track> tracksPlaying = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc;
        if (event.phase == TickEvent.Phase.START && !(mc = Minecraft.func_71410_x()).func_147113_T() && !this.tracksPlaying.isEmpty()) {
            boolean wasLocked = NotePlayThread.INSTANCE.startNewTick();
            try {
                this.tracksPlaying.removeIf(track -> !track.tick());
            }
            finally {
                NotePlayThread.INSTANCE.endTick(wasLocked);
            }
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Minecraft.func_71410_x().execute(this::disconnectFromServer);
    }

    public void disconnectFromServer() {
        this.tracksPlaying.clear();
        AbcLibrary.requestedABCFromServer.clear();
        InstrumentLibrary.requestedInstrumentsFromServer.clear();
    }

    public void addTrack(Track track) {
        this.tracksPlaying.remove(track);
        if (track.hasObjectsPlaying() && track.playing) {
            this.tracksPlaying.add(track);
        }
    }

    public Track findTrackByBand(String bandName) {
        for (Track track : this.tracksPlaying) {
            if (!track.getBandName().equalsIgnoreCase(bandName)) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(PlayerEntity player) {
        for (Track track : this.tracksPlaying) {
            if (!track.players.containsKey(player) && !track.playersNames.contains(player.func_200200_C_().func_150261_e())) continue;
            return track;
        }
        return null;
    }

    @SubscribeEvent
    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack is = ItemInstrument.getUsableInstrument((LivingEntity)event.getPlayer());
        if (!is.func_190926_b() && (event.getPlayer().func_184614_ca().func_190926_b() || event.getPlayer().func_184592_cb().func_190926_b())) {
            this.stopPlayingTrack(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack is = ItemInstrument.getUsableInstrument((LivingEntity)event.getPlayer());
        if (!is.func_190926_b() && (event.getPlayer().func_184614_ca().func_190926_b() || event.getPlayer().func_184592_cb().func_190926_b())) {
            this.stopPlayingTrack(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onSoundSystemReload(SoundLoadEvent event) {
        boolean locked = NotePlayThread.INSTANCE.acquireLock();
        try {
            PlayedNote.clearCache();
        }
        finally {
            NotePlayThread.INSTANCE.releaseLock(locked);
        }
    }

    public void stopPlayingTrack(PlayerEntity player) {
        Track track = this.getTrackPlayedByPlayer(player);
        if (track != null) {
            Clef.channel.sendToServer((AbstractPacket)new PacketStopPlayingTrack(track.getId()));
        }
    }
}

