/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import me.ichun.mods.clef.client.gui.GuiPlayTrack;
import me.ichun.mods.clef.client.gui.GuiTrackList;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.inventory.ContainerInstrumentPlayer;
import me.ichun.mods.clef.common.packet.PacketInstrumentPlayerInfo;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.BaseTrackFile;
import me.ichun.mods.ichunutil.client.core.ResourceHelper;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPlayTrackBlock
extends GuiPlayTrack
implements IHasContainer<ContainerInstrumentPlayer> {
    public final TileEntityInstrumentPlayer player;
    public final ContainerInstrumentPlayer containerInstrumentPlayer;
    protected Slot hoveredSlot;
    public int repeat = 0;
    public int shuffle = 0;
    public List<BaseTrackFile> playlist;
    public boolean playlistView = false;

    public GuiPlayTrackBlock(ContainerInstrumentPlayer container) {
        this.background = texBackgroundBlock;
        this.containerInstrumentPlayer = container;
        this.player = container.inventory;
        this.disableListWhenSyncTrack = false;
        this.playlist = new ArrayList<BaseTrackFile>(this.player.tracks);
        this.bandNameString = this.player.bandName.isEmpty() ? Clef.configClient.favoriteBand : this.player.bandName;
        this.syncPlay = this.player.syncPlay ? 1 : 0;
        this.syncTrack = this.player.syncTrack ? 1 : 0;
        this.repeat = this.player.repeat;
        this.shuffle = this.player.shuffle ? 1 : 0;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230705_e_.remove((Object)this.trackList);
        this.trackListBottom -= 22;
        this.trackList = new GuiTrackList(this, 158, this.ySize - 22, this.guiTop + 17, this.trackListBottom, this.guiLeft + 7, 8, this.playlistView ? this.playlist : this.tracks);
        this.field_230705_e_.add(this.trackList);
        this.buttonConfirm.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.done"));
    }

    @Override
    public void addButtons() {
        if (!this.playlistView) {
            super.addButtons();
            this.func_230480_a_((Widget)new Button(this.guiLeft + 116 - 55, this.guiTop + 205, 50, 20, (ITextComponent)new TranslationTextComponent("clef.gui.block.addPlaylist"), btn -> {
                if (this.index >= 0 && this.index < this.tracks.size() && !this.playlist.contains(this.tracks.get(this.index))) {
                    this.playlist.add((BaseTrackFile)this.tracks.get(this.index));
                }
            }));
            this.func_230480_a_((Widget)new Button(this.guiLeft + 116, this.guiTop + 205, 50, 20, (ITextComponent)new TranslationTextComponent("clef.gui.block.viewPlaylist"), btn -> {
                if (this.doneTimeout < 0) {
                    this.togglePlaylistView();
                }
            }));
        } else {
            this.func_230480_a_((Widget)new Button(this.guiLeft + 179, this.guiTop + 51, 72, 20, (ITextComponent)new TranslationTextComponent(this.repeat == 0 ? "clef.gui.block.repeatNone" : (this.repeat == 1 ? "clef.gui.block.repeatAll" : "clef.gui.block.repeatOne")), btn -> {
                ++this.repeat;
                if (this.repeat > 2) {
                    this.repeat = 0;
                }
                btn.func_238482_a_((ITextComponent)new TranslationTextComponent(this.repeat == 0 ? "clef.gui.block.repeatNone" : (this.repeat == 1 ? "clef.gui.block.repeatAll" : "clef.gui.block.repeatOne")));
            }));
            this.func_230480_a_((Widget)new Button(this.guiLeft + 179, this.guiTop + 94, 72, 20, (ITextComponent)new TranslationTextComponent(this.shuffle == 1 ? "gui.yes" : "gui.no"), btn -> {
                this.shuffle = this.shuffle == 1 ? 0 : 1;
                btn.func_238482_a_((ITextComponent)new TranslationTextComponent(this.shuffle == 1 ? "gui.yes" : "gui.no"));
            }));
            this.func_230480_a_((Widget)new Button(this.guiLeft + 116, this.guiTop + 205, 50, 20, (ITextComponent)new TranslationTextComponent("clef.gui.block.viewAll"), btn -> {
                if (this.doneTimeout < 0) {
                    this.togglePlaylistView();
                }
            }));
            this.func_230480_a_((Widget)new Button(this.guiLeft + 6, this.guiTop + 205, 20, 20, StringTextComponent.field_240750_d_, btn -> {
                if (this.index >= 0 && this.index < this.playlist.size() && this.index > 0) {
                    BaseTrackFile file = this.playlist.get(this.index);
                    this.playlist.remove(this.index);
                    this.playlist.add(this.index - 1, file);
                    --this.index;
                }
                this.trackList.setTracks(this.playlist);
            }));
            this.func_230480_a_((Widget)new Button(this.guiLeft + 30, this.guiTop + 205, 20, 20, StringTextComponent.field_240750_d_, btn -> {
                if (this.index >= 0 && this.index < this.playlist.size() && this.index < this.playlist.size() - 1) {
                    BaseTrackFile file = this.playlist.get(this.index);
                    this.playlist.remove(this.index);
                    this.playlist.add(this.index + 1, file);
                    ++this.index;
                }
                this.trackList.setTracks(this.playlist);
            }));
            this.func_230480_a_((Widget)new Button(this.guiLeft + 54, this.guiTop + 205, 20, 20, StringTextComponent.field_240750_d_, btn -> {
                if (this.index >= 0 && this.index < this.playlist.size()) {
                    this.playlist.remove(this.index);
                    if (this.playlist.size() <= this.index) {
                        this.index = this.playlist.size() - 1;
                    }
                }
                this.trackList.setTracks(this.playlist);
            }));
        }
    }

    @Override
    public void drawText(MatrixStack stack) {
        if (!this.playlistView) {
            this.field_230712_o_.func_238405_a_(stack, I18n.func_135052_a((String)"clef.gui.block.playlist", (Object[])new Object[0]) + ":", (float)(this.guiLeft + 9), (float)(this.guiTop + 211), 0xFFFFFF);
            super.drawText(stack);
        } else {
            this.field_230712_o_.func_238405_a_(stack, I18n.func_135052_a((String)"clef.gui.block.playlist", (Object[])new Object[0]) + " (" + this.playlist.size() + ")", (float)(this.guiLeft + 6), (float)(this.guiTop + 5), 0xFFFFFF);
            this.field_230712_o_.func_238405_a_(stack, I18n.func_135052_a((String)"clef.gui.block.repeat", (Object[])new Object[0]), (float)(this.guiLeft + 179), (float)(this.guiTop + 40), 0xFFFFFF);
            this.field_230712_o_.func_238405_a_(stack, I18n.func_135052_a((String)"clef.gui.block.shuffle", (Object[])new Object[0]), (float)(this.guiLeft + 179), (float)(this.guiTop + 83), 0xFFFFFF);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        stack.func_227860_a_();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        this.hoveredSlot = null;
        RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = 0; i1 < this.containerInstrumentPlayer.field_75151_b.size(); ++i1) {
            Slot slot = (Slot)this.containerInstrumentPlayer.field_75151_b.get(i1);
            this.drawSlot(stack, slot);
            if (!this.isMouseOverSlot(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            this.hoveredSlot = slot;
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            int j1 = slot.field_75223_e;
            int k1 = slot.field_75221_f;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_238468_a_(stack, j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
        }
        stack.func_227865_b_();
        RenderSystem.popMatrix();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        this.renderHoveredToolTip(stack, mouseX, mouseY);
        RenderSystem.enableDepthTest();
    }

    protected void renderHoveredToolTip(MatrixStack stack, int mouseX, int mouseY) {
        if (this.hoveredSlot != null && this.hoveredSlot.func_75216_d()) {
            this.func_230457_a_(stack, this.hoveredSlot.func_75211_c(), mouseX, mouseY);
        }
    }

    private Slot getSlotAtPosition(double x, double y) {
        for (int i = 0; i < this.containerInstrumentPlayer.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.containerInstrumentPlayer.field_75151_b.get(i);
            if (!this.isMouseOverSlot(slot, x, y) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    protected void handleMouseClick(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        this.field_230706_i_.field_71442_b.func_187098_a(this.containerInstrumentPlayer.field_75152_c, slotId, mouseButton, type, (PlayerEntity)this.field_230706_i_.field_71439_g);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        Slot slot;
        boolean flag = super.func_231044_a_(mouseX, mouseY, mouseButton);
        if ((mouseButton == 0 || mouseButton == 1) && (slot = this.getSlotAtPosition(mouseX, mouseY)) != null) {
            this.handleMouseClick(slot, slot.field_75222_d, mouseButton, ClickType.PICKUP);
            return true;
        }
        return flag;
    }

    @Override
    public void addReloadButtons() {
    }

    @Override
    public void drawReloadButtons(MatrixStack stack) {
        if (this.playlistView) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(ResourceHelper.TEX_RESOURCE_PACKS);
            this.func_238474_b_(stack, this.guiLeft - 8, this.guiTop + 206, 96, 0, 32, 32);
            this.func_238474_b_(stack, this.guiLeft + 32, this.guiTop + 191, 80, 0, 32, 32);
            this.field_230706_i_.func_110434_K().func_110577_a(ResourceHelper.TEX_SPECTATOR_WIDGETS);
            this.func_238474_b_(stack, this.guiLeft + 40, this.guiTop + 207, 112, 0, 32, 32);
        }
    }

    public void togglePlaylistView() {
        this.doneTimeout = 2;
        this.index = -1;
        this.playlistView = !this.playlistView;
        this.func_231158_b_(this.field_230706_i_, this.field_230706_i_.func_228018_at_().func_198107_o(), this.field_230706_i_.func_228018_at_().func_198087_p());
        this.trackList.setTracks(this.playlistView ? this.playlist : this.tracks);
    }

    @Override
    public void confirmSelection(boolean doubleClick) {
        if (doubleClick) {
            if (!this.playlistView && this.index >= 0 && this.index < this.tracks.size() && !this.playlist.contains(this.tracks.get(this.index))) {
                this.playlist.add((BaseTrackFile)this.tracks.get(this.index));
            } else if (this.playlistView && this.index >= 0 && this.index < this.playlist.size() && !this.playlist.isEmpty()) {
                this.playlist.remove(this.index);
                if (this.index >= this.playlist.size()) {
                    this.index = this.playlist.size() - 1;
                }
            }
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return;
        }
        if (this.playlist.isEmpty()) {
            if (this.playlistView) {
                return;
            }
            if (this.index >= 0 && this.index < this.tracks.size() && !this.playlist.contains(this.tracks.get(this.index))) {
                this.playlist.add((BaseTrackFile)this.tracks.get(this.index));
            }
        }
        ArrayList<String> md5s = new ArrayList<String>();
        for (BaseTrackFile track : this.playlist) {
            md5s.add(track.md5);
        }
        Clef.channel.sendToServer((AbstractPacket)new PacketInstrumentPlayerInfo(md5s, this.bandName.func_146179_b(), this.syncPlay == 1, this.syncTrack == 1, this.repeat, this.shuffle == 1, this.player.func_174877_v()));
        this.func_231175_as__();
        this.field_230706_i_.field_71417_B.func_198034_i();
    }

    @Override
    public void func_231175_as__() {
        this.field_230706_i_.field_71439_g.func_71053_j();
    }

    private boolean isMouseOverSlot(Slot slotIn, double mouseX, double mouseY) {
        return this.isPointInRegion(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        int i = this.guiLeft;
        int j = this.guiTop;
        return (pointX -= (double)i) >= (double)(rectX - 1) && pointX < (double)(rectX + rectWidth + 1) && (pointY -= (double)j) >= (double)(rectY - 1) && pointY < (double)(rectY + rectHeight + 1);
    }

    private void drawSlot(MatrixStack stack, Slot slotIn) {
        Pair pair;
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = false;
        String s = null;
        this.func_230926_e_(100);
        this.field_230707_j_.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (pair = slotIn.func_225517_c_()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.field_230706_i_.func_228015_a_((ResourceLocation)pair.getFirst()).apply(pair.getSecond());
            this.field_230706_i_.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
            GuiPlayTrackBlock.func_238470_a_((MatrixStack)stack, (int)i, (int)j, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                GuiPlayTrackBlock.func_238467_a_((MatrixStack)stack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            RenderSystem.enableDepthTest();
            this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, itemstack, i, j);
            this.field_230707_j_.func_180453_a(this.field_230712_o_, itemstack, i, j, s);
        }
        this.field_230707_j_.field_77023_b = 0.0f;
        this.func_230926_e_(0);
    }

    public ContainerInstrumentPlayer getContainer() {
        return this.containerInstrumentPlayer;
    }
}

