/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.RandomStringUtils;

public class EventHandlerServer {
    public HashSet<Track> tracksPlaying = new HashSet();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && iChunUtil.eventHandlerServer.ticks + 5 == 2) {
            ItemStack isMain = event.player.func_184614_ca();
            ItemStack isOff = event.player.func_184592_cb();
            if (isMain.func_77973_b() == Clef.Items.INSTRUMENT.get()) {
                InstrumentLibrary.checkForInstrument(isMain, (ServerPlayerEntity)event.player);
            }
            if (isOff.func_77973_b() == Clef.Items.INSTRUMENT.get()) {
                InstrumentLibrary.checkForInstrument(isOff, (ServerPlayerEntity)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            this.checkItem(event.getEntityItem(), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDropsEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof ServerPlayerEntity) {
            for (ItemEntity item : event.getDrops()) {
                this.checkItem(item, (ServerPlayerEntity)event.getEntityLiving());
            }
        }
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && (!Clef.configCommon.onlyHostileMobSpawn || event.getEntityLiving() instanceof IMob) && event.getEntityLiving().func_70681_au().nextFloat() < (float)Clef.configCommon.mobDropRate / 10000.0f * (float)(event.getLootingLevel() + 1)) {
            ItemStack stack = new ItemStack((IItemProvider)Clef.Items.INSTRUMENT.get());
            InstrumentLibrary.assignRandomInstrument(stack);
            ItemEntity itementity = new ItemEntity(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), stack);
            itementity.func_174869_p();
            event.getDrops().add(itementity);
        }
    }

    public void checkItem(ItemEntity item, ServerPlayerEntity player) {
        String instName;
        Instrument is;
        CompoundNBT tag;
        if (item.func_92059_d().func_77973_b() == Clef.Items.INSTRUMENT.get() && (tag = item.func_92059_d().func_77978_p()) != null && (is = InstrumentLibrary.getInstrumentByName(instName = tag.func_74779_i("itemName"))) == null) {
            InstrumentLibrary.requestInstrument(instName, player);
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        ZombieEntity zombie;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof ZombieEntity && event.getEntityLiving().func_70681_au().nextFloat() < (float)Clef.configCommon.zombieSpawnRate / 10000.0f && (zombie = (ZombieEntity)event.getEntityLiving()).func_184614_ca().func_190926_b()) {
            ItemStack stack = new ItemStack((IItemProvider)Clef.Items.INSTRUMENT.get());
            InstrumentLibrary.assignRandomInstrument(stack);
            zombie.func_184611_a(Hand.MAIN_HAND, stack);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ZombieEntity zombie;
        if (Clef.configCommon.zombiesCanUseInstruments && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof ZombieEntity && (zombie = (ZombieEntity)event.getEntityLiving()).func_70681_au().nextFloat() < 0.004f && !ItemInstrument.getUsableInstrument((LivingEntity)zombie).func_190926_b() && this.getTrackPlayedByPlayer(zombie) == null) {
            Track track = Clef.eventHandlerServer.findTrackByBand("zombies");
            if (track != null) {
                if (track.zombies.add(zombie.func_145782_y())) {
                    Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
                }
            } else {
                List<TrackFile> tracks = AbcLibrary.getTracks();
                TrackFile randTrack = tracks.get(zombie.func_70681_au().nextInt(tracks.size()));
                track = new Track(RandomStringUtils.randomAscii((int)20), "zombies", randTrack, false);
                if (randTrack.track.trackLength > 0) {
                    track.playAtProgress(zombie.func_70681_au().nextInt(randTrack.track.trackLength));
                }
                Clef.eventHandlerServer.tracksPlaying.add(track);
                track.zombies.add(zombie.func_145782_y());
                Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
            }
        }
    }

    @SubscribeEvent
    public void onLootTableEvent(LootTableLoadEvent event) {
        if (Clef.configCommon.lootSpawnRate > 0) {
            for (String s : Clef.configCommon.disabledLootChests) {
                if (!event.getName().toString().equals(s)) continue;
                return;
            }
            if (event.getName().func_110623_a().startsWith("chest")) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Clef.Items.INSTRUMENT.get())).func_216086_a(Clef.configCommon.lootSpawnRate).func_212841_b_(() -> new LootFunction(new ILootCondition[0]){

                    public LootFunctionType func_230425_b_() {
                        return null;
                    }

                    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
                        InstrumentLibrary.assignRandomInstrument(stack);
                        return stack;
                    }
                })).name("clef_instrument").func_216044_b());
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Track> ite = this.tracksPlaying.iterator();
            while (ite.hasNext()) {
                Track track = ite.next();
                if (track.tick()) continue;
                ite.remove();
            }
        }
    }

    public void stopPlayingTrack(ServerPlayerEntity player, String trackId) {
        for (Track track : this.tracksPlaying) {
            if (!track.getId().equals(trackId)) continue;
            track.players.remove(player);
            if (!track.hasObjectsPlaying()) {
                track.stop();
            }
            Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
            break;
        }
    }

    public Track getTrackPlayedByPlayer(ZombieEntity zombie) {
        for (Track track : this.tracksPlaying) {
            if (!track.zombies.contains(zombie.func_145782_y())) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(TileEntityInstrumentPlayer player) {
        for (Track track : this.tracksPlaying) {
            if (!track.instrumentPlayers.containsKey(player.func_145831_w().func_234923_W_().func_240901_a_()) || !track.instrumentPlayers.get(player.func_145831_w().func_234923_W_().func_240901_a_()).contains(player.func_174877_v())) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(PlayerEntity player) {
        for (Track track : this.tracksPlaying) {
            if (!track.players.containsKey(player)) continue;
            return track;
        }
        return null;
    }

    public Track findTrackByBand(String bandName) {
        for (Track track : this.tracksPlaying) {
            if (!track.getBandName().equalsIgnoreCase(bandName)) continue;
            return track;
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        HashSet<Track> tracks = new HashSet<Track>();
        for (Track track : this.tracksPlaying) {
            if (track.getTrackFile() == null) continue;
            tracks.add(track);
        }
        AbcLibrary.startPlayingTrack((ServerPlayerEntity)event.getPlayer(), tracks.toArray(new Track[tracks.size()]));
    }

    @SubscribeEvent
    public void onServerStoppingEvent(FMLServerStoppingEvent event) {
        this.shutdownServer();
    }

    public void shutdownServer() {
        this.tracksPlaying.clear();
        AbcLibrary.tracksWaitingForTrackInfo.clear();
        AbcLibrary.requestedABCFromPlayers.clear();
        InstrumentLibrary.requestsFromPlayers.clear();
        InstrumentLibrary.requestedInstrumentsFromPlayers.clear();
    }
}

