/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.packet;

import java.util.ArrayList;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.BaseTrackFile;
import me.ichun.mods.clef.common.util.abc.PendingTrackFile;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketInstrumentPlayerInfo
extends AbstractPacket {
    public ArrayList<String> abc_md5s;
    public String bandName;
    public boolean syncPlay;
    public boolean syncTrack;
    public int repeat;
    public boolean shuffle;
    public BlockPos pos;

    public PacketInstrumentPlayerInfo() {
    }

    public PacketInstrumentPlayerInfo(ArrayList<String> abc, String bandName, boolean syncPlay, boolean syncTrack, int repeat, boolean shuffle, BlockPos pos) {
        this.abc_md5s = abc;
        this.bandName = bandName;
        this.syncPlay = syncPlay;
        this.syncTrack = syncTrack;
        this.repeat = repeat;
        this.shuffle = shuffle;
        this.pos = pos;
    }

    public void writeTo(PacketBuffer buf) {
        buf.writeInt(this.abc_md5s.size());
        for (String s : this.abc_md5s) {
            buf.func_180714_a(s);
        }
        buf.func_180714_a(this.bandName);
        buf.writeBoolean(this.syncPlay);
        buf.writeBoolean(this.syncTrack);
        buf.writeInt(this.repeat);
        buf.writeBoolean(this.shuffle);
        buf.func_179255_a(this.pos);
    }

    public void readFrom(PacketBuffer buf) {
        this.abc_md5s = new ArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.abc_md5s.add(this.readString(buf));
        }
        this.bandName = this.readString(buf);
        this.syncPlay = buf.readBoolean();
        this.syncTrack = buf.readBoolean();
        this.repeat = buf.readInt();
        this.shuffle = buf.readBoolean();
        this.pos = buf.func_179259_c();
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            TileEntity te = player.field_70170_p.func_175625_s(this.pos);
            if (te instanceof TileEntityInstrumentPlayer) {
                TileEntityInstrumentPlayer instrumentPlayer = (TileEntityInstrumentPlayer)te;
                instrumentPlayer.tracks.clear();
                for (String s : this.abc_md5s) {
                    BaseTrackFile track = AbcLibrary.getTrack(s);
                    if (track == null) {
                        Clef.channel.sendTo((AbstractPacket)new PacketRequestFile(s, false), player);
                        track = new PendingTrackFile(s);
                    }
                    instrumentPlayer.tracks.add(track);
                }
                instrumentPlayer.bandName = this.bandName;
                instrumentPlayer.syncPlay = this.syncPlay;
                instrumentPlayer.syncTrack = this.syncTrack;
                instrumentPlayer.repeat = this.repeat;
                instrumentPlayer.shuffle = this.shuffle;
                instrumentPlayer.func_70296_d();
                BlockState state = player.field_70170_p.func_180495_p(this.pos);
                player.field_70170_p.func_184138_a(this.pos, state, state, 3);
            }
        });
    }
}

