/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.inventory.ContainerInstrumentPlayer;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.BaseTrackFile;
import me.ichun.mods.clef.common.util.abc.PendingTrackFile;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.RandomStringUtils;

public class TileEntityInstrumentPlayer
extends TileEntity
implements ITickableTileEntity,
IInventory,
INamedContainerProvider {
    public ArrayList<BaseTrackFile> tracks = new ArrayList();
    public String bandName = "";
    public boolean syncPlay = true;
    public boolean syncTrack = false;
    public int repeat = 0;
    public boolean shuffle = true;
    public int playlistIndex = 0;
    public HashSet<String> playedTracks = new HashSet();
    private NonNullList<ItemStack> contents = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    public boolean previousRedstoneState;
    public boolean justCreatedInstrument;
    public Track lastTrack;

    public TileEntityInstrumentPlayer() {
        super((TileEntityType)Clef.TileEntityTypes.INSTRUMENT_PLAYER.get());
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.justCreatedInstrument) {
                this.justCreatedInstrument = false;
            }
            if (iChunUtil.eventHandlerServer.ticks % 100 == 0 && !this.tracks.stream().allMatch(BaseTrackFile::isSynced)) {
                HashSet<PendingTrackFile> toRemove = null;
                int size = this.tracks.size();
                for (int i = 0; i < size; ++i) {
                    BaseTrackFile baseTrackFile = this.tracks.get(i);
                    if (baseTrackFile.isSynced()) continue;
                    PendingTrackFile pending = (PendingTrackFile)baseTrackFile;
                    TrackFile file = pending.resolve();
                    if (file != null) {
                        this.tracks.set(i, file);
                        continue;
                    }
                    if (pending.getResolveTries() <= 20) continue;
                    if (toRemove == null) {
                        toRemove = new HashSet<PendingTrackFile>();
                    }
                    toRemove.add(pending);
                }
                if (toRemove != null) {
                    this.tracks.removeAll(toRemove);
                }
            }
            if (this.previousRedstoneState) {
                boolean hasInst = false;
                for (ItemStack is : this.contents) {
                    if (is == null || is.func_77973_b() != Clef.Items.INSTRUMENT.get()) continue;
                    hasInst = true;
                    break;
                }
                if (hasInst) {
                    HashSet players;
                    Track track;
                    Track track2 = Clef.eventHandlerServer.getTrackPlayedByPlayer(this);
                    if (track2 == null && (this.shuffle && this.playedTracks.size() < this.tracks.size() || !this.shuffle && this.playlistIndex < this.tracks.size())) {
                        Track track3;
                        BaseTrackFile file = null;
                        int index = -1;
                        if (this.shuffle) {
                            for (int tries = 0; tries < 1000; ++tries) {
                                index = this.func_145831_w().field_73012_v.nextInt(this.tracks.size());
                                file = this.tracks.get(index);
                                if (tries < 500 && !file.isSynced() || this.playedTracks.contains(file.md5)) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            index = this.playlistIndex;
                            file = this.tracks.get(this.playlistIndex);
                        }
                        if (file == null) {
                            return;
                        }
                        if (!file.isSynced()) {
                            TrackFile newFile = AbcLibrary.getTrack(file.md5);
                            if (newFile != null) {
                                if (index != -1) {
                                    this.tracks.set(index, newFile);
                                }
                                file = newFile;
                            } else {
                                return;
                            }
                        }
                        if (!this.bandName.isEmpty()) {
                            Track track1 = track3 = Clef.eventHandlerServer.findTrackByBand(this.bandName);
                            if (track3 == null || !this.syncTrack) {
                                track3 = new Track(RandomStringUtils.randomAscii((int)20), this.bandName, file, false);
                            }
                            if (this.syncPlay && track1 != null) {
                                track3.playAtProgress(track1.playProg);
                            }
                            if (this.lastTrack != null && this.lastTrack.getBandName().equals(this.bandName)) {
                                track3.players = this.lastTrack.players;
                            }
                        } else {
                            track3 = new Track(RandomStringUtils.randomAscii((int)20), this.bandName, file, false);
                        }
                        Clef.eventHandlerServer.tracksPlaying.add(track3);
                        HashSet players2 = track3.instrumentPlayers.computeIfAbsent(this.field_145850_b.func_234923_W_().func_240901_a_(), v -> new HashSet());
                        if (players2.add(this.func_174877_v())) {
                            Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track3), PacketDistributor.ALL.noArg());
                        }
                        this.lastTrack = track3;
                        if (this.shuffle && this.repeat != 1 && file.md5.equals(track3.getTrackFile().md5)) {
                            this.playedTracks.add(track3.getTrackFile().md5);
                        }
                        ++this.playlistIndex;
                        if (this.repeat == 1 && this.playlistIndex >= this.tracks.size()) {
                            this.playlistIndex = 0;
                        }
                    } else if (!this.bandName.isEmpty() && this.syncTrack && (track = Clef.eventHandlerServer.findTrackByBand(this.bandName)) != null && (players = track.instrumentPlayers.computeIfAbsent(this.field_145850_b.func_234923_W_().func_240901_a_(), v -> new HashSet())).add(this.func_174877_v())) {
                        Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
                    }
                }
            }
        }
    }

    public void changeRedstoneState(boolean newState) {
        if (newState) {
            this.playedTracks.clear();
            if (this.repeat != 2) {
                this.playlistIndex = this.shuffle && !this.tracks.isEmpty() ? this.func_145831_w().field_73012_v.nextInt(this.tracks.size()) : 0;
            }
        } else {
            Track track = Clef.eventHandlerServer.getTrackPlayedByPlayer(this);
            if (track != null) {
                HashSet<BlockPos> players = track.instrumentPlayers.get(this.field_145850_b.func_234923_W_().func_240901_a_());
                if (players != null) {
                    players.remove(this.func_174877_v());
                    if (players.isEmpty()) {
                        track.instrumentPlayers.remove(this.field_145850_b.func_234923_W_().func_240901_a_());
                    }
                }
                if (!track.hasObjectsPlaying()) {
                    track.stop();
                }
                Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
            }
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        int i;
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.contents);
        tag.func_74757_a("powered", this.previousRedstoneState);
        tag.func_74768_a("trackCount", this.tracks.size());
        for (i = 0; i < this.tracks.size(); ++i) {
            BaseTrackFile file = this.tracks.get(i);
            tag.func_74778_a("track_" + i, file.md5);
            tag.func_74778_a("track_title_" + i, file.getTitle());
        }
        tag.func_74778_a("bandName", this.bandName);
        tag.func_74757_a("syncPlay", this.syncPlay);
        tag.func_74757_a("syncTrack", this.syncTrack);
        tag.func_74768_a("repeat", this.repeat);
        tag.func_74757_a("shuffle", this.shuffle);
        tag.func_74768_a("playedCount", this.playedTracks.size());
        i = 0;
        for (String s : this.playedTracks) {
            tag.func_74778_a("played_" + i, s);
            ++i;
        }
        tag.func_74768_a("playlistIndex", this.playlistIndex);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        int i;
        super.func_230337_a_(state, tag);
        this.contents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.contents);
        this.previousRedstoneState = tag.func_74767_n("powered");
        this.tracks.clear();
        int size = tag.func_74762_e("trackCount");
        for (i = 0; i < size; ++i) {
            String md5 = tag.func_74779_i("track_" + i);
            String title = tag.func_150297_b("track_title_" + i, 8) ? tag.func_74779_i("track_title_" + i) : null;
            TrackFile file = AbcLibrary.getTrack(md5);
            if (file != null) {
                this.tracks.add(file);
                continue;
            }
            this.tracks.add(new PendingTrackFile(md5, title));
        }
        size = tag.func_74762_e("playedCount");
        for (i = 0; i < size; ++i) {
            this.playedTracks.add(tag.func_74779_i("played_" + i));
        }
        this.bandName = tag.func_74779_i("bandName");
        this.syncPlay = tag.func_74767_n("syncPlay");
        this.syncTrack = tag.func_74767_n("syncTrack");
        this.repeat = tag.func_74762_e("repeat");
        this.shuffle = tag.func_74767_n("shuffle");
        this.playlistIndex = MathHelper.func_76125_a((int)tag.func_74762_e("playlistIndex"), (int)0, (int)this.tracks.size());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("clef.instrument_player");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerInstrumentPlayer(id, playerInventory, () -> this);
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.contents.get(index);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.contents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.contents, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == Clef.Items.INSTRUMENT.get();
    }

    public void func_174888_l() {
        this.contents.clear();
    }
}

