/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.ichun.mods.clef.common.Clef;
import net.minecraftforge.fml.loading.FMLPaths;

public class ResourceHelper {
    private static boolean init = false;
    private static boolean allGood = false;
    private static Path workingDir;
    private static Path abcDir;
    private static Path instrumentDir;

    private static void init() {
        if (init) {
            return;
        }
        workingDir = FMLPaths.MODSDIR.get().resolve("clef");
        if (!Files.exists(workingDir, new LinkOption[0])) {
            try {
                Files.createDirectory(workingDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Clef.LOGGER.fatal("Error creating working directory!");
                e.printStackTrace();
                return;
            }
        }
        if (!Files.exists(abcDir = workingDir.resolve("abc"), new LinkOption[0])) {
            try {
                Files.createDirectory(abcDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Clef.LOGGER.warn("Error creating abc directory!");
                e.printStackTrace();
                return;
            }
        }
        if (!Files.exists(instrumentDir = workingDir.resolve("instruments"), new LinkOption[0])) {
            try {
                Files.createDirectory(instrumentDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Clef.LOGGER.warn("Error creating instrument directory!");
                e.printStackTrace();
                return;
            }
        }
        allGood = true;
        init = true;
    }

    public static boolean allGood() {
        if (!init) {
            ResourceHelper.init();
        }
        return allGood;
    }

    public static Path getWorkingDir() {
        return workingDir;
    }

    public static Path getAbcDir() {
        return abcDir;
    }

    public static Path getInstrumentDir() {
        return instrumentDir;
    }
}

