/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.ichun.mods.clef.client.gui.GuiPlayTrack;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.packet.PacketFileFragment;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.util.ResourceHelper;
import me.ichun.mods.clef.common.util.abc.AbcParser;
import me.ichun.mods.clef.common.util.abc.BaseTrackFile;
import me.ichun.mods.clef.common.util.abc.PendingTrackFile;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.NotePlayThread;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.abc.play.components.TrackInfo;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.RandomStringUtils;

public class AbcLibrary {
    private static List<TrackFile> tracks = new ArrayList<TrackFile>();
    public static HashSet<String> requestedABCFromServer = new HashSet();
    public static HashSet<String> requestedABCFromPlayers = new HashSet();
    public static HashMap<String, Track> tracksWaitingForTrackInfo = new HashMap();

    public static void init() {
        tracks.clear();
        File defaultAbc = new File(ResourceHelper.getAbcDir().toFile(), "files.extracted");
        if (!defaultAbc.exists()) {
            try (InputStream in2 = Clef.class.getResourceAsStream("/abc.zip");
                 ZipInputStream zipStream = new ZipInputStream(in2);){
                ZipEntry entry;
                int extractCount = 0;
                while ((entry = zipStream.getNextEntry()) != null) {
                    int len;
                    File file = new File(ResourceHelper.getAbcDir().toFile(), entry.getName());
                    if (file.exists() && file.length() > 3L) continue;
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((len = zipStream.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                    ++extractCount;
                }
                if (extractCount > 0) {
                    Clef.LOGGER.info("Extracted " + Integer.toString(extractCount) + (extractCount == 1 ? " file" : " files from mod zip."));
                }
            }
            catch (IOException in2) {
                // empty catch block
            }
        }
        Clef.LOGGER.info("Loading abc files");
        Clef.LOGGER.info("Loaded " + AbcLibrary.readAbcs(ResourceHelper.getAbcDir().toFile(), tracks) + " abc files");
        if (tracks.isEmpty()) {
            TrackInfo track = new TrackInfo();
            track.setTitle("You have no tracks");
            track.setFileTitle("You have no tracks");
            track.trackLength = 10;
            tracks.add(new TrackFile(track, new File(ResourceHelper.getAbcDir().toFile(), "You have no tracks.abc"), ""));
        }
    }

    private static int readAbcs(File dir, List<TrackFile> tracks) {
        int trackCount = 0;
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                trackCount += AbcLibrary.readAbcs(file, tracks);
                continue;
            }
            if (!AbcLibrary.readAbc(file, tracks)) continue;
            ++trackCount;
        }
        return trackCount;
    }

    public static boolean readAbc(File file, List<TrackFile> tracks) {
        if (file.exists() && file.getName().endsWith(".abc")) {
            TrackInfo track;
            String md5 = IOUtil.getMD5Checksum((File)file);
            if (!(tracks == AbcLibrary.tracks && AbcLibrary.hasTrack(md5) || (track = AbcParser.parse(file)) == null)) {
                TrackFile trackFile = new TrackFile(track, file, md5);
                tracks.add(trackFile);
                Collections.sort(tracks);
                if (EffectiveSide.get().isServer() && tracksWaitingForTrackInfo.containsKey(md5)) {
                    tracksWaitingForTrackInfo.get(md5).setTrack(trackFile);
                    tracksWaitingForTrackInfo.remove(md5);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void reloadTracks(GuiPlayTrack gui) {
        boolean result = NotePlayThread.INSTANCE.acquireLock();
        try {
            ArrayList<TrackFile> tracks = new ArrayList<TrackFile>();
            Clef.LOGGER.info("Reloading abc files");
            Clef.LOGGER.info("Reloaded " + AbcLibrary.readAbcs(ResourceHelper.getAbcDir().toFile(), tracks) + " abc files");
            if (tracks.isEmpty()) {
                TrackInfo track = new TrackInfo();
                track.setTitle("You have no tracks");
                track.setFileTitle("You have no tracks");
                track.trackLength = 10;
                tracks.add(new TrackFile(track, new File(ResourceHelper.getAbcDir().toFile(), "You have no tracks.abc"), ""));
            }
            AbcLibrary.tracks = tracks;
            gui.tracks = tracks;
            gui.index = -1;
            gui.doneTimeout = 20;
            gui.func_231158_b_(Minecraft.func_71410_x(), Minecraft.func_71410_x().func_228018_at_().func_198107_o(), Minecraft.func_71410_x().func_228018_at_().func_198087_p());
        }
        finally {
            NotePlayThread.INSTANCE.releaseLock(result);
        }
    }

    public static boolean hasTrack(String md5) {
        return AbcLibrary.getTrack(md5) != null;
    }

    public static TrackFile getTrack(String md5) {
        for (TrackFile track : tracks) {
            if (!track.md5.equals(md5)) continue;
            return track;
        }
        return null;
    }

    public static void playAbc(String md5, String bandName, boolean syncPlay, boolean syncTrack, ServerPlayerEntity player) {
        Track playerTrack;
        Track track;
        BaseTrackFile file = AbcLibrary.getTrack(md5);
        if (file == null) {
            file = new PendingTrackFile(md5);
        }
        if (!bandName.isEmpty()) {
            track = Clef.eventHandlerServer.findTrackByBand(bandName);
            if (track == null && md5.isEmpty()) {
                return;
            }
            Track track1 = track;
            if (track == null || !syncTrack) {
                track = new Track(RandomStringUtils.randomAscii((int)20), bandName, file, false);
            }
            if (syncPlay && track1 != null) {
                track.playAtProgress(track1.playProg);
            }
        } else {
            if (md5.isEmpty()) {
                return;
            }
            track = new Track(RandomStringUtils.randomAscii((int)20), bandName, file, false);
        }
        if (!file.isSynced() && requestedABCFromPlayers.add(md5)) {
            if (track.getTrackFile() == null) {
                tracksWaitingForTrackInfo.put(md5, track);
            }
            Clef.channel.sendTo((AbstractPacket)new PacketRequestFile(md5, false), player);
        }
        if ((playerTrack = Clef.eventHandlerServer.getTrackPlayedByPlayer((PlayerEntity)player)) != null) {
            playerTrack.players.remove(player);
            if (!playerTrack.hasObjectsPlaying()) {
                playerTrack.stop();
            }
            Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(playerTrack), PacketDistributor.ALL.noArg());
        }
        Clef.eventHandlerServer.tracksPlaying.add(track);
        track.players.put((PlayerEntity)player, 0);
        if (track.getTrackFile() != null) {
            Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
        }
    }

    public static void startPlayingTrack(ServerPlayerEntity player, Track ... tracks) {
        Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(tracks), player);
    }

    public static void sendAbc(String md5, ServerPlayerEntity player) {
        if (md5.isEmpty()) {
            return;
        }
        TrackFile track = AbcLibrary.getTrack(md5);
        if (track != null) {
            if (!track.file.exists()) {
                Clef.LOGGER.warn("Unable to send track " + track.file.getName() + ". File is no longer on disk.");
                return;
            }
            try (FileInputStream fis = new FileInputStream(track.file);){
                int fileSize;
                if (fileSize > 10000000) {
                    Clef.LOGGER.warn("Unable to send track " + track.file.getName() + ". It is above the size limit!");
                    return;
                }
                if (fileSize == 0) {
                    Clef.LOGGER.warn("Unable to send track " + track.file.getName() + ". The file is empty!");
                    return;
                }
                Clef.LOGGER.info("Sending track " + track.file.getName() + " to " + (player == null ? "the server" : player.func_200200_C_().func_150261_e()));
                int packetsToSend = (int)Math.ceil((float)fileSize / 32000.0f);
                int packetCount = 0;
                for (fileSize = (int)track.file.length(); fileSize > 0; fileSize -= 32000) {
                    byte[] fileBytes = new byte[Math.min(fileSize, 32000)];
                    fis.read(fileBytes);
                    if (player != null) {
                        Clef.channel.sendTo((AbstractPacket)new PacketFileFragment(track.file.getName(), packetsToSend, packetCount, fileBytes), player);
                    } else {
                        Clef.channel.sendToServer((AbstractPacket)new PacketFileFragment(track.file.getName(), packetsToSend, packetCount, fileBytes));
                    }
                    ++packetCount;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void handleReceivedFile(String fileName, byte[] fileData, LogicalSide side) {
        File dir = new File(ResourceHelper.getAbcDir().toFile(), "received");
        File file = new File(dir, fileName);
        try {
            dir.mkdirs();
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(fileData);
            fos.close();
            Clef.LOGGER.info("Received " + fileName + ". Reading.");
            AbcLibrary.readAbc(file, tracks);
            String fileNameTruncated = fileName.substring(0, fileName.length() - 4);
            if (side.isServer()) {
                requestedABCFromPlayers.remove(fileNameTruncated);
            } else {
                requestedABCFromServer.remove(fileNameTruncated);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<TrackFile> getTracks() {
        return ImmutableList.copyOf(tracks);
    }

    public static void setTracks(List<TrackFile> tracks) {
        AbcLibrary.tracks = tracks;
    }
}

