/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.abc.play.TrackTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NotePlayThread
extends Thread {
    public static final NotePlayThread INSTANCE = new NotePlayThread();
    private static final int INTERVAL_NANOS = 10000000;
    private final Set<TrackTracker> trackerSet = Collections.newSetFromMap(new WeakHashMap());
    private final AtomicInteger runTick = new AtomicInteger();
    private final Lock lock = new ReentrantLock();
    private volatile boolean done = true;

    public void ensurePresent(TrackTracker trackTracker) {
        this.trackerSet.add(trackTracker);
    }

    public boolean startNewTick() {
        boolean result = this.acquireLock();
        if (!this.done) {
            for (int i = this.runTick.get(); i < 5; ++i) {
                this.runSubTicks();
            }
        }
        this.trackerSet.forEach(TrackTracker::reset);
        this.runTick.set(0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTick(boolean wasLocked) {
        this.done = false;
        this.releaseLock(wasLocked);
        NotePlayThread notePlayThread = this;
        synchronized (notePlayThread) {
            this.notifyAll();
        }
    }

    public boolean acquireLock() {
        boolean result = true;
        try {
            if (!this.lock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                Clef.LOGGER.error("Failed to aquire lock for track at startNewTick in 500ms, continuing anyway!");
                result = false;
            }
        }
        catch (InterruptedException e) {
            Clef.LOGGER.warn("Unexpected main thread interrupt!", (Throwable)e);
            result = false;
        }
        return result;
    }

    public void releaseLock(boolean wasLocked) {
        if (wasLocked) {
            this.lock.unlock();
        }
    }

    private boolean runSubTicks() {
        Iterator<TrackTracker> iterator = this.trackerSet.iterator();
        int val = this.runTick.getAndIncrement();
        if (val >= 5) {
            return true;
        }
        while (iterator.hasNext()) {
            TrackTracker tracker = iterator.next();
            if (tracker.didNotStart()) {
                iterator.remove();
                continue;
            }
            tracker.runSubTick(val);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: while (Minecraft.func_71410_x().func_228025_l_()) {
            NotePlayThread notePlayThread = this;
            synchronized (notePlayThread) {
                while (this.done && Minecraft.func_71410_x().func_228025_l_()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!Minecraft.func_71410_x().func_228025_l_()) break;
            long startTime = Util.func_211178_c();
            for (int i = this.runTick.get(); i < 5; ++i) {
                this.lock.lock();
                try {
                    if (this.runSubTicks()) {
                        continue block10;
                    }
                }
                finally {
                    this.lock.unlock();
                    continue block10;
                }
                long now = Util.func_211178_c();
                long targetTime = startTime + (long)(10000000 * (i + 1));
                long sleepTime = targetTime - now - 100L;
                int nanos = (int)(sleepTime % 1000000L);
                long millis = (sleepTime - (long)nanos) / 1000000L;
                if (this.runTick.get() >= 5) {
                    this.done = true;
                    continue block10;
                }
                if (millis > 1L) {
                    try {
                        Thread.sleep(millis, nanos);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                while (targetTime > Util.func_211178_c()) {
                }
                if (this.done) continue block10;
            }
        }
    }

    static {
        INSTANCE.setName("Clef NotePlay Thread");
        INSTANCE.setDaemon(true);
        INSTANCE.setPriority(7);
        INSTANCE.start();
    }
}

