/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.ichun.mods.clef.client.sound.InstrumentEntitySound;
import me.ichun.mods.clef.client.sound.InstrumentSound;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentTuning;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.AudioStreamManager;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.OggAudioStream;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundSystem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class PlayedNote {
    private static final ConcurrentHashMap<ResourceLocation, CompletableFuture<AudioStreamBuffer>> CLEF_CACHE = new ConcurrentHashMap();
    public static final Random rand = new Random();

    public static void clearCache() {
        CLEF_CACHE.clear();
    }

    public static void start(Instrument instrument, int startTick, int duration, int key, SoundCategory category, Object noteLocation) {
        boolean relative;
        InstrumentSound instrumentSound;
        InstrumentTuning.TuningInfo tuning = instrument.tuning.keyToTuningMap.get(key);
        float pitch = (float)Math.pow(2.0, (double)tuning.keyOffset / 12.0);
        int falloffTime = (int)Math.ceil(instrument.tuning.fadeout * 20.0f);
        float volume = 0.7f * ((float)Clef.configClient.instrumentVolume / 100.0f);
        if (noteLocation == Minecraft.func_71410_x().field_71439_g) {
            instrumentSound = new InstrumentSound(SoundEvents.field_187682_dG, category, duration, falloffTime, volume, pitch, 0.0f, 0.0f, 0.0f);
            relative = true;
        } else if (noteLocation instanceof LivingEntity) {
            instrumentSound = new InstrumentEntitySound(SoundEvents.field_187682_dG, category, duration, falloffTime, volume, pitch, (LivingEntity)noteLocation);
            relative = false;
        } else if (noteLocation instanceof BlockPos) {
            BlockPos pos = (BlockPos)noteLocation;
            instrumentSound = new InstrumentSound(SoundEvents.field_187682_dG, category, duration, falloffTime, volume, pitch, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
            relative = false;
        } else {
            throw new IllegalArgumentException("Cannot handle noteLocation of type " + noteLocation.getClass());
        }
        Minecraft mc = Minecraft.func_71410_x();
        SoundEngine soundManager = mc.func_147118_V().field_147694_f;
        if (mc.field_71474_y.func_186711_a(SoundCategory.MASTER) > 0.0f && instrument.hasAvailableKey(key)) {
            instrumentSound.func_184366_a(mc.func_147118_V());
            float f3 = instrumentSound.func_147653_e();
            float f = Math.max(f3, 1.0f) * (float)Clef.configClient.instrumentHearableDistance;
            SoundCategory soundcategory = instrumentSound.func_184365_d();
            float f1 = soundManager.func_188770_e((ISound)instrumentSound);
            float f2 = (float)Math.pow(2.0, (double)tuning.keyOffset / 12.0);
            ISound.AttenuationType isound$attenuationtype = instrumentSound.func_147656_j();
            Vector3d vec3d = new Vector3d(instrumentSound.func_147649_g(), instrumentSound.func_147654_h(), instrumentSound.func_147651_i());
            CompletableFuture completablefuture = soundManager.field_217941_k.func_239534_a_(SoundSystem.Mode.STATIC);
            ChannelManager.Entry channelmanager$entry = (ChannelManager.Entry)completablefuture.join();
            mc.func_222817_e(() -> {
                soundManager.field_148624_n.put(instrumentSound, soundManager.field_148618_g + duration + (int)(instrument.tuning.fadeout * 20.0f) + 20);
                soundManager.field_217942_m.put(instrumentSound, channelmanager$entry);
                soundManager.field_217943_n.put((Object)soundcategory, (Object)instrumentSound);
                soundManager.field_148625_l.add(instrumentSound);
            });
            channelmanager$entry.func_217888_a(source -> {
                source.func_216422_a(f2);
                source.func_216430_b(f1);
                if (isound$attenuationtype == ISound.AttenuationType.LINEAR) {
                    source.func_216423_c(f);
                } else {
                    source.func_216419_h();
                }
                source.func_216425_a(false);
                source.func_216420_a(vec3d);
                source.func_216432_b(relative);
            });
            InstrumentSound isound = instrumentSound;
            int randKey = rand.nextInt(tuning.streamsLength());
            PlayedNote.createResource(soundManager.field_217939_i, new ResourceLocation("clef", instrument.info.itemName.toLowerCase(Locale.ROOT) + "_" + (key - tuning.keyOffset) + randKey + ".ogg"), () -> tuning.get(randKey)).thenAccept(arg_0 -> PlayedNote.lambda$start$4(channelmanager$entry, soundManager, (ISound)isound, arg_0));
        }
    }

    public static CompletableFuture<AudioStreamBuffer> createResource(AudioStreamManager audioStreamManager, ResourceLocation rl, Supplier<InputStream> inputStream) {
        return CLEF_CACHE.computeIfAbsent(rl, newRL -> CompletableFuture.supplyAsync(() -> PlayedNote.lambda$null$5((Supplier)inputStream), Util.func_215072_e()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ AudioStreamBuffer lambda$null$5(Supplier inputStream) {
        try (OggAudioStream iaudiostream = new OggAudioStream((InputStream)inputStream.get());){
            AudioStreamBuffer audiostreambuffer;
            ByteBuffer bytebuffer = iaudiostream.func_216453_b();
            AudioStreamBuffer audioStreamBuffer = audiostreambuffer = new AudioStreamBuffer(bytebuffer, iaudiostream.func_216454_a());
            return audioStreamBuffer;
        }
        catch (IOException ioexception) {
            throw new CompletionException(ioexception);
        }
    }

    private static /* synthetic */ void lambda$start$4(ChannelManager.Entry channelmanager$entry, SoundEngine soundManager, ISound isound, AudioStreamBuffer buffer) {
        channelmanager$entry.func_217888_a(source -> {
            source.func_216429_a(buffer);
            source.func_216438_c();
            MinecraftForge.EVENT_BUS.post((Event)new PlaySoundSourceEvent(soundManager, isound, source));
        });
    }
}

