/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.BaseTrackFile;
import me.ichun.mods.clef.common.util.abc.PendingTrackFile;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.NotesTickInfo;
import me.ichun.mods.clef.common.util.abc.play.TrackTracker;
import me.ichun.mods.clef.common.util.abc.play.components.Note;
import me.ichun.mods.clef.common.util.abc.play.components.TrackInfo;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class Track {
    public static final int MAX_TRACKING_RANGE = 48;
    private final String id;
    private final String band;
    private BaseTrackFile trackFile;
    public boolean isRemote;
    public int playProg;
    public boolean playing = true;
    public int timeToSilence = 0;
    public HashMap<ResourceLocation, HashSet<BlockPos>> instrumentPlayers = new HashMap();
    public HashSet<String> playersNames = new HashSet();
    public IdentityHashMap<PlayerEntity, Integer> players = new IdentityHashMap();
    public IntOpenHashSet zombies = new IntOpenHashSet();
    @OnlyIn(value=Dist.CLIENT)
    private TrackTracker trackTracker;

    public Track(String id, String band, @Nonnull BaseTrackFile trackFile, boolean isRemote) {
        this.id = id;
        this.band = band;
        this.trackFile = trackFile;
        this.isRemote = isRemote;
        if (isRemote) {
            this.trackTracker = new TrackTracker(this);
        }
    }

    public void addPlayer(String playerName) {
        this.playersNames.add(playerName);
    }

    public String getId() {
        return this.id;
    }

    public String getBandName() {
        return this.band;
    }

    public void setTrack(BaseTrackFile track) {
        this.trackFile = track;
        if (!this.isRemote) {
            Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(this), PacketDistributor.ALL.noArg());
        }
    }

    public BaseTrackFile getTrackFile() {
        return this.trackFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tick() {
        if (!this.trackFile.isSynced()) {
            TrackFile newFile;
            if (!this.isRemote) return true;
            if (this.shouldRequestTrack() && AbcLibrary.requestedABCFromServer.add(this.trackFile.md5)) {
                Clef.channel.sendToServer((AbstractPacket)new PacketRequestFile(this.trackFile.md5, false));
            }
            if ((newFile = ((PendingTrackFile)this.trackFile).resolve()) != null) {
                this.trackFile = newFile;
            } else {
                ++this.playProg;
                return true;
            }
        }
        TrackInfo track = ((TrackFile)this.trackFile).track;
        if (!this.playing || this.playProg > track.trackLength) {
            return false;
        }
        if (this.isRemote) {
            this.trackTracker.startNewTick(this.playProg);
            if (this.playProg == 0 && Clef.configClient.showRecordPlayingMessageForTracks) {
                this.showNowPlaying();
            }
            if (this.timeToSilence > 0) {
                --this.timeToSilence;
            }
            this.findPlayers();
            if (track.notes.containsKey(this.playProg)) {
                PlayerEntity mcPlayer = EntityHelper.getClientPlayer();
                if (mcPlayer == null) {
                    return false;
                }
                Iterator<Map.Entry<PlayerEntity, Integer>> playerIte = this.players.entrySet().iterator();
                while (playerIte.hasNext()) {
                    Map.Entry<PlayerEntity, Integer> e = playerIte.next();
                    PlayerEntity player = e.getKey();
                    if (player.func_70089_S() && player.func_70032_d((Entity)mcPlayer) < 48.0f) {
                        CompoundNBT tag;
                        ItemStack is = ItemInstrument.getUsableInstrument((LivingEntity)player);
                        if (is.func_190926_b() || (tag = is.func_77978_p()) == null) continue;
                        Instrument instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"));
                        if (instrument != null) {
                            HashSet<Note>[] notes = track.notes.get(this.playProg);
                            this.trackTracker.addTickInfo(new NotesTickInfo((Entity)player, instrument, notes, true));
                            continue;
                        }
                        InstrumentLibrary.requestInstrument(tag.func_74779_i("itemName"), null);
                        continue;
                    }
                    this.playersNames.add(player.func_200200_C_().func_150261_e());
                    playerIte.remove();
                }
                HashSet<BlockPos> poses = this.instrumentPlayers.get(mcPlayer.func_130014_f_().func_234923_W_().func_240901_a_());
                if (poses != null) {
                    for (BlockPos pos : poses) {
                        TileEntity te;
                        if (!(mcPlayer.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 2304.0) || !((te = mcPlayer.field_70170_p.func_175625_s(pos)) instanceof TileEntityInstrumentPlayer)) continue;
                        TileEntityInstrumentPlayer player = (TileEntityInstrumentPlayer)te;
                        for (int i = 0; i < 9; ++i) {
                            Instrument instrument;
                            ItemStack is = player.func_70301_a(i);
                            if (is.func_77973_b() != Clef.Items.INSTRUMENT.get() || is.func_77978_p() == null || (instrument = InstrumentLibrary.getInstrumentByName(is.func_77978_p().func_74779_i("itemName"))) == null) continue;
                            HashSet<Note>[] notes = track.notes.get(this.playProg);
                            this.trackTracker.addTickInfo(new NotesTickInfo(player.func_174877_v(), instrument, notes));
                        }
                    }
                }
                for (Integer i : this.zombies) {
                    CompoundNBT tag;
                    ItemStack is;
                    Entity ent = mcPlayer.field_70170_p.func_73045_a(i.intValue());
                    if (!(ent instanceof ZombieEntity) || !ent.func_70089_S() || !(mcPlayer.func_70032_d(ent) < 48.0f) || (is = ItemInstrument.getUsableInstrument((LivingEntity)((ZombieEntity)ent))).func_190926_b() || (tag = is.func_77978_p()) == null) continue;
                    Instrument instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"));
                    if (instrument != null) {
                        HashSet<Note>[] notes = track.notes.get(this.playProg);
                        this.trackTracker.addTickInfo(new NotesTickInfo(ent, instrument, notes, false));
                        continue;
                    }
                    InstrumentLibrary.requestInstrument(tag.func_74779_i("itemName"), null);
                }
            }
        } else {
            boolean update = false;
            Iterator<Map.Entry<PlayerEntity, Integer>> playerIte = this.players.entrySet().iterator();
            while (playerIte.hasNext()) {
                Map.Entry<PlayerEntity, Integer> e = playerIte.next();
                PlayerEntity player = e.getKey();
                if (player.func_70089_S()) {
                    Instrument instrument;
                    e.setValue(e.getValue() + 1);
                    ItemStack is = ItemInstrument.getUsableInstrument((LivingEntity)player);
                    if (!is.func_190926_b() && (instrument = InstrumentLibrary.getInstrumentByName(is.func_77978_p().func_74779_i("itemName"))) != null) {
                        e.setValue(0);
                    }
                } else {
                    e.setValue(10000000);
                }
                if (e.getValue() <= 100) continue;
                update = true;
                playerIte.remove();
            }
            IntIterator z = this.zombies.iterator();
            while (z.hasNext()) {
                Integer i = (Integer)z.next();
                if (!(Math.random() < (double)0.001f)) continue;
                z.remove();
                update = true;
            }
            if (update) {
                if (!this.hasObjectsPlaying()) {
                    this.stop();
                }
                Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(this), PacketDistributor.ALL.noArg());
            }
        }
        ++this.playProg;
        return true;
    }

    public void stop() {
        this.playing = false;
    }

    public void playAtProgress(int i) {
        this.playProg = i;
    }

    public boolean hasObjectsPlaying() {
        for (HashSet<BlockPos> list : this.instrumentPlayers.values()) {
            if (list.isEmpty()) continue;
            return true;
        }
        return !this.playersNames.isEmpty() || !this.players.isEmpty() || !this.zombies.isEmpty();
    }

    public boolean equals(Object o) {
        return o instanceof Track && this.id.equals(((Track)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void findPlayers() {
        Iterator<String> ite = this.playersNames.iterator();
        while (ite.hasNext()) {
            String s = ite.next();
            if (Minecraft.func_71410_x().field_71441_e == null) continue;
            for (AbstractClientPlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
                if (!player.func_200200_C_().func_150261_e().equals(s) || !player.func_70089_S()) continue;
                this.players.put((PlayerEntity)player, 0);
                ite.remove();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showNowPlaying() {
        if (this.trackFile.isSynced()) {
            Minecraft.func_71410_x().field_71456_v.func_238451_a_((ITextComponent)new StringTextComponent(((TrackFile)this.trackFile).track.getTitle()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRequestTrack() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return false;
        }
        HashSet<BlockPos> poses = this.instrumentPlayers.get(world.func_234923_W_().func_240901_a_());
        if (poses != null) {
            for (BlockPos pos : poses) {
                if (!(Minecraft.func_71410_x().field_71439_g.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 2304.0)) continue;
                return true;
            }
        }
        for (String s : this.playersNames) {
            if (Minecraft.func_71410_x().field_71441_e == null) continue;
            for (AbstractClientPlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
                if (!player.func_200200_C_().func_150261_e().equals(s) || !player.func_70089_S()) continue;
                return true;
            }
        }
        for (Integer i : this.zombies) {
            Entity ent;
            if (Minecraft.func_71410_x().field_71441_e == null || (ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(i.intValue())) == null || !ent.func_70089_S()) continue;
            return true;
        }
        return false;
    }
}

