/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play.components;

import java.util.HashMap;
import me.ichun.mods.clef.common.util.abc.construct.Accidental;
import me.ichun.mods.clef.common.util.abc.construct.Construct;
import me.ichun.mods.clef.common.util.abc.construct.Octave;
import me.ichun.mods.clef.common.util.abc.play.PlayedNote;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.abc.play.components.Note;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;

public class SingleNote
extends Note {
    @Override
    public int playNote(Track track, int currentProg, Instrument instrument, Object noteLocation) {
        if (this.key != -1 && instrument.hasAvailableKey(this.key)) {
            PlayedNote.start(instrument, currentProg, this.durationInTicks, this.key, noteLocation instanceof Entity ? ((Entity)noteLocation).func_184176_by() : SoundCategory.BLOCKS, noteLocation);
        }
        return this.durationInTicks;
    }

    @Override
    public boolean setup(double[] info, HashMap<Integer, Integer> keyAccidentals, HashMap<Integer, Integer> keySignature) {
        int accidental = -20;
        boolean applyAccidental = false;
        int currentAccidental = 0;
        int key = 0;
        boolean rest = false;
        boolean hasNote = false;
        for (Construct construct : this.constructs) {
            char c;
            if (construct.getType() == Construct.EnumConstructType.ACCIDENTAL) {
                applyAccidental = true;
                c = ((Accidental)construct).type;
                switch (c) {
                    case '^': {
                        ++currentAccidental;
                        break;
                    }
                    case '=': {
                        currentAccidental = 0;
                        break;
                    }
                    case '_': {
                        --currentAccidental;
                    }
                }
                continue;
            }
            if (construct.getType() == Construct.EnumConstructType.NOTE) {
                c = ((me.ichun.mods.clef.common.util.abc.construct.Note)construct).type;
                if (c == 'Z' || c == 'X') {
                    rest = true;
                    this.duration *= info[2] / info[1];
                } else if (c == 'z' || c == 'x') {
                    rest = true;
                } else {
                    key += Note.NOTE_TO_KEY_MAP.get(Character.valueOf(c)).intValue();
                }
                hasNote = true;
                continue;
            }
            if (construct.getType() != Construct.EnumConstructType.OCTAVE) continue;
            c = ((Octave)construct).type;
            if (c == ',') {
                key -= 12;
                continue;
            }
            key += 12;
        }
        float scaledDuration = (float)(info[0] * (info[1] / info[4]) * this.duration);
        this.durationInTicks = (int)scaledDuration;
        this.durationInPartialTicks = scaledDuration - (float)((int)scaledDuration);
        if (hasNote) {
            if (!rest) {
                if (keySignature.containsKey(key % 12)) {
                    accidental = keySignature.get(key % 12);
                }
                if (keyAccidentals.containsKey(key)) {
                    accidental = keyAccidentals.get(key);
                }
                if (applyAccidental) {
                    accidental = currentAccidental;
                    keyAccidentals.put(key, accidental);
                }
                if (accidental == -20) {
                    accidental = 0;
                }
                this.key = key + accidental + 60;
            }
        } else {
            this.durationInTicks = 0;
        }
        return true;
    }
}

