/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.instrument;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import me.ichun.mods.clef.client.render.BakedModelInstrument;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentInfo;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentPackInfo;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentTuning;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TransformationHelper;

public class Instrument
implements Comparable<Instrument> {
    public final InstrumentInfo info;
    public final byte[] iconBytes;
    public final byte[] handBytes;
    public InstrumentTuning tuning;
    public InstrumentPackInfo packInfo;
    @OnlyIn(value=Dist.CLIENT)
    public BakedModelInstrument iconModel;
    @OnlyIn(value=Dist.CLIENT)
    public BakedModelInstrument handModel;
    @OnlyIn(value=Dist.CLIENT)
    public ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transformationMap;

    public Instrument(InstrumentInfo info, byte[] iconBytes, byte[] handBytes) {
        this.info = info;
        this.iconBytes = iconBytes;
        this.handBytes = handBytes;
    }

    public boolean hasAvailableKey(int key) {
        return this.tuning.keyToTuningMap.containsKey(key) && this.tuning.keyToTuningMap.get(key).streamsLength() > 0;
    }

    @Override
    public int compareTo(Instrument o) {
        if (this.packInfo.packName.toLowerCase().equals(o.packInfo.packName.toLowerCase())) {
            return this.info.shortdescription.toLowerCase().compareTo(o.info.shortdescription.toLowerCase());
        }
        return this.packInfo.packName.toLowerCase().compareTo(o.packInfo.packName.toLowerCase());
    }

    public ByteArrayOutputStream getAsBAOS() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream out = new ZipOutputStream(baos);
            out.setLevel(9);
            if (this.packInfo != null) {
                String desc = this.packInfo.description;
                this.packInfo.description = this.packInfo.description.concat(" - This pack is a single instrument from the main pack.");
                out.putNextEntry(new ZipEntry("info.cii"));
                byte[] data = new Gson().toJson((Object)this.packInfo).getBytes();
                out.write(data, 0, data.length);
                out.closeEntry();
                this.packInfo.description = desc;
            }
            out.putNextEntry(new ZipEntry("items/"));
            out.putNextEntry(new ZipEntry("items/instruments/"));
            out.putNextEntry(new ZipEntry("items/instruments/" + this.info.itemName + ".instrument"));
            byte[] data = new Gson().toJson((Object)this.info).getBytes();
            out.write(data, 0, data.length);
            out.closeEntry();
            out.putNextEntry(new ZipEntry("items/instruments/" + this.info.inventoryIcon));
            out.write(this.iconBytes, 0, this.iconBytes.length);
            out.closeEntry();
            if (!this.info.inventoryIcon.equals(this.info.activeImage)) {
                out.putNextEntry(new ZipEntry("items/instruments/" + this.info.activeImage));
                out.write(this.handBytes, 0, this.handBytes.length);
                out.closeEntry();
            }
            out.putNextEntry(new ZipEntry("sfx/"));
            out.putNextEntry(new ZipEntry("sfx/instruments/"));
            out.putNextEntry(new ZipEntry("sfx/instruments/" + this.info.kind + "/"));
            out.putNextEntry(new ZipEntry("sfx/instruments/" + this.info.kind + "/tuning.config"));
            data = new Gson().toJson((Object)this.tuning).getBytes();
            out.write(data, 0, data.length);
            out.closeEntry();
            for (Map.Entry<String, byte[]> e : this.tuning.audioToOutputStream.entrySet()) {
                out.putNextEntry(new ZipEntry("sfx/instruments/" + this.info.kind + "/" + e.getKey()));
                out.write(e.getValue());
                out.closeEntry();
            }
            out.close();
            return baos;
        }
        catch (Exception e) {
            Clef.LOGGER.warn("Error creating instrument package: " + this.info.itemName);
            e.printStackTrace();
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupModels() {
        if (this.iconModel == null && this.handModel == null) {
            Minecraft mc = Minecraft.func_71410_x();
            ResourceLocation iconRl = new ResourceLocation("clef", "instrument/" + this.info.itemName + "/icon.png");
            ResourceLocation handRl = new ResourceLocation("clef", "instrument/" + this.info.itemName + "/hand.png");
            InstrumentTexture iconTx = new InstrumentTexture(iconRl, this.iconBytes);
            InstrumentTexture handTx = new InstrumentTexture(handRl, this.handBytes);
            mc.func_110434_K().func_229263_a_(iconTx.rl, (Texture)iconTx);
            mc.func_110434_K().func_229263_a_(handTx.rl, (Texture)handTx);
            this.iconModel = new BakedModelInstrument(iconTx.quads, iconTx.tas, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)ImmutableMap.copyOf(new HashMap()), this, iconRl);
            this.handModel = new BakedModelInstrument(handTx.quads, handTx.tas, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)ImmutableMap.copyOf(new HashMap()), this, handRl);
            HashMap<ItemCameraTransforms.TransformType, TransformationMatrix> map = new HashMap<ItemCameraTransforms.TransformType, TransformationMatrix>();
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(new ItemStack((IItemProvider)Items.field_151118_aC), null, null);
            ItemCameraTransforms cameraTransforms = model.func_177552_f();
            map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new TransformationMatrix(new Vector3f(0.0f, 0.1875f, 0.0625f), null, null, null));
            map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new TransformationMatrix(new Vector3f(0.0f, 0.1875f, 0.0625f), null, null, null));
            map.put(ItemCameraTransforms.TransformType.GROUND, TransformationHelper.toTransformation((ItemTransformVec3f)cameraTransforms.field_181699_o));
            map.put(ItemCameraTransforms.TransformType.HEAD, TransformationHelper.toTransformation((ItemTransformVec3f)cameraTransforms.field_178353_d));
            map.put(ItemCameraTransforms.TransformType.FIXED, TransformationHelper.toTransformation((ItemTransformVec3f)cameraTransforms.field_181700_p));
            this.transformationMap = ImmutableMap.copyOf(map);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class InstrumentTexture
    extends Texture {
        public final ResourceLocation rl;
        public NativeImage image;
        public ImmutableList<BakedQuad> quads;
        public TextureAtlasSprite tas;

        public InstrumentTexture(ResourceLocation rl, byte[] imageBytes) {
            this.rl = rl;
            try (NativeImage image = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(imageBytes));){
                int size = Math.max(Math.max(image.func_195702_a(), image.func_195714_b()), 16);
                NativeImage image1 = new NativeImage(size, size, true);
                int halfX = (int)Math.floor((double)(size - image.func_195702_a()) / 2.0);
                int halfY = (int)Math.floor((double)(size - image.func_195714_b()) / 2.0);
                for (int x = 0; x < image.func_195702_a(); ++x) {
                    for (int y = 0; y < image.func_195714_b(); ++y) {
                        int clr = image.func_195709_a(x, y);
                        image1.func_195700_a(halfX + x, halfY + y, clr);
                    }
                }
                this.image = image1;
                this.tas = RenderHelper.buildTASFromNativeImage((ResourceLocation)this.rl, (NativeImage)this.image);
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)this.tas, (TransformationMatrix)TransformationMatrix.func_227983_a_()));
                this.quads = builder.build();
            }
            catch (IOException e) {
                this.image = null;
                Clef.LOGGER.error("Failed to read NativeImage for " + rl.toString());
                e.printStackTrace();
            }
        }

        public void func_195413_a(IResourceManager resourceManager) throws IOException {
            if (this.image != null) {
                TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)this.image.func_195702_a(), (int)this.image.func_195714_b());
                this.image.func_195697_a(0, 0, 0, false);
            }
        }
    }
}

