/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.block.BlockInstrumentPlayer;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.RandomStringUtils;

public class EventHandlerServer {
    public HashSet<Track> tracksPlaying = new HashSet();

    @SubscribeEvent
    public void onRegisterBlock(RegistryEvent.Register<Block> event) {
        Clef.blockInstrumentPlayer = ((Block)new BlockInstrumentPlayer().setRegistryName("clef", "block_instrument_player")).func_149663_c("clef.item.instrumentPlayer");
        event.getRegistry().register((IForgeRegistryEntry)Clef.blockInstrumentPlayer);
    }

    @SubscribeEvent
    public void onRegisterItem(RegistryEvent.Register<Item> event) {
        Clef.itemInstrument = ((Item)new ItemInstrument().func_77664_n().setRegistryName("clef", "instrument")).func_77655_b("clef.item.instrument");
        event.getRegistry().register((IForgeRegistryEntry)Clef.itemInstrument);
        Clef.creativeTabInstruments = new CreativeTabs("clef"){
            public final ItemStack iconItem;
            {
                this.iconItem = new ItemStack(Clef.itemInstrument);
            }

            public ItemStack func_78016_d() {
                return this.iconItem;
            }
        };
        Clef.itemInstrument.func_77637_a(Clef.creativeTabInstruments);
        Clef.blockInstrumentPlayer.func_149647_a(Clef.creativeTabInstruments);
        event.getRegistry().register(new ItemBlock(Clef.blockInstrumentPlayer).setRegistryName(Clef.blockInstrumentPlayer.getRegistryName()));
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && iChunUtil.eventHandlerServer.ticks + 5 == 2) {
            ItemStack isMain = event.player.func_184614_ca();
            ItemStack isOff = event.player.func_184592_cb();
            if (isMain.func_77973_b() == Clef.itemInstrument) {
                InstrumentLibrary.checkForInstrument(isMain, event.player);
            }
            if (isOff.func_77973_b() == Clef.itemInstrument) {
                InstrumentLibrary.checkForInstrument(isOff, event.player);
            }
        }
    }

    @SubscribeEvent
    public void onItemDrop(PlayerDropsEvent event) {
        if (!event.getEntityPlayer().func_130014_f_().field_72995_K) {
            for (EntityItem item : event.getDrops()) {
                String instName;
                Instrument is;
                NBTTagCompound tag;
                if (item.func_92059_d().func_77973_b() != Clef.itemInstrument || (tag = item.func_92059_d().func_77978_p()) == null || (is = InstrumentLibrary.getInstrumentByName(instName = tag.func_74779_i("itemName"))) != null) continue;
                InstrumentLibrary.requestInstrument(instName, event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDropsEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && (Clef.config.onlyHostileMobSpawn == 0 || event.getEntityLiving() instanceof IMob) && event.getEntityLiving().func_70681_au().nextFloat() < (float)Clef.config.mobDropRate / 10000.0f * (float)(event.getLootingLevel() + 1)) {
            ItemStack stack = new ItemStack(Clef.itemInstrument, 1, 0);
            InstrumentLibrary.assignRandomInstrument(stack);
            event.getDrops().add(event.getEntityLiving().func_70099_a(stack, 0.0f));
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent event) {
        EntityZombie zombie;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof EntityZombie && event.getEntityLiving().func_70681_au().nextFloat() < (float)Clef.config.zombieSpawnRate / 10000.0f && (zombie = (EntityZombie)event.getEntityLiving()).func_184614_ca().func_190926_b()) {
            ItemStack stack = new ItemStack(Clef.itemInstrument, 1, 0);
            InstrumentLibrary.assignRandomInstrument(stack);
            zombie.func_184611_a(EnumHand.MAIN_HAND, stack);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityZombie zombie;
        if (Clef.config.zombiesCanUseInstruments == 1 && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityZombie && (zombie = (EntityZombie)event.getEntityLiving()).func_70681_au().nextFloat() < 0.004f && ItemInstrument.getUsableInstrument((EntityLivingBase)zombie) != null && this.getTrackPlayedByPlayer(zombie) == null) {
            Track track = Clef.eventHandlerServer.findTrackByBand("zombies");
            if (track != null) {
                if (track.zombies.add(zombie.func_145782_y())) {
                    Clef.channel.sendToAll((AbstractPacket)new PacketPlayingTracks(track));
                }
            } else {
                TrackFile randTrack = AbcLibrary.tracks.get(zombie.func_70681_au().nextInt(AbcLibrary.tracks.size()));
                track = new Track(RandomStringUtils.randomAscii((int)20), "zombies", randTrack.md5, randTrack.track, false);
                if (track.getTrack().trackLength > 0) {
                    track.playAtProgress(zombie.func_70681_au().nextInt(track.getTrack().trackLength));
                }
                Clef.eventHandlerServer.tracksPlaying.add(track);
                track.zombies.add(zombie.func_145782_y());
                Clef.channel.sendToAll((AbstractPacket)new PacketPlayingTracks(track));
            }
        }
    }

    @SubscribeEvent
    public void onLootTableEvent(LootTableLoadEvent event) {
        if (Clef.config.lootSpawnRate > 0) {
            for (String s : Clef.config.disabledLootChests) {
                if (!event.getName().toString().equals(s)) continue;
                return;
            }
            if (event.getName().func_110623_a().contains("chest")) {
                event.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem(Clef.itemInstrument, Clef.config.lootSpawnRate, 0, new LootFunction[]{new LootFunction(new LootCondition[0]){

                    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
                        InstrumentLibrary.assignRandomInstrument(stack);
                        return stack;
                    }
                }}, new LootCondition[0], "clef_instrument_pool")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "clef_instrument"));
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Track> ite = this.tracksPlaying.iterator();
            while (ite.hasNext()) {
                Track track = ite.next();
                if (track.update()) continue;
                ite.remove();
            }
        }
    }

    public void stopPlayingTrack(EntityPlayer player, String trackId) {
        for (Track track : this.tracksPlaying) {
            if (!track.getId().equals(trackId)) continue;
            track.players.remove(player);
            if (!track.hasObjectsPlaying()) {
                track.stop();
            }
            Clef.channel.sendToAll((AbstractPacket)new PacketPlayingTracks(track));
            break;
        }
    }

    public Track getTrackPlayedByPlayer(EntityZombie zombie) {
        for (Track track : this.tracksPlaying) {
            if (!track.zombies.contains(zombie.func_145782_y())) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(TileEntityInstrumentPlayer player) {
        for (Track track : this.tracksPlaying) {
            if (!track.instrumentPlayers.containsKey(player.func_145831_w().field_73011_w.getDimension()) || !track.instrumentPlayers.get(player.func_145831_w().field_73011_w.getDimension()).contains(player.func_174877_v())) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(EntityPlayer player) {
        for (Track track : this.tracksPlaying) {
            if (!track.players.containsKey(player)) continue;
            return track;
        }
        return null;
    }

    public Track findTrackByBand(String bandName) {
        for (Track track : this.tracksPlaying) {
            if (!track.getBandName().equalsIgnoreCase(bandName)) continue;
            return track;
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        HashSet<Track> tracks = new HashSet<Track>();
        for (Track track : this.tracksPlaying) {
            if (track.getTrack() == null) continue;
            tracks.add(track);
        }
        AbcLibrary.startPlayingTrack(event.player, tracks.toArray(new Track[tracks.size()]));
    }

    public void shutdownServer() {
        this.tracksPlaying.clear();
        AbcLibrary.tracksWaitingForTrackInfo.clear();
        AbcLibrary.requestedABCFromPlayers.clear();
        InstrumentLibrary.requestsFromPlayers.clear();
        InstrumentLibrary.requestedInstrumentsFromPlayers.clear();
    }
}

