/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.packet;

import java.util.HashMap;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.packet.PacketDataFragment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class PacketFileFragment
extends PacketDataFragment {
    public static HashMap<String, byte[][]> partialFileFragments = new HashMap();

    public PacketFileFragment() {
    }

    public PacketFileFragment(String fileName, int packetTotal, int packetNumber, int fragmentSize, byte[] data) {
        super(fileName, packetTotal, packetNumber, fragmentSize, data);
    }

    public Side receivingSide() {
        return null;
    }

    public void execution(Side side, EntityPlayer player) {
        byte[][] packets = partialFileFragments.computeIfAbsent(this.fileName, v -> new byte[this.packetTotal][]);
        packets[this.packetNumber] = this.data;
        boolean complete = true;
        for (byte[] b : packets) {
            if (b != null && b.length != 0) continue;
            complete = false;
            break;
        }
        if (complete) {
            int size = 0;
            for (int i = 0; i < packets.length; ++i) {
                size += packets[i].length;
            }
            byte[] fileData = new byte[size];
            int index = 0;
            for (int i = 0; i < packets.length; ++i) {
                System.arraycopy(packets[i], 0, fileData, index, packets[i].length);
                index += packets[i].length;
            }
            if (this.fileName.endsWith(".cia")) {
                InstrumentLibrary.handleReceivedFile(this.fileName, fileData, side);
            } else if (this.fileName.endsWith(".abc")) {
                AbcLibrary.handleReceivedFile(this.fileName, fileData, side);
            } else {
                Clef.LOGGER.warn((Object)"Received unknown file fragment!");
            }
            partialFileFragments.remove(this.fileName);
        }
    }
}

