/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.abc.construct.Accidental;
import me.ichun.mods.clef.common.util.abc.construct.Octave;
import me.ichun.mods.clef.common.util.abc.construct.special.Key;
import me.ichun.mods.clef.common.util.abc.construct.special.Meter;
import me.ichun.mods.clef.common.util.abc.construct.special.Tempo;
import me.ichun.mods.clef.common.util.abc.construct.special.UnitNoteLength;
import me.ichun.mods.clef.common.util.abc.play.components.BarLine;
import me.ichun.mods.clef.common.util.abc.play.components.Chord;
import me.ichun.mods.clef.common.util.abc.play.components.Note;
import me.ichun.mods.clef.common.util.abc.play.components.SingleNote;
import me.ichun.mods.clef.common.util.abc.play.components.Special;
import me.ichun.mods.clef.common.util.abc.play.components.TrackInfo;
import org.apache.commons.io.IOUtils;

public class AbcParser {
    public static final char[] accidentals = new char[]{'^', '=', '_'};
    public static final char[] notes = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'z', 'x', 'Z', 'X'};
    public static final char[] octaves = new char[]{',', '\''};
    public static final char[] numbers = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] ignored = new char[]{'-', '(', ')', '~', 'H', 'L', 'M', 'O', 'P', 'S', 'T', 'u', 'v'};
    public static final char[] brokenRhythm = new char[]{'<', '>'};
    public static final char[] endOfNoteChars = new char[]{',', '\'', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '/', ']'};
    public static final String[] barLinePattern = new String[]{"::", ":\\|", "\\|:", "[\\[]\\|", "\\|\\|", "\\|[\\]]", "\\|", "\\|[\\[]", "\\| [\\[]"};
    public static final String[] ignoredInfoPattern = new String[]{"[{].*[}]", "[\"].*[\"]", "[!].*[!]", "[+].*[+]"};
    public static String[] ignoredStarts = new String[]{"%", "r:", "A:", "O:", "N:", "G:", "H:", "+:", "I:"};
    public static String[] rejectFiles = new String[]{"P:", "V:"};

    /*
     * Enabled aggressive exception aggregation
     */
    public static TrackInfo parse(File file) {
        try (FileInputStream stream2222 = new FileInputStream(file);){
            TrackInfo abc = new TrackInfo();
            abc.setFileTitle(file.getName().substring(0, file.getName().length() - 4));
            ArrayList<Note> trackNotes = new ArrayList<Note>();
            boolean readKeys = false;
            List lines = IOUtils.readLines((InputStream)stream2222);
            for (int l222 = 0; l222 < lines.size(); ++l222) {
                String line;
                String lineA = (String)lines.get(l222);
                if (lineA.contains("%")) {
                    lineA = lineA.substring(0, lineA.indexOf("%"));
                }
                if ((line = lineA.trim()).isEmpty()) {
                    if (abc.referenceNumber == -1) continue;
                    readKeys = true;
                    continue;
                }
                String lineLower = line.toLowerCase();
                boolean handledLine = AbcParser.readCommand(trackNotes, line);
                if (lineLower.startsWith("k:")) {
                    readKeys = true;
                }
                if (handledLine) continue;
                if (!readKeys) {
                    if (lineLower.startsWith("x:")) {
                        if (abc.referenceNumber == -1) {
                            abc.referenceNumber = Integer.parseInt(line.substring(2).trim());
                            continue;
                        }
                        Clef.LOGGER.info((Object)("More than one reference number? - " + file.getName()));
                        continue;
                    }
                    if (lineLower.startsWith("t:")) {
                        abc.setTitle(line.substring(2).trim());
                        continue;
                    }
                    if (lineLower.startsWith("c:")) {
                        abc.composer = line.substring(2).trim();
                        continue;
                    }
                    if (lineLower.startsWith("z:")) {
                        abc.transcriber = line.substring(2).trim();
                        continue;
                    }
                    Clef.LOGGER.info((Object)("Unknown abc line in " + file.getName() + " - " + lineA));
                    continue;
                }
                if (lineLower.startsWith("x:")) {
                    Clef.LOGGER.warn((Object)("Clef doesn't support abc files with more than one tune yet, only reading the first tune: " + file.getName()));
                    break;
                }
                if (line.endsWith("\\")) {
                    if (l222 < lines.size() - 1) {
                        String newLine = line.substring(0, line.length() - 1) + (String)lines.get(l222 + 1);
                        lines.remove(l222 + 1);
                        lines.add(l222 + 1, newLine);
                        continue;
                    }
                    line = line.substring(0, line.length() - 1);
                }
                ArrayList<String> partsBarLines = new ArrayList<String>();
                partsBarLines.add(line);
                for (int j = 0; j < barLinePattern.length; ++j) {
                    for (int i = partsBarLines.size() - 1; i >= 0; --i) {
                        String s = (String)partsBarLines.get(i);
                        partsBarLines.remove(i);
                        partsBarLines.addAll(Splitter.onPattern((String)barLinePattern[j]).trimResults().splitToList((CharSequence)s));
                    }
                }
                for (int v2 = 0; v2 < partsBarLines.size(); ++v2) {
                    String partPerBar = (String)partsBarLines.get(v2);
                    if (partPerBar.isEmpty()) {
                        trackNotes.add(new BarLine());
                        continue;
                    }
                    try {
                        while (true) {
                            Integer.parseInt(partPerBar.substring(0, 1));
                            partPerBar = partPerBar.substring(1);
                        }
                    }
                    catch (NumberFormatException e) {
                        ArrayList<String> partsGraces = new ArrayList<String>();
                        partsGraces.add(partPerBar);
                        for (int j = 0; j < ignoredInfoPattern.length; ++j) {
                            for (int i = partsGraces.size() - 1; i >= 0; --i) {
                                String s = (String)partsGraces.get(i);
                                partsGraces.remove(i);
                                partsGraces.addAll(Splitter.onPattern((String)ignoredInfoPattern[j]).omitEmptyStrings().trimResults().splitToList((CharSequence)s));
                            }
                        }
                        for (int k = 0; k < partsGraces.size(); ++k) {
                            String partPerGrace = (String)partsGraces.get(k);
                            if (partPerGrace.contains("[") && partPerGrace.indexOf("[") < partPerGrace.indexOf(":") && partPerGrace.indexOf("]") > partPerGrace.indexOf(":")) {
                                partsGraces.remove(k);
                                partsGraces.add(k, partPerGrace.substring(0, partPerGrace.indexOf("[")));
                                partsGraces.add(k + 1, partPerGrace.substring(partPerGrace.indexOf("["), partPerGrace.indexOf("]") + 1));
                                partsGraces.add(k + 2, partPerGrace.substring(partPerGrace.indexOf("]") + 1, partPerGrace.length()));
                                --k;
                                continue;
                            }
                            if (partPerGrace.contains(":")) {
                                if (partPerGrace.startsWith("[") && partPerGrace.endsWith("]")) {
                                    AbcParser.readCommand(trackNotes, partPerGrace.substring(1, partPerGrace.length() - 1));
                                    continue;
                                }
                                AbcParser.readCommand(trackNotes, partPerGrace);
                                continue;
                            }
                            ArrayList partsNotes = new ArrayList();
                            partsNotes.addAll(Splitter.onPattern((String)" ").omitEmptyStrings().trimResults().splitToList((CharSequence)partPerGrace));
                            Chord chord = null;
                            for (int o = 0; o < partsNotes.size(); ++o) {
                                ArrayList<String> note = new ArrayList<String>();
                                String partNote = (String)partsNotes.get(o);
                                int noteIndex = partNote.length();
                                boolean foundStartOfNote = false;
                                for (int x = partNote.length() - 1; x >= 0; --x) {
                                    char key = partNote.charAt(x);
                                    boolean startNote = true;
                                    for (char c : notes) {
                                        if (key != c || !foundStartOfNote) continue;
                                        note.add(0, partNote.substring(x + 1, noteIndex));
                                        noteIndex = x + 1;
                                        foundStartOfNote = false;
                                    }
                                    for (char c : endOfNoteChars) {
                                        if (key != c) continue;
                                        if (foundStartOfNote) {
                                            note.add(0, partNote.substring(x + 1, noteIndex));
                                            noteIndex = x + 1;
                                            foundStartOfNote = false;
                                        }
                                        startNote = false;
                                    }
                                    if (startNote) {
                                        foundStartOfNote = true;
                                    }
                                    if (x != 0) continue;
                                    note.add(0, partNote.substring(x, noteIndex));
                                    foundStartOfNote = false;
                                }
                                for (String singleNoteString : note) {
                                    if (singleNoteString.startsWith("[") && singleNoteString.length() > 1 && singleNoteString.substring(1, 2).matches("\\d")) {
                                        singleNoteString = singleNoteString.substring(2);
                                    }
                                    SingleNote singleNote = new SingleNote();
                                    boolean added = false;
                                    int brokenRhythmValue = 0;
                                    for (int r = 0; r < singleNoteString.length(); ++r) {
                                        char key = singleNoteString.charAt(r);
                                        if (key == '[') {
                                            if (chord != null) {
                                                Clef.LOGGER.warn((Object)("Uh oh, we found a malformed chord start in: " + file.getName()));
                                                Clef.LOGGER.warn((Object)("Line: " + line));
                                                continue;
                                            }
                                            chord = new Chord();
                                            continue;
                                        }
                                        if (key == ']') {
                                            ArrayList<Note> trackNotes1;
                                            if (chord == null) {
                                                Clef.LOGGER.warn((Object)("Uh oh, we found a malformed chord end in: " + file.getName()));
                                                Clef.LOGGER.warn((Object)("Line: " + line));
                                                continue;
                                            }
                                            ++r;
                                            int chordNum = -1;
                                            int chordDom = -1;
                                            int foundOperator = 0;
                                            while (r < singleNoteString.length()) {
                                                char key1 = singleNoteString.charAt(r);
                                                if (key1 == '/') {
                                                    foundOperator = 1;
                                                    if (chordNum == -1) {
                                                        chordNum = 1;
                                                    }
                                                } else {
                                                    boolean notANumber = true;
                                                    for (char c : numbers) {
                                                        if (c != key) continue;
                                                        notANumber = false;
                                                        if (foundOperator != 0) {
                                                            if (chordDom == -1) {
                                                                chordDom = Integer.parseInt(Character.toString(c));
                                                                continue;
                                                            }
                                                            chordDom *= 10;
                                                            chordDom += Integer.parseInt(Character.toString(c));
                                                            continue;
                                                        }
                                                        if (chordNum == -1) {
                                                            chordNum = Integer.parseInt(Character.toString(c));
                                                            continue;
                                                        }
                                                        chordNum *= 10;
                                                        chordNum += Integer.parseInt(Character.toString(c));
                                                    }
                                                    if (notANumber) {
                                                        Clef.LOGGER.warn((Object)("Uh oh, we found a problem looking for the chord duration in " + file.getName() + ". Found key: " + Character.toString(key)));
                                                        Clef.LOGGER.warn((Object)("Line: " + line));
                                                    }
                                                }
                                                ++r;
                                            }
                                            if (chordDom == -1) {
                                                chordDom = foundOperator != 0 ? 2 : 1;
                                            }
                                            if (chordNum == -1) {
                                                chordNum = 1;
                                            }
                                            chord.duration = (float)chordNum / (float)chordDom;
                                            if (brokenRhythmValue != 0 && !(trackNotes1 = chord.notes).isEmpty() && trackNotes1.get(trackNotes1.size() - 1) instanceof SingleNote) {
                                                SingleNote referenceNote = (SingleNote)trackNotes1.get(trackNotes1.size() - 1);
                                                if (brokenRhythmValue == 1) {
                                                    singleNote.duration += referenceNote.duration / 2.0;
                                                    referenceNote.duration /= 2.0;
                                                } else {
                                                    referenceNote.duration += singleNote.duration / 2.0;
                                                    singleNote.duration /= 2.0;
                                                }
                                            }
                                            chord.notes.add(singleNote);
                                            added = true;
                                            trackNotes.add(chord);
                                            chord = null;
                                            continue;
                                        }
                                        boolean handled = false;
                                        for (char c : ignored) {
                                            if (key != c) continue;
                                            handled = true;
                                            break;
                                        }
                                        for (char c : accidentals) {
                                            if (key != c) continue;
                                            handled = true;
                                            singleNote.constructs.add(new Accidental(key));
                                            break;
                                        }
                                        for (char c : notes) {
                                            if (key != c) continue;
                                            handled = true;
                                            singleNote.constructs.add(new me.ichun.mods.clef.common.util.abc.construct.Note(key));
                                            break;
                                        }
                                        for (char c : octaves) {
                                            if (key != c) continue;
                                            handled = true;
                                            singleNote.constructs.add(new Octave(key));
                                            break;
                                        }
                                        for (char c : brokenRhythm) {
                                            if (key != c) continue;
                                            handled = true;
                                            brokenRhythmValue = key == '<' ? 1 : -1;
                                            break;
                                        }
                                        if (handled) continue;
                                        int noteNum = -1;
                                        int noteDom = -1;
                                        boolean foundOperator = false;
                                        while (r < singleNoteString.length()) {
                                            char key1 = singleNoteString.charAt(r);
                                            if (key1 == '/') {
                                                foundOperator = true;
                                                if (noteNum == -1) {
                                                    noteNum = 1;
                                                }
                                            } else if (key1 == ']') {
                                                if (chord == null) {
                                                    Clef.LOGGER.warn((Object)("Uh oh, we found a malformed chord end in: " + file.getName()));
                                                    Clef.LOGGER.warn((Object)("Line: " + line));
                                                } else {
                                                    ArrayList<Note> trackNotes1;
                                                    ++r;
                                                    int chordNum = -1;
                                                    int chordDom = -1;
                                                    boolean foundOperator2 = false;
                                                    while (r < singleNoteString.length()) {
                                                        char key2 = singleNoteString.charAt(r);
                                                        if (key2 == '/') {
                                                            foundOperator2 = true;
                                                            if (chordNum == -1) {
                                                                chordNum = 1;
                                                            }
                                                        } else {
                                                            boolean notANumber = true;
                                                            for (char c : numbers) {
                                                                if (c != key2) continue;
                                                                notANumber = false;
                                                                if (foundOperator2) {
                                                                    if (chordDom == -1) {
                                                                        chordDom = Integer.parseInt(Character.toString(c));
                                                                        continue;
                                                                    }
                                                                    chordDom *= 10;
                                                                    chordDom += Integer.parseInt(Character.toString(c));
                                                                    continue;
                                                                }
                                                                if (chordNum == -1) {
                                                                    chordNum = Integer.parseInt(Character.toString(c));
                                                                    continue;
                                                                }
                                                                chordNum *= 10;
                                                                chordNum += Integer.parseInt(Character.toString(c));
                                                            }
                                                            if (notANumber) {
                                                                Clef.LOGGER.warn((Object)("Uh oh, we found a problem looking for the chord duration in " + file.getName() + ". Found key: " + Character.toString(key)));
                                                                Clef.LOGGER.warn((Object)("Line: " + line));
                                                            }
                                                        }
                                                        ++r;
                                                    }
                                                    if (chordDom == -1) {
                                                        chordDom = foundOperator2 ? 2 : 1;
                                                    }
                                                    if (chordNum == -1) {
                                                        chordNum = 1;
                                                    }
                                                    chord.duration = (float)chordNum / (float)chordDom;
                                                    if (brokenRhythmValue != 0 && !(trackNotes1 = chord.notes).isEmpty() && trackNotes1.get(trackNotes1.size() - 1) instanceof SingleNote) {
                                                        SingleNote referenceNote = (SingleNote)trackNotes1.get(trackNotes1.size() - 1);
                                                        if (brokenRhythmValue == 1) {
                                                            singleNote.duration += referenceNote.duration / 2.0;
                                                            referenceNote.duration /= 2.0;
                                                        } else {
                                                            referenceNote.duration += singleNote.duration / 2.0;
                                                            singleNote.duration /= 2.0;
                                                        }
                                                    }
                                                    chord.notes.add(singleNote);
                                                    added = true;
                                                    trackNotes.add(chord);
                                                    chord = null;
                                                }
                                            } else {
                                                boolean notANumber = true;
                                                for (char c : numbers) {
                                                    if (c != key1) continue;
                                                    notANumber = false;
                                                    if (foundOperator) {
                                                        if (noteDom == -1) {
                                                            noteDom = Integer.parseInt(Character.toString(c));
                                                            continue;
                                                        }
                                                        noteDom *= 10;
                                                        noteDom += Integer.parseInt(Character.toString(c));
                                                        continue;
                                                    }
                                                    if (noteNum == -1) {
                                                        noteNum = Integer.parseInt(Character.toString(c));
                                                        continue;
                                                    }
                                                    noteNum *= 10;
                                                    noteNum += Integer.parseInt(Character.toString(c));
                                                }
                                                if (notANumber) {
                                                    Clef.LOGGER.warn((Object)("Uh oh, we found a problem looking for the note duration in " + file.getName() + ". Found key: " + Character.toString(key)));
                                                    Clef.LOGGER.warn((Object)("Line: " + line));
                                                }
                                            }
                                            ++r;
                                        }
                                        if (noteDom == -1) {
                                            noteDom = foundOperator ? 2 : 1;
                                        }
                                        if (noteNum == -1) {
                                            noteNum = 1;
                                        }
                                        singleNote.duration = (float)noteNum / (float)noteDom;
                                    }
                                    if (brokenRhythmValue != 0) {
                                        ArrayList<Note> trackNotes1;
                                        ArrayList<Note> arrayList = trackNotes1 = chord != null ? chord.notes : trackNotes;
                                        if (!trackNotes1.isEmpty() && trackNotes1.get(trackNotes1.size() - 1) instanceof SingleNote) {
                                            SingleNote referenceNote = (SingleNote)trackNotes1.get(trackNotes1.size() - 1);
                                            if (brokenRhythmValue == 1) {
                                                singleNote.duration += referenceNote.duration / 2.0;
                                                referenceNote.duration /= 2.0;
                                            } else {
                                                referenceNote.duration += singleNote.duration / 2.0;
                                                singleNote.duration /= 2.0;
                                            }
                                        }
                                    }
                                    if (added || singleNote.constructs.isEmpty()) continue;
                                    if (chord != null) {
                                        chord.notes.add(singleNote);
                                        continue;
                                    }
                                    trackNotes.add(singleNote);
                                }
                            }
                        }
                        if (v2 + 1 >= partsBarLines.size()) continue;
                        trackNotes.add(new BarLine());
                    }
                }
            }
            if (trackNotes.isEmpty()) {
                TrackInfo l222 = null;
                return l222;
            }
            double[] info = new double[]{20.0, 0.125, 1.0, 0.0, 0.25};
            HashMap<Integer, Integer> keySignatures = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> keyAccidentals = new HashMap<Integer, Integer>();
            int currentTick = 0;
            for (Note note : trackNotes) {
                HashSet noteAtTime = abc.notes.computeIfAbsent(currentTick, v -> new HashSet());
                if (!note.setup(info, keyAccidentals, keySignatures)) continue;
                noteAtTime.add(note);
                abc.trackLength = currentTick + note.durationInTicks;
                currentTick += note.durationInTicks;
            }
            TrackInfo trackInfo = abc;
            return trackInfo;
        }
        catch (IOException | NumberFormatException stream2222) {
        }
        catch (Exception e) {
            Clef.LOGGER.warn((Object)("Error reading ABC file: " + file.getName()));
            e.printStackTrace();
        }
        return null;
    }

    public static boolean readCommand(ArrayList<Note> notes, String line) {
        String lineLower = line.toLowerCase();
        boolean handledLine = false;
        if (lineLower.startsWith("l:")) {
            String[] s = line.substring(2).split("/");
            if (s.length == 1) {
                notes.add(new Special(new UnitNoteLength(Integer.parseInt(s[0].trim()))));
            } else if (s.length == 2) {
                notes.add(new Special(new UnitNoteLength((double)Integer.parseInt(s[0].trim()) / (double)Integer.parseInt(s[1].trim()))));
            }
            handledLine = true;
        } else if (lineLower.startsWith("q:")) {
            notes.add(new Special(new Tempo(line.substring(2).trim())));
            handledLine = true;
        } else if (lineLower.startsWith("m:")) {
            String[] s = line.substring(2).split("/");
            if (s.length == 1) {
                notes.add(new Special(new Meter(Integer.parseInt(s[0].trim()))));
            } else if (s.length == 2) {
                notes.add(new Special(new Meter((double)Integer.parseInt(s[0].trim()) / (double)Integer.parseInt(s[1].trim()))));
            }
            handledLine = true;
        } else if (lineLower.startsWith("k:")) {
            handledLine = true;
            notes.add(new Special(new Key(line.substring(2).trim())));
        } else {
            for (String ig : ignoredStarts) {
                if (!lineLower.startsWith(ig.toLowerCase())) continue;
                handledLine = true;
                break;
            }
        }
        return handledLine;
    }
}

