/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play;

import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Random;
import me.ichun.mods.clef.client.sound.InstrumentSound;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentTuning;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayedNote {
    public final Instrument instrument;
    public final int key;
    public final int startTick;
    public final int duration;
    public final InstrumentSound instrumentSound;
    public Object noteLocation;
    public String uniqueId;
    public boolean played;
    private static Random rand = new Random();

    public PlayedNote(Instrument instrument, int startTick, int duration, int key, SoundCategory category, Object noteLocation) {
        this.instrument = instrument;
        this.key = key;
        this.startTick = startTick;
        this.duration = duration;
        this.noteLocation = noteLocation;
        this.uniqueId = MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString();
        InstrumentTuning.TuningInfo tuning = instrument.tuning.keyToTuningMap.get(key);
        float pitch = (float)Math.pow(2.0, (double)tuning.keyOffset / 12.0);
        this.instrumentSound = new InstrumentSound(this.uniqueId, SoundEvents.field_187682_dG, category, duration, (int)Math.ceil(instrument.tuning.fadeout * 20.0f), 0.7f * ((float)Clef.config.instrumentVolume / 100.0f), pitch, noteLocation);
    }

    public PlayedNote start() {
        Minecraft mc = Minecraft.func_71410_x();
        SoundManager soundManager = mc.func_147118_V().field_147694_f;
        if (mc.field_71474_y.func_186711_a(SoundCategory.MASTER) > 0.0f && this.instrument.hasAvailableKey(this.key)) {
            this.instrumentSound.func_184366_a(mc.func_147118_V());
            float f3 = this.instrumentSound.func_147653_e();
            float f = 16.0f;
            if (f3 > 1.0f) {
                f *= f3;
            }
            SoundCategory soundcategory = this.instrumentSound.func_184365_d();
            float f1 = soundManager.func_188770_e((ISound)this.instrumentSound);
            InstrumentTuning.TuningInfo tuning = this.instrument.tuning.keyToTuningMap.get(this.key);
            float f2 = (float)Math.pow(2.0, (double)tuning.keyOffset / 12.0);
            soundManager.field_148620_e.newSource(false, this.uniqueId, PlayedNote.getURLForSoundResource(this.instrument, this.key - tuning.keyOffset), "clef:" + this.instrument.info.itemName + ":" + (this.key - tuning.keyOffset) + ".ogg", false, this.instrumentSound.func_147649_g(), this.instrumentSound.func_147654_h(), this.instrumentSound.func_147651_i(), this.instrumentSound.func_147656_j().func_148586_a(), f);
            MinecraftForge.EVENT_BUS.post((Event)new PlaySoundSourceEvent(soundManager, (ISound)this.instrumentSound, this.uniqueId));
            soundManager.field_148620_e.setPitch(this.uniqueId, f2);
            soundManager.field_148620_e.setVolume(this.uniqueId, f1);
            soundManager.field_148620_e.play(this.uniqueId);
            soundManager.field_148624_n.put(this.uniqueId, soundManager.field_148618_g + this.duration + (int)(this.instrument.tuning.fadeout * 20.0f) + 20);
            soundManager.field_148629_h.put(this.uniqueId, this.instrumentSound);
            if (soundcategory != SoundCategory.MASTER) {
                soundManager.field_188776_k.put((Object)soundcategory, (Object)this.uniqueId);
            }
            soundManager.field_148625_l.add(this.instrumentSound);
            this.played = true;
        }
        return this;
    }

    private static URL getURLForSoundResource(final Instrument instrument, final int key) {
        final int randKey = rand.nextInt(instrument.tuning.keyToTuningMap.get((Object)Integer.valueOf((int)key)).stream.length);
        String s = String.format("%s:%s:%s", "clef", instrument.info.itemName, key + ":" + randKey + ".ogg");
        URLStreamHandler urlstreamhandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL p_openConnection_1_) {
                return new URLConnection(p_openConnection_1_){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return instrument.tuning.keyToTuningMap.get((Object)Integer.valueOf((int)key)).stream[randKey];
                    }
                };
            }
        };
        try {
            return new URL(null, s, urlstreamhandler);
        }
        catch (MalformedURLException var4) {
            throw new Error("Minecraft no has proper error throwing and handling.");
        }
    }
}

