/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.instrument;

import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import me.ichun.mods.clef.client.gui.GuiPlayTrack;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.packet.PacketFileFragment;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentInfo;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentModPackInfo;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentPackInfo;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentTuning;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

public class InstrumentLibrary {
    public static ArrayList<Instrument> instruments = new ArrayList();
    public static HashMap<String, HashSet<String>> requestsFromPlayers = new HashMap();
    public static HashSet<String> requestedInstrumentsFromServer = new HashSet();
    public static HashSet<String> requestedInstrumentsFromPlayers = new HashSet();

    public static void init() {
        instruments.clear();
        File defaultPack = new File(Clef.getResourceHelper().instrumentDir, "starbound.cia");
        if (!defaultPack.exists()) {
            try (InputStream in = Clef.class.getResourceAsStream("/starbound.cia");){
                FileOutputStream file = new FileOutputStream(defaultPack);
                IOUtils.copy((InputStream)in, (OutputStream)file);
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Clef.LOGGER.info((Object)"Loading instruments");
        Clef.LOGGER.info((Object)("Loaded " + InstrumentLibrary.readInstruments(Clef.getResourceHelper().instrumentDir, instruments) + " instruments"));
    }

    private static int readInstruments(File dir, ArrayList<Instrument> instruments) {
        int instrumentsCount = 0;
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                instrumentsCount += InstrumentLibrary.readInstruments(file, instruments);
                continue;
            }
            instrumentsCount += InstrumentLibrary.readInstrumentPack(file, instruments);
        }
        return instrumentsCount;
    }

    public static int readInstrumentPack(File file, ArrayList<Instrument> instruments) {
        int instrumentCount = 0;
        if (file.exists() && file.getName().endsWith(".pak")) {
            Clef.LOGGER.warn((Object)("We can't read Starbound Mod Packs in .pak format! File: " + file.getName()));
            return 0;
        }
        if (file.exists() && (file.getName().endsWith(".cia") || file.getName().endsWith(".zip"))) {
            Clef.LOGGER.info((Object)("Reading file: " + file.getName()));
            try {
                ZipFile zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entriesIte = zipFile.entries();
                InstrumentPackInfo packInfo = new InstrumentPackInfo();
                ZipEntry packInfoZip = zipFile.getEntry("info.cii");
                if (packInfoZip != null) {
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)zipFile.getInputStream(packInfoZip), (Writer)writer);
                    String jsonString = writer.toString();
                    packInfo = (InstrumentPackInfo)new Gson().fromJson(jsonString, InstrumentPackInfo.class);
                }
                ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
                while (entriesIte.hasMoreElements()) {
                    ZipEntry entry = entriesIte.nextElement();
                    if (entry.getName().endsWith(".modinfo")) {
                        StringWriter writer = new StringWriter();
                        IOUtils.copy((InputStream)zipFile.getInputStream(entry), (Writer)writer);
                        String string = writer.toString();
                        packInfo = InstrumentPackInfo.fromModInfo((InstrumentModPackInfo)new Gson().fromJson(string, InstrumentModPackInfo.class));
                        continue;
                    }
                    if (entry.isDirectory() || entry.getName().endsWith(".png")) continue;
                    entries.add(entry);
                }
                ArrayList<Object> instrumentInfos = new ArrayList<Object>();
                for (int i = entries.size() - 1; i >= 0; --i) {
                    ZipEntry zipEntry = (ZipEntry)entries.get(i);
                    if (!zipEntry.getName().startsWith("items/instruments/") || !zipEntry.getName().endsWith(".instrument")) continue;
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)zipFile.getInputStream(zipEntry), (Writer)writer);
                    String jsonString = writer.toString();
                    instrumentInfos.add(new Gson().fromJson(jsonString, InstrumentInfo.class));
                    entries.remove(i);
                }
                for (InstrumentInfo instrumentInfo : instrumentInfos) {
                    if (InstrumentLibrary.isInstrumentDisabled(instrumentInfo.itemName)) {
                        Clef.LOGGER.warn((Object)("Not loading instrument " + instrumentInfo.itemName + " from pack " + file.getName() + ". Instrument is disabled."));
                        continue;
                    }
                    ZipEntry icon = zipFile.getEntry("items/instruments/" + instrumentInfo.inventoryIcon);
                    ZipEntry hand = zipFile.getEntry("items/instruments/" + instrumentInfo.activeImage);
                    ZipEntry tuning = zipFile.getEntry("sfx/instruments/" + instrumentInfo.kind + "/tuning.config");
                    if (icon == null || hand == null || tuning == null) {
                        Clef.LOGGER.warn((Object)("Error loading instrument " + instrumentInfo.itemName + " from pack " + file.getName()));
                        continue;
                    }
                    try {
                        InputStream iconStm = zipFile.getInputStream(icon);
                        Throwable throwable = null;
                        try {
                            InputStream handStm = zipFile.getInputStream(hand);
                            Throwable throwable2 = null;
                            try {
                                InputStream tuningStm = zipFile.getInputStream(tuning);
                                Throwable throwable3 = null;
                                try {
                                    Instrument instrument = new Instrument(instrumentInfo, ImageIO.read(iconStm), ImageIO.read(handStm));
                                    StringWriter writer = new StringWriter();
                                    IOUtils.copy((InputStream)tuningStm, (Writer)writer);
                                    String jsonString = writer.toString();
                                    InstrumentTuning tuning1 = (InstrumentTuning)new Gson().fromJson(jsonString, InstrumentTuning.class);
                                    TreeMap<Integer, String[]> tuningInfo = new TreeMap<Integer, String[]>((Comparator<Integer>)Ordering.natural());
                                    for (Map.Entry<String, InstrumentTuning.TuningInt> entry : tuning1.mapping.entrySet()) {
                                        String[] files = null;
                                        if (entry.getValue().files != null) {
                                            files = entry.getValue().files;
                                        } else if (entry.getValue().file != null) {
                                            files = new String[]{entry.getValue().file};
                                        }
                                        tuningInfo.put(Integer.parseInt(entry.getKey()), files);
                                    }
                                    for (Map.Entry<String, InstrumentTuning.TuningInt> entry : tuningInfo.entrySet()) {
                                        InputStream[] streams = null;
                                        boolean mute = false;
                                        if (entry.getValue() != null) {
                                            String[] files = (String[])entry.getValue();
                                            ArrayList<ByteArrayInputStream> streamList = new ArrayList<ByteArrayInputStream>();
                                            for (int i = 0; i < files.length; ++i) {
                                                int len;
                                                String s = files[i];
                                                String[] fileNameSplit = s.split("/");
                                                String fileName = fileNameSplit[fileNameSplit.length - 1];
                                                ZipEntry sound = zipFile.getEntry("sfx/instruments/" + instrumentInfo.kind + "/" + fileName);
                                                if (fileName.contains("mute")) {
                                                    mute = true;
                                                }
                                                if (!fileName.endsWith(".ogg")) {
                                                    Clef.LOGGER.warn((Object)("Error loading instrument " + instrumentInfo.itemName + " from pack " + file.getName() + ". Audio files are not .ogg"));
                                                    continue;
                                                }
                                                if (sound == null) {
                                                    Clef.LOGGER.warn((Object)("Error loading instrument " + instrumentInfo.itemName + " from pack " + file.getName() + ". Audio file " + fileName + " does not exist. Skipping file."));
                                                    continue;
                                                }
                                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                                byte[] buffer = new byte[1024];
                                                InputStream input = zipFile.getInputStream(sound);
                                                while ((len = input.read(buffer)) > -1) {
                                                    baos.write(buffer, 0, len);
                                                }
                                                baos.flush();
                                                streamList.add(new ByteArrayInputStream(baos.toByteArray()));
                                                tuning1.audioToOutputStream.put(fileName, baos);
                                            }
                                            if (!streamList.isEmpty()) {
                                                streams = streamList.toArray(new InputStream[streamList.size()]);
                                            }
                                        }
                                        if (streams == null) continue;
                                        if (mute) {
                                            tuning1.keyToTuningMap.put((Integer)((Object)entry.getKey()), new InstrumentTuning.TuningInfo(new InputStream[0], 0));
                                            continue;
                                        }
                                        for (int i = -6; i <= 6; ++i) {
                                            if (tuning1.keyToTuningMap.containsKey((Integer)((Object)entry.getKey()) + i)) continue;
                                            tuning1.keyToTuningMap.put((Integer)((Object)entry.getKey()) + i, new InstrumentTuning.TuningInfo(streams, i));
                                        }
                                    }
                                    instrument.tuning = tuning1;
                                    instrument.packInfo = packInfo;
                                    instruments.add(instrument);
                                    ++instrumentCount;
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (tuningStm == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            tuningStm.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    tuningStm.close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (handStm == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        handStm.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                handStm.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (iconStm == null) continue;
                            if (throwable != null) {
                                try {
                                    iconStm.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            iconStm.close();
                        }
                    }
                    catch (Exception e) {
                        Clef.LOGGER.warn((Object)("Error loading instrument " + instrumentInfo.itemName + " from pack " + file.getName()));
                        e.printStackTrace();
                    }
                }
                Collections.sort(instruments);
            }
            catch (Exception e) {
                Clef.LOGGER.warn((Object)("Error loading instrument pack: " + file.getName()));
                e.printStackTrace();
            }
        }
        return instrumentCount;
    }

    @SideOnly(value=Side.CLIENT)
    public static void reloadInstruments(GuiPlayTrack gui) {
        ArrayList<Instrument> instruments = new ArrayList<Instrument>();
        Clef.LOGGER.info((Object)"Reloading instruments");
        Clef.LOGGER.info((Object)("Reloaded " + InstrumentLibrary.readInstruments(Clef.getResourceHelper().instrumentDir, instruments) + " instruments"));
        for (Instrument instrument : InstrumentLibrary.instruments) {
            if (instrument.iconModel != null) {
                Minecraft.func_71410_x().func_110434_K().func_147645_c(instrument.iconModel.instTx);
            }
            if (instrument.handModel == null) continue;
            Minecraft.func_71410_x().func_110434_K().func_147645_c(instrument.handModel.instTx);
        }
        InstrumentLibrary.instruments = instruments;
        gui.doneTimeout = 20;
    }

    public static void injectLocalization(Instrument instrument) {
        String localName = "item.clef.instrument." + instrument.info.itemName + ".name=" + instrument.info.shortdescription;
        String localDesc = "item.clef.instrument." + instrument.info.itemName + ".desc=" + instrument.info.description;
        ByteArrayInputStream streamName = new ByteArrayInputStream(localName.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream streamDesc = new ByteArrayInputStream(localDesc.getBytes(StandardCharsets.UTF_8));
        LanguageMap.inject((InputStream)streamName);
        LanguageMap.inject((InputStream)streamDesc);
    }

    public static Instrument getInstrumentByName(String s) {
        for (Instrument instrument : instruments) {
            if (!instrument.info.itemName.equalsIgnoreCase(s)) continue;
            return instrument;
        }
        return null;
    }

    public static void checkForInstrument(ItemStack is, EntityPlayer player) {
        NBTTagCompound tag = is.func_77978_p();
        if (tag != null) {
            String instName = tag.func_74779_i("itemName");
            Instrument inst = InstrumentLibrary.getInstrumentByName(instName);
            if (inst == null) {
                InstrumentLibrary.requestInstrument(instName, player);
            }
        } else {
            InstrumentLibrary.assignRandomInstrument(is);
        }
    }

    public static void assignRandomInstrument(ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("itemName", InstrumentLibrary.instruments.get((int)((int)Math.floor((double)(Math.random() * (double)InstrumentLibrary.instruments.size())))).info.itemName);
        is.func_77982_d(tag);
    }

    public static void requestInstrument(String name, EntityPlayer player) {
        if (player == null) {
            if (requestedInstrumentsFromServer.add(name)) {
                Clef.channel.sendToServer((AbstractPacket)new PacketRequestFile(name, true));
            }
        } else if (requestedInstrumentsFromPlayers.add(name)) {
            Clef.channel.sendTo((AbstractPacket)new PacketRequestFile(name, true), player);
        }
    }

    public static boolean isInstrumentDisabled(String name) {
        for (String s : Clef.config.disabledInstruments) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void packageAndSendInstrument(String name, EntityPlayer player) {
        if (name.isEmpty()) {
            return;
        }
        Instrument instrument = InstrumentLibrary.getInstrumentByName(name);
        if (instrument != null) {
            ByteArrayOutputStream baos = instrument.getAsBAOS();
            if (baos != null) {
                int fileSize;
                byte[] file = baos.toByteArray();
                if (file.length > 10000000) {
                    Clef.LOGGER.warn((Object)("Unable to send instrument " + instrument.info.itemName + ". It is above the size limit!"));
                    return;
                }
                if (file.length == 0) {
                    Clef.LOGGER.warn((Object)("Unable to send instrument " + instrument.info.itemName + ". The file is empty!"));
                    return;
                }
                Clef.LOGGER.info((Object)("Sending instrument " + instrument.info.itemName + " to " + (player == null ? "the server" : player.func_70005_c_())));
                int packetsToSend = (int)Math.ceil((float)fileSize / 32000.0f);
                int packetCount = 0;
                int index = 0;
                for (fileSize = file.length; fileSize > 0; fileSize -= 32000) {
                    byte[] fileBytes = new byte[fileSize > 32000 ? 32000 : fileSize];
                    System.arraycopy(file, index, fileBytes, 0, fileBytes.length);
                    index += fileBytes.length;
                    if (player != null) {
                        Clef.channel.sendTo((AbstractPacket)new PacketFileFragment(instrument.info.itemName + ".cia", packetsToSend, packetCount, fileSize > 32000 ? 32000 : fileSize, fileBytes), player);
                    } else {
                        Clef.channel.sendToServer((AbstractPacket)new PacketFileFragment(instrument.info.itemName + ".cia", packetsToSend, packetCount, fileSize > 32000 ? 32000 : fileSize, fileBytes));
                    }
                    ++packetCount;
                }
            }
        } else if (player != null) {
            HashSet players = requestsFromPlayers.computeIfAbsent(name, v -> new HashSet());
            players.add(player.func_70005_c_());
            if (requestedInstrumentsFromPlayers.add(name)) {
                Clef.channel.sendToAllExcept((AbstractPacket)new PacketRequestFile(name, true), player);
            }
        }
    }

    public static void handleReceivedFile(String fileName, byte[] fileData, Side side) {
        File dir = new File(Clef.getResourceHelper().instrumentDir, "received");
        File file = new File(dir, fileName);
        try {
            dir.mkdirs();
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(fileData);
            fos.close();
            Clef.LOGGER.info((Object)("Received " + fileName + ". Reading."));
            InstrumentLibrary.readInstrumentPack(file, instruments);
            if (!InstrumentLibrary.isInstrumentDisabled(fileName.substring(0, fileName.length() - 4))) {
                if (side.isServer()) {
                    String instName = fileName.substring(0, fileName.length() - 4);
                    requestedInstrumentsFromPlayers.remove(instName);
                    HashSet<String> playersRequesting = requestsFromPlayers.get(instName);
                    if (playersRequesting != null) {
                        for (String s : playersRequesting) {
                            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(s);
                            if (player == null) continue;
                            InstrumentLibrary.packageAndSendInstrument(instName, (EntityPlayer)player);
                        }
                    }
                } else {
                    requestedInstrumentsFromServer.remove(fileName.substring(0, fileName.length() - 4));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

