/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import me.ichun.mods.clef.client.gui.GuiTrackList;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.packet.PacketPlayABC;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPlayTrack
extends Screen {
    public static final ResourceLocation texBackground = new ResourceLocation("clef", "textures/gui/track_select.png");
    public static final ResourceLocation texBackgroundBlock = new ResourceLocation("clef", "textures/gui/track_select_block.png");
    public static final ResourceLocation texInstrument = new ResourceLocation("clef", "textures/items/instrument.png");
    public static final ResourceLocation texNote = new ResourceLocation("minecraft", "textures/particle/note.png");
    public static final ResourceLocation texIcons = new ResourceLocation("minecraft", "textures/gui/icons.png");
    public ResourceLocation background = texBackground;
    protected int xSize = 256;
    protected int ySize = 230;
    protected int guiLeft;
    protected int guiTop;
    public TextFieldWidget bandName;
    public GuiTrackList trackList;
    public int trackListBottom;
    public int syncPlay = 1;
    public int syncTrack = 0;
    public int index = -1;
    public int doneTimeout = 0;
    public ArrayList<TrackFile> tracks = AbcLibrary.tracks;
    public String bandNameString = "";
    public int scrollTicker = 0;
    public int bandIndex = 0;
    public boolean disableListWhenSyncTrack = true;
    public Button buttonConfirm = null;
    public Button buttonSyncPlay = null;
    public Button buttonSyncTrack = null;

    public GuiPlayTrack() {
        super((ITextComponent)new TranslationTextComponent("clef.gui.chooser", new Object[0]));
        this.bandNameString = Clef.configClient.favoriteBand;
    }

    public void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.trackListBottom = this.guiTop + this.ySize - 6;
        this.font.getClass();
        this.bandName = new TextFieldWidget(this.font, this.guiLeft + 181, this.guiTop + 18, 64, 9, I18n.func_135052_a((String)"clef.gui.band", (Object[])new Object[0]));
        this.bandName.func_146203_f(15);
        this.bandName.func_146185_a(false);
        this.bandName.func_146193_g(0xFFFFFF);
        this.bandName.func_146180_a(this.bandNameString);
        this.children.add(this.bandName);
        this.buttonConfirm = new Button(this.guiLeft + 174, this.guiTop + 210, 83, 20, I18n.func_135052_a((String)"clef.gui.play", (Object[])new Object[0]), btn -> this.confirmSelection(false));
        this.addButton((Widget)this.buttonConfirm);
        this.addButtons();
        this.buttonSyncPlay.active = !this.bandName.func_146179_b().isEmpty() && this.syncTrack == 0;
        this.buttonSyncPlay.setMessage(I18n.func_135052_a((String)(this.syncPlay == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
        this.buttonSyncTrack.active = !this.bandName.func_146179_b().isEmpty();
        this.buttonSyncTrack.setMessage(I18n.func_135052_a((String)(this.syncTrack == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
        this.trackList = new GuiTrackList(this, 158, this.ySize - 22, this.guiTop + 17, this.trackListBottom, this.guiLeft + 7, 8, this.tracks);
        this.children.add(this.trackList);
    }

    public void addButtons() {
        this.buttonSyncPlay = new Button(this.guiLeft + 179, this.guiTop + 51, 72, 20, I18n.func_135052_a((String)(this.syncPlay == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]), btn -> {
            this.syncPlay = this.syncPlay == 1 ? 0 : 1;
            btn.setMessage(I18n.func_135052_a((String)(this.syncPlay == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
        });
        this.addButton((Widget)this.buttonSyncPlay);
        this.buttonSyncTrack = new Button(this.guiLeft + 179, this.guiTop + 94, 72, 20, I18n.func_135052_a((String)(this.syncTrack == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]), btn -> {
            this.syncTrack = this.syncTrack == 1 ? 0 : 1;
            btn.setMessage(I18n.func_135052_a((String)(this.syncTrack == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
            boolean bl = this.buttonSyncPlay.active = this.syncTrack == 0;
            if (!this.buttonSyncPlay.active) {
                this.syncPlay = 1;
                this.buttonSyncPlay.setMessage(I18n.func_135052_a((String)"gui.yes", (Object[])new Object[0]));
            }
        });
        this.addButton((Widget)this.buttonSyncTrack);
        this.addReloadButtons();
    }

    public void addReloadButtons() {
        this.addButton((Widget)new Button(this.guiLeft + 179, this.guiTop + 137, 20, 20, "", btn -> {
            if (this.doneTimeout <= 0) {
                InstrumentLibrary.reloadInstruments(this);
            }
        }));
        this.addButton((Widget)new Button(this.guiLeft + 205, this.guiTop + 137, 20, 20, "", btn -> {
            if (this.doneTimeout <= 0) {
                AbcLibrary.reloadTracks(this);
            }
        }));
        this.addButton((Widget)new Button(this.guiLeft + 231, this.guiTop + 137, 20, 20, "", btn -> {
            Clef.configCommon.showFileTitle = !Clef.configCommon.showFileTitle;
            Clef.configCommon.save();
            Collections.sort(this.tracks);
        }));
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void tick() {
        ++this.scrollTicker;
        --this.doneTimeout;
        this.bandName.func_146178_a();
        this.bandNameString = this.bandName.func_146179_b();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean flag = super.keyPressed(keyCode, scanCode, modifiers);
        if (this.bandName.isFocused() && keyCode != 256) {
            this.syncPlay = 1;
            this.syncTrack = 1;
            this.buttonSyncPlay.active = false;
            this.buttonSyncPlay.setMessage(I18n.func_135052_a((String)(this.syncPlay == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
            this.buttonSyncTrack.setMessage(I18n.func_135052_a((String)(this.syncTrack == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
        }
        if (keyCode == 256) {
            if (this.bandName.isFocused()) {
                this.bandName.func_146180_a("");
                this.bandName.func_146195_b(false);
            } else {
                this.closeScreen();
                this.minecraft.field_71417_B.func_198034_i();
            }
        }
        this.buttonSyncPlay.active = !this.bandName.func_146179_b().isEmpty() && this.syncTrack == 0;
        this.buttonSyncPlay.setMessage(I18n.func_135052_a((String)(this.syncPlay == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
        this.buttonSyncTrack.active = !this.bandName.func_146179_b().isEmpty();
        this.buttonSyncTrack.setMessage(I18n.func_135052_a((String)(this.syncTrack == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
        this.bandNameString = this.bandName.func_146179_b();
        return flag;
    }

    public boolean shouldCloseOnEsc() {
        return !this.bandName.isFocused();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.background);
        this.blit(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        AbstractGui.fill((int)(this.guiLeft + 6), (int)(this.guiTop + 16), (int)(this.guiLeft + 166), (int)(this.trackListBottom + 1), (int)-1072689136);
        AbstractGui.fill((int)(this.guiLeft + 6 + 1), (int)(this.guiTop + 16 + 1), (int)(this.guiLeft + 166 - 1), (int)this.trackListBottom, (int)-15066598);
        if (this.bandName.func_146176_q()) {
            this.bandName.render(mouseX, mouseY, partialTicks);
        }
        this.font.func_175063_a(I18n.func_135052_a((String)"clef.gui.band", (Object[])new Object[0]), (float)(this.guiLeft + 179), (float)(this.guiTop + 5), 0xFFFFFF);
        if (this.bandName.func_146179_b().isEmpty() && !this.bandName.isFocused()) {
            this.font.func_211126_b(I18n.func_135052_a((String)"clef.gui.bandSolo", (Object[])new Object[0]), (float)(this.guiLeft + 182), (float)(this.guiTop + 18), 0xCCCCCC);
        }
        this.drawText();
        this.trackList.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        this.drawReloadButtons();
        if (this.syncTrack == 1 && this.disableListWhenSyncTrack && !this.bandName.func_146179_b().isEmpty()) {
            AbstractGui.fill((int)(this.guiLeft + 6), (int)(this.guiTop + 16), (int)(this.guiLeft + 166), (int)(this.trackListBottom + 1), (int)-1072689136);
        }
    }

    public void drawText() {
        this.font.func_175063_a(I18n.func_135052_a((String)"clef.gui.chooseSong", (Object[])new Object[0]) + " (" + this.tracks.size() + ")", (float)(this.guiLeft + 6), (float)(this.guiTop + 5), 0xFFFFFF);
        this.font.func_175063_a(I18n.func_135052_a((String)"clef.gui.syncPlayTime", (Object[])new Object[0]), (float)(this.guiLeft + 179), (float)(this.guiTop + 40), 0xFFFFFF);
        this.font.func_175063_a(I18n.func_135052_a((String)"clef.gui.syncTrack", (Object[])new Object[0]), (float)(this.guiLeft + 179), (float)(this.guiTop + 83), 0xFFFFFF);
        RenderSystem.pushMatrix();
        int length = this.font.func_78256_a(I18n.func_135052_a((String)"clef.gui.moreSongs", (Object[])new Object[0]));
        RenderSystem.translatef((float)(this.guiLeft - 4), (float)(this.guiTop + length + 3), (float)0.0f);
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        RenderSystem.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.font.func_175063_a(I18n.func_135052_a((String)"clef.gui.moreSongs", (Object[])new Object[0]), 0.0f, 0.0f, 0xFFFFFF);
        RenderSystem.popMatrix();
    }

    public void closeScreen() {
        this.minecraft.func_147108_a(null);
    }

    public void drawReloadButtons() {
        this.disableListWhenSyncTrack = true;
        if (!this.bandName.func_146179_b().isEmpty()) {
            this.disableListWhenSyncTrack = Clef.eventHandlerClient.findTrackByBand(this.bandName.func_146179_b()) != null;
        }
        this.font.func_175063_a(I18n.func_135052_a((String)"clef.gui.reload", (Object[])new Object[0]), (float)(this.guiLeft + 179), (float)(this.guiTop + 126), 0xFFFFFF);
        if (this.doneTimeout > 0) {
            this.font.func_175063_a(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), (float)(this.guiLeft + 179 + 2 + this.font.func_78256_a(I18n.func_135052_a((String)"clef.gui.reload", (Object[])new Object[0]))), (float)(this.guiTop + 126), 0xFFFFFF);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        this.minecraft.func_110434_K().func_110577_a(texInstrument);
        float x = this.guiLeft + 179 + 2;
        float y = this.guiTop + 137 + 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)(x + 0.0f), (double)(y + 16.0f), (double)this.getBlitOffset()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 16.0f), (double)(y + 16.0f), (double)this.getBlitOffset()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 16.0f), (double)(y + 0.0f), (double)this.getBlitOffset()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), (double)this.getBlitOffset()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        this.minecraft.func_110434_K().func_110577_a(texIcons);
        this.blit(this.guiLeft + 236, this.guiTop + 142, 0, 224, 10, 10);
        this.minecraft.func_110434_K().func_110577_a(texNote);
        x = this.guiLeft + 205 + 2;
        y = this.guiTop + 137 + 2;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_225582_a_((double)(x + 0.0f), (double)(y + 16.0f), (double)this.getBlitOffset()).func_227885_a_(0.5f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 16.0f), (double)(y + 16.0f), (double)this.getBlitOffset()).func_227885_a_(0.5f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 16.0f), (double)(y + 0.0f), (double)this.getBlitOffset()).func_227885_a_(0.5f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), (double)this.getBlitOffset()).func_227885_a_(0.5f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableAlphaTest();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int btn) {
        boolean superResult = super.mouseClicked(mouseX, mouseY, btn);
        if (btn == 1) {
            boolean flag;
            boolean bl = flag = mouseX >= (double)this.bandName.x && mouseX < (double)(this.bandName.x + this.width) && mouseY >= (double)this.bandName.y && mouseY < (double)(this.bandName.y + this.height);
            if (flag) {
                if (this.bandName.func_146179_b().isEmpty()) {
                    ArrayList<String> bands = new ArrayList<String>();
                    for (Track track : Clef.eventHandlerClient.tracksPlaying) {
                        if (track.getBandName().isEmpty() || bands.contains(track.getBandName())) continue;
                        bands.add(track.getBandName());
                    }
                    if (!bands.isEmpty()) {
                        if (this.bandIndex >= bands.size()) {
                            this.bandIndex = 0;
                        }
                        this.bandName.func_146180_a((String)bands.get(this.bandIndex));
                        this.syncPlay = 1;
                        this.syncTrack = 1;
                        this.buttonSyncPlay.active = false;
                        this.buttonSyncPlay.setMessage(I18n.func_135052_a((String)(this.syncPlay == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
                        this.buttonSyncTrack.active = true;
                        this.buttonSyncTrack.setMessage(I18n.func_135052_a((String)(this.syncTrack == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
                        ++this.bandIndex;
                    }
                } else {
                    this.bandName.func_146180_a("");
                    this.buttonSyncPlay.active = false;
                    this.buttonSyncPlay.setMessage(I18n.func_135052_a((String)(this.syncPlay == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
                    this.buttonSyncTrack.active = false;
                    this.buttonSyncTrack.setMessage(I18n.func_135052_a((String)(this.syncTrack == 1 ? "gui.yes" : "gui.no"), (Object[])new Object[0]));
                }
                this.bandName.func_146195_b(false);
                this.setFocused(null);
            }
        }
        return superResult;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void setIndex(int i) {
        this.scrollTicker = 0;
        this.index = i;
    }

    public boolean isSelectedIndex(int i) {
        return (this.bandName.func_146179_b().isEmpty() || !this.disableListWhenSyncTrack || this.syncTrack == 0) && this.index == i;
    }

    public void confirmSelection(boolean doubleClick) {
        if (this.syncTrack == 0 && (this.index < 0 || this.index >= this.tracks.size())) {
            return;
        }
        Clef.channel.sendToServer((AbstractPacket)new PacketPlayABC(this.index >= 0 && this.index < this.tracks.size() ? this.tracks.get((int)this.index).md5 : "", this.bandName.func_146179_b(), this.syncPlay == 1, this.syncTrack == 1));
        this.closeScreen();
        this.minecraft.field_71417_B.func_198034_i();
    }

    public FontRenderer getFontRenderer() {
        return this.font;
    }
}

