/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.ichun.mods.clef.client.gui.GuiPlayTrack;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class GuiTrackList
extends ExtendedList<TrackEntry> {
    private GuiPlayTrack parent;
    private List<TrackFile> tracks;

    public GuiTrackList(GuiPlayTrack parent, int width, int height, int top, int bottom, int left, int entryHeight, ArrayList<TrackFile> track) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, entryHeight);
        this.setLeftPos(left);
        this.parent = parent;
        this.setTracks(track);
    }

    public void setTracks(List<TrackFile> tracks) {
        this.tracks = tracks;
        this.children().clear();
        for (int i = 0; i < tracks.size(); ++i) {
            TrackFile trackFile = tracks.get(i);
            this.addEntry(new TrackEntry(trackFile, i));
        }
    }

    public void elementClicked(int index, boolean doubleClick) {
        this.parent.setIndex(index);
        if (doubleClick) {
            this.parent.confirmSelection(true);
        }
    }

    public boolean isSelectedItem(int index) {
        return this.parent.isSelectedIndex(index);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        RenderHelper.startGlScissor((int)this.getLeft(), (int)this.getTop(), (int)this.width, (int)(this.height - 1));
        int i = this.getScrollbarPosition();
        int j = i + 6;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = this.getRowLeft();
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(k, l, tessellator);
        }
        int oriWidth = this.width;
        this.width -= 6;
        this.renderList(k, l, mouseX, mouseY, partialTick);
        this.width = oriWidth;
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        int j1 = Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
        if (j1 > 0) {
            int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
            int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
            if (l1 < this.y0) {
                l1 = this.y0;
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderHelper.endGlScissor();
    }

    protected void renderHoleBackground(int p_renderHoleBackground_1_, int p_renderHoleBackground_2_, int p_renderHoleBackground_3_, int p_renderHoleBackground_4_) {
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getLeft() + this.width - 6;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int btn) {
        if (this.parent.bandName.func_146179_b().isEmpty() || this.parent.syncTrack == 0 || !this.parent.disableListWhenSyncTrack) {
            return super.mouseClicked(mouseX, mouseY, btn);
        }
        return false;
    }

    public class TrackEntry
    extends AbstractList.AbstractListEntry<TrackEntry> {
        public final TrackFile track;
        public final int index;
        public long lastClickTime = -1L;

        public TrackEntry(TrackFile track, int index) {
            this.track = track;
            this.index = index;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int btn) {
            if (this.isMouseOver(mouseX, mouseY) && btn == 0) {
                GuiTrackList.this.elementClicked(this.index, System.currentTimeMillis() - this.lastClickTime < 250L);
                this.lastClickTime = System.currentTimeMillis();
            }
            return false;
        }

        public void render(int idx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            if (idx >= 0 && idx < GuiTrackList.this.tracks.size()) {
                FontRenderer font = GuiTrackList.this.parent.getFontRenderer();
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
                String trim = font.func_78269_a(this.track.track.getTitle(), (GuiTrackList.this.width - 10) * 2);
                if (GuiTrackList.this.isSelectedItem(idx) && !this.track.track.getTitle().endsWith(trim)) {
                    int lengthDiff = (int)Math.ceil((double)(this.track.track.getTitle().length() - trim.length()) * 1.4);
                    String newString = this.track.track.getTitle().substring(lengthDiff);
                    int val = ((GuiTrackList)GuiTrackList.this).parent.scrollTicker % (lengthDiff * 2 + 40) / 2 - 10;
                    if (val < 0) {
                        val = 0;
                    }
                    String newTrim = font.func_78269_a(this.track.track.getTitle().substring(val), (GuiTrackList.this.width - 10) * 2);
                    trim = newString.length() > newTrim.length() ? newString : newTrim;
                }
                font.func_211126_b(trim, (float)((left + 2) * 2), (float)(top * 2), idx % 2 == 0 ? 0xFFFFFF : 0xAAAAAA);
                RenderSystem.popMatrix();
            }
        }
    }
}

