/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.client.model.item.ItemModelRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.PerspectiveMapWrapper;

public class BakedModelInstrument
implements IBakedModel {
    public static BakedModelInstrument currentModel = null;
    private final ImmutableList<BakedQuad> quads;
    private final TextureAtlasSprite particle;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms;
    private final Instrument instrument;
    public final ResourceLocation instTx;

    public BakedModelInstrument(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, Instrument instrument, ResourceLocation instTx) {
        this.quads = quads;
        this.particle = particle;
        this.transforms = transforms;
        this.instrument = instrument;
        this.instTx = instTx;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideListHandler.INSTANCE;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (side == null) {
            return this.quads;
        }
        return ImmutableList.of();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType type, MatrixStack mat) {
        if (this.instrument != null) {
            currentModel = ItemModelRenderer.isEntityRender((ItemCameraTransforms.TransformType)type) ? this.instrument.handModel : this.instrument.iconModel;
            PerspectiveMapWrapper.handlePerspective((IBakedModel)currentModel, this.instrument.transformationMap, (ItemCameraTransforms.TransformType)type, (MatrixStack)mat);
            return currentModel;
        }
        currentModel = this;
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type, (MatrixStack)mat);
    }

    private static final class ItemOverrideListHandler
    extends ItemOverrideList {
        private static final ItemOverrideListHandler INSTANCE = new ItemOverrideListHandler();

        private ItemOverrideListHandler() {
        }

        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null) {
                Instrument instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"));
                if (instrument != null) {
                    instrument.setupModels();
                    return instrument.iconModel;
                }
                InstrumentLibrary.requestInstrument(tag.func_74779_i("itemName"), null);
            }
            return originalModel;
        }
    }
}

