/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import me.ichun.mods.clef.client.gui.GuiPlayTrackBlock;
import me.ichun.mods.clef.client.render.BakedModelInstrument;
import me.ichun.mods.clef.common.block.BlockInstrumentPlayer;
import me.ichun.mods.clef.common.config.ConfigClient;
import me.ichun.mods.clef.common.config.ConfigCommon;
import me.ichun.mods.clef.common.config.ConfigServer;
import me.ichun.mods.clef.common.core.EventHandlerServer;
import me.ichun.mods.clef.common.inventory.ContainerInstrumentPlayer;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketCreateInstrument;
import me.ichun.mods.clef.common.packet.PacketFileFragment;
import me.ichun.mods.clef.common.packet.PacketInstrumentPlayerInfo;
import me.ichun.mods.clef.common.packet.PacketPlayABC;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.packet.PacketStopPlayingTrack;
import me.ichun.mods.clef.common.thread.ThreadReadFiles;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.ResourceHelper;
import me.ichun.mods.ichunutil.client.core.EventHandlerClient;
import me.ichun.mods.ichunutil.common.network.PacketChannel;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="clef")
public class Clef {
    public static final String MOD_NAME = "Clef";
    public static final String MOD_ID = "clef";
    public static final String PROTOCOL = "1";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ConfigCommon configCommon;
    public static ConfigClient configClient;
    public static ConfigServer configServer;
    public static EventHandlerServer eventHandlerServer;
    public static me.ichun.mods.clef.client.core.EventHandlerClient eventHandlerClient;
    public static PacketChannel channel;
    private static ThreadReadFiles threadReadFiles;

    public Clef() {
        if (!ResourceHelper.allGood()) {
            return;
        }
        configCommon = (ConfigCommon)new ConfigCommon().init();
        configServer = (ConfigServer)new ConfigServer().init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Blocks.REGISTRY.register(bus);
        Items.REGISTRY.register(bus);
        ContainerTypes.REGISTRY.register(bus);
        TileEntityTypes.REGISTRY.register(bus);
        bus.addListener(this::finishLoading);
        eventHandlerServer = new EventHandlerServer();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerServer);
        channel = new PacketChannel(new ResourceLocation(MOD_ID, "channel"), PROTOCOL, new Class[]{PacketRequestFile.class, PacketFileFragment.class, PacketPlayABC.class, PacketPlayingTracks.class, PacketStopPlayingTrack.class, PacketInstrumentPlayerInfo.class, PacketCreateInstrument.class});
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            configClient = (ConfigClient)new ConfigClient().init();
            bus.addListener(this::onClientSetup);
            bus.addListener(this::onModelBake);
            eventHandlerClient = new me.ichun.mods.clef.client.core.EventHandlerClient();
            MinecraftForge.EVENT_BUS.register((Object)eventHandlerClient);
        });
        threadReadFiles = new ThreadReadFiles();
        threadReadFiles.start();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ContainerTypes.INSTRUMENT_PLAYER.get()), (container, playerInventory, name) -> new GuiPlayTrackBlock((ContainerInstrumentPlayer)container));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> EventHandlerClient::getConfigGui);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onModelBake(ModelBakeEvent event) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TextureAtlasSprite tas = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation(MOD_ID, "items/instrument"));
        builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)tas, (TransformationMatrix)TransformationMatrix.func_227983_a_()));
        event.getModelRegistry().put(new ModelResourceLocation("clef:instrument", "inventory"), new BakedModelInstrument((ImmutableList<BakedQuad>)builder.build(), tas, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)ImmutableMap.copyOf(new HashMap()), null, null));
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        if (Clef.threadReadFiles.latch.getCount() > 0L) {
            LOGGER.info("Waiting for file reader thread to finish");
            try {
                Clef.threadReadFiles.latch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Got interrupted while waiting for FileReaderThread to finish");
                e.printStackTrace();
            }
        }
        threadReadFiles = null;
    }

    public static class TileEntityTypes {
        private static final DeferredRegister<TileEntityType<?>> REGISTRY = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, "clef");
        public static final RegistryObject<TileEntityType<TileEntityInstrumentPlayer>> INSTRUMENT_PLAYER = REGISTRY.register("instrument_player", () -> TileEntityType.Builder.func_223042_a(TileEntityInstrumentPlayer::new, (Block[])new Block[]{(Block)Blocks.INSTRUMENT_PLAYER.get()}).func_206865_a(null));
    }

    public static class ContainerTypes {
        private static final DeferredRegister<ContainerType<?>> REGISTRY = new DeferredRegister(ForgeRegistries.CONTAINERS, "clef");
        public static final RegistryObject<ContainerType<ContainerInstrumentPlayer>> INSTRUMENT_PLAYER = REGISTRY.register("instrument_player", () -> IForgeContainerType.create(ContainerInstrumentPlayer::new));
    }

    public static class Items {
        private static final DeferredRegister<Item> REGISTRY = new DeferredRegister(ForgeRegistries.ITEMS, "clef");
        public static final ItemGroup GROUP_INSTRUMENTS = new ItemGroup("clef"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)INSTRUMENT.get());
            }
        };
        public static final RegistryObject<ItemInstrument> INSTRUMENT = REGISTRY.register("instrument", () -> new ItemInstrument(new Item.Properties().func_200918_c(0).func_200916_a(GROUP_INSTRUMENTS)));
        public static final RegistryObject<BlockItem> INSTRUMENT_PLAYER = REGISTRY.register("instrument_player", () -> new BlockItem((Block)Blocks.INSTRUMENT_PLAYER.get(), new Item.Properties().func_200916_a(GROUP_INSTRUMENTS)));
    }

    public static class Blocks {
        private static final DeferredRegister<Block> REGISTRY = new DeferredRegister(ForgeRegistries.BLOCKS, "clef");
        public static final RegistryObject<BlockInstrumentPlayer> INSTRUMENT_PLAYER = REGISTRY.register("instrument_player", BlockInstrumentPlayer::new);
    }
}

