/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.core;

import java.util.HashSet;
import java.util.Iterator;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.RandomStringUtils;

public class EventHandlerServer {
    public HashSet<Track> tracksPlaying = new HashSet();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && iChunUtil.eventHandlerServer.ticks + 5 == 2) {
            ItemStack isMain = event.player.func_184614_ca();
            ItemStack isOff = event.player.func_184592_cb();
            if (isMain.func_77973_b() == Clef.Items.INSTRUMENT.get()) {
                InstrumentLibrary.checkForInstrument(isMain, (ServerPlayerEntity)event.player);
            }
            if (isOff.func_77973_b() == Clef.Items.INSTRUMENT.get()) {
                InstrumentLibrary.checkForInstrument(isOff, (ServerPlayerEntity)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onItemDrop(LivingDropsEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof ServerPlayerEntity) {
            for (ItemEntity item : event.getDrops()) {
                String instName;
                Instrument is;
                CompoundNBT tag;
                if (item.func_92059_d().func_77973_b() != Clef.Items.INSTRUMENT.get() || (tag = item.func_92059_d().func_77978_p()) == null || (is = InstrumentLibrary.getInstrumentByName(instName = tag.func_74779_i("itemName"))) != null) continue;
                InstrumentLibrary.requestInstrument(instName, (ServerPlayerEntity)event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDropsEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && (!Clef.configCommon.onlyHostileMobSpawn || event.getEntityLiving() instanceof IMob) && event.getEntityLiving().func_70681_au().nextFloat() < (float)Clef.configCommon.mobDropRate / 10000.0f * (float)(event.getLootingLevel() + 1)) {
            ItemStack stack = new ItemStack((IItemProvider)Clef.Items.INSTRUMENT.get());
            InstrumentLibrary.assignRandomInstrument(stack);
            event.getDrops().add(event.getEntityLiving().func_70099_a(stack, 0.0f));
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        ZombieEntity zombie;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof ZombieEntity && event.getEntityLiving().func_70681_au().nextFloat() < (float)Clef.configCommon.zombieSpawnRate / 10000.0f && (zombie = (ZombieEntity)event.getEntityLiving()).func_184614_ca().func_190926_b()) {
            ItemStack stack = new ItemStack((IItemProvider)Clef.Items.INSTRUMENT.get());
            InstrumentLibrary.assignRandomInstrument(stack);
            zombie.func_184611_a(Hand.MAIN_HAND, stack);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ZombieEntity zombie;
        if (Clef.configCommon.zombiesCanUseInstruments && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof ZombieEntity && (zombie = (ZombieEntity)event.getEntityLiving()).func_70681_au().nextFloat() < 0.004f && !ItemInstrument.getUsableInstrument((LivingEntity)zombie).func_190926_b() && this.getTrackPlayedByPlayer(zombie) == null) {
            Track track = Clef.eventHandlerServer.findTrackByBand("zombies");
            if (track != null) {
                if (track.zombies.add(zombie.func_145782_y())) {
                    Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
                }
            } else {
                TrackFile randTrack = AbcLibrary.tracks.get(zombie.func_70681_au().nextInt(AbcLibrary.tracks.size()));
                track = new Track(RandomStringUtils.randomAscii((int)20), "zombies", randTrack.md5, randTrack.track, false);
                if (track.getTrack().trackLength > 0) {
                    track.playAtProgress(zombie.func_70681_au().nextInt(track.getTrack().trackLength));
                }
                Clef.eventHandlerServer.tracksPlaying.add(track);
                track.zombies.add(zombie.func_145782_y());
                Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
            }
        }
    }

    @SubscribeEvent
    public void onLootTableEvent(LootTableLoadEvent event) {
        if (Clef.configCommon.lootSpawnRate > 0) {
            for (String s : Clef.configCommon.disabledLootChests) {
                if (!event.getName().toString().equals(s)) continue;
                return;
            }
            if (event.getName().func_110623_a().contains("chest")) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Clef.Items.INSTRUMENT.get())).func_216086_a(Clef.configCommon.lootSpawnRate).func_212841_b_(() -> new LootFunction(new ILootCondition[0]){

                    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
                        InstrumentLibrary.assignRandomInstrument(stack);
                        return stack;
                    }
                })).name("clef_instrument").func_216044_b());
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Track> ite = this.tracksPlaying.iterator();
            while (ite.hasNext()) {
                Track track = ite.next();
                if (track.tick()) continue;
                ite.remove();
            }
        }
    }

    public void stopPlayingTrack(ServerPlayerEntity player, String trackId) {
        for (Track track : this.tracksPlaying) {
            if (!track.getId().equals(trackId)) continue;
            track.players.remove(player);
            if (!track.hasObjectsPlaying()) {
                track.stop();
            }
            Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(track), PacketDistributor.ALL.noArg());
            break;
        }
    }

    public Track getTrackPlayedByPlayer(ZombieEntity zombie) {
        for (Track track : this.tracksPlaying) {
            if (!track.zombies.contains(zombie.func_145782_y())) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(TileEntityInstrumentPlayer player) {
        for (Track track : this.tracksPlaying) {
            if (!track.instrumentPlayers.containsKey(player.func_145831_w().func_201675_m().func_186058_p().getRegistryName()) || !track.instrumentPlayers.get(player.func_145831_w().func_201675_m().func_186058_p().getRegistryName()).contains(player.func_174877_v())) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(PlayerEntity player) {
        for (Track track : this.tracksPlaying) {
            if (!track.players.containsKey(player)) continue;
            return track;
        }
        return null;
    }

    public Track findTrackByBand(String bandName) {
        for (Track track : this.tracksPlaying) {
            if (!track.getBandName().equalsIgnoreCase(bandName)) continue;
            return track;
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        HashSet<Track> tracks = new HashSet<Track>();
        for (Track track : this.tracksPlaying) {
            if (track.getTrack() == null) continue;
            tracks.add(track);
        }
        AbcLibrary.startPlayingTrack((ServerPlayerEntity)event.getPlayer(), tracks.toArray(new Track[tracks.size()]));
    }

    @SubscribeEvent
    public void onServerStoppingEvent(FMLServerStoppingEvent event) {
        this.shutdownServer();
    }

    public void shutdownServer() {
        this.tracksPlaying.clear();
        AbcLibrary.tracksWaitingForTrackInfo.clear();
        AbcLibrary.requestedABCFromPlayers.clear();
        InstrumentLibrary.requestsFromPlayers.clear();
        InstrumentLibrary.requestedInstrumentsFromPlayers.clear();
    }
}

