/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.clef.client.gui.GuiPlayTrack;
import me.ichun.mods.clef.client.render.BakedModelInstrument;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.item.DualHandedItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ItemInstrument
extends Item
implements DualHandedItem {
    public ItemInstrument(Item.Properties properties) {
        super((Item.Properties)DistExecutor.runForDist(() -> () -> ItemInstrument.attachISTER(properties), () -> () -> properties));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Item.Properties attachISTER(Item.Properties properties) {
        return properties.setISTER(() -> () -> new ItemStackTileEntityRenderer(){

            public void func_228364_a_(ItemStack itemStackIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
                if (BakedModelInstrument.currentModel != null) {
                    IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)(BakedModelInstrument.currentModel.instTx != null ? BakedModelInstrument.currentModel.instTx : AtlasTexture.field_110575_b)));
                    RenderHelper.renderModel((IBakedModel)BakedModelInstrument.currentModel, (ItemStack)itemStackIn, (int)combinedLightIn, (int)combinedOverlayIn, (MatrixStack)matrixStackIn, (IVertexBuilder)ivertexbuilder);
                }
            }
        });
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack is = player.func_184586_b(hand);
        if (is.func_77978_p() == null && !world.field_72995_K) {
            InstrumentLibrary.assignRandomInstrument(is);
        }
        if (ItemInstrument.getUsableInstrument((LivingEntity)player) == is) {
            if (player.field_70170_p.field_72995_K) {
                Track track = Clef.eventHandlerClient.getTrackPlayedByPlayer(player);
                if (track == null) {
                    this.openGui();
                } else {
                    Clef.eventHandlerClient.stopPlayingTrack(player);
                }
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)is);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)is);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (player.field_70170_p.field_72995_K) {
            Clef.eventHandlerClient.stopPlayingTrack(player);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openGui() {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiPlayTrack());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Instrument intrument : InstrumentLibrary.instruments) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                CompoundNBT stackTag = new CompoundNBT();
                stackTag.func_74778_a("itemName", intrument.info.itemName);
                stack.func_77982_d(stackTag);
                items.add((Object)stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack is, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flag) {
        Instrument instrument;
        CompoundNBT tag = is.func_77978_p();
        if (tag != null && (instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"))) != null) {
            list.add((ITextComponent)new StringTextComponent(instrument.info.description));
            if (!Clef.configServer.allowOneHandedTwoHandedInstrumentUse) {
                list.add((ITextComponent)new TranslationTextComponent(instrument.info.twoHanded ? "clef.item.twoHanded" : "clef.item.oneHanded", new Object[0]));
            }
            if (Screen.hasShiftDown() || flag.func_194127_a()) {
                list.add((ITextComponent)new StringTextComponent(""));
                list.add((ITextComponent)new TranslationTextComponent("clef.item.packName", new Object[]{instrument.packInfo.packName}));
                list.add((ITextComponent)new TranslationTextComponent("clef.item.itemName", new Object[]{instrument.info.itemName}));
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Instrument instrument;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"))) != null) {
            return new StringTextComponent(instrument.info.shortdescription);
        }
        return super.func_200295_i(stack);
    }

    public String func_77667_c(ItemStack is) {
        Instrument instrument;
        CompoundNBT tag = is.func_77978_p();
        if (tag != null && (instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"))) != null) {
            return instrument.info.shortdescription;
        }
        return super.func_77667_c(is);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack is) {
        Instrument instrument;
        CompoundNBT tag = is.func_77978_p();
        if (tag != null && (instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"))) != null) {
            return Math.round(instrument.tuning.fadeout * 20.0f);
        }
        return 0;
    }

    public boolean isHeldLikeBow(@Nonnull ItemStack is, @Nonnull LivingEntity living) {
        PlayerEntity player;
        Track track;
        ItemStack is1 = ItemInstrument.getUsableInstrument(living);
        if (is1.func_190926_b()) {
            return false;
        }
        if (living instanceof PlayerEntity && (track = Clef.eventHandlerClient.getTrackPlayedByPlayer(player = (PlayerEntity)living)) != null) {
            return track.timeToSilence > 0;
        }
        return false;
    }

    @Nonnull
    public static ItemStack getUsableInstrument(LivingEntity entity) {
        Instrument instrument;
        CompoundNBT tag;
        ItemStack is = entity.func_184614_ca();
        if (is.func_77973_b() == Clef.Items.INSTRUMENT.get() && (tag = is.func_77978_p()) != null && (instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"))) != null && (!instrument.info.twoHanded || Clef.configServer.allowOneHandedTwoHandedInstrumentUse || entity.func_184592_cb().func_190926_b())) {
            return is;
        }
        is = entity.func_184592_cb();
        if (is.func_77973_b() == Clef.Items.INSTRUMENT.get() && (tag = is.func_77978_p()) != null && (instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"))) != null && (!instrument.info.twoHanded || Clef.configServer.allowOneHandedTwoHandedInstrumentUse || entity.func_184614_ca().func_190926_b())) {
            return is;
        }
        return ItemStack.field_190927_a;
    }
}

