/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Map;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlayingTracks
extends AbstractPacket {
    public Track[] tracks;

    public PacketPlayingTracks() {
    }

    public PacketPlayingTracks(Track ... tracks) {
        this.tracks = tracks;
    }

    public void writeTo(PacketBuffer buf) {
        PacketBuffer buff = new PacketBuffer((ByteBuf)buf);
        buf.writeInt(this.tracks.length);
        for (Track track : this.tracks) {
            buf.func_180714_a(track.getId());
            buf.func_180714_a(track.getBandName());
            buf.func_180714_a(track.getMd5());
            buf.writeBoolean(track.playing);
            buf.writeInt(track.playProg);
            buf.writeInt(track.players.size());
            for (PlayerEntity playerEntity : track.players.keySet()) {
                buf.func_180714_a(playerEntity.func_200200_C_().func_150261_e());
            }
            buf.writeInt(track.instrumentPlayers.size());
            for (Map.Entry entry : track.instrumentPlayers.entrySet()) {
                buf.func_192572_a((ResourceLocation)entry.getKey());
                buf.writeInt(((HashSet)entry.getValue()).size());
                for (BlockPos pos : (HashSet)entry.getValue()) {
                    buff.func_179255_a(pos);
                }
            }
            buf.writeInt(track.zombies.size());
            for (Integer n : track.zombies) {
                buf.writeInt(n.intValue());
            }
        }
    }

    public void readFrom(PacketBuffer buf) {
        PacketBuffer buff = new PacketBuffer((ByteBuf)buf);
        this.tracks = new Track[buf.readInt()];
        for (int i = 0; i < this.tracks.length; ++i) {
            int x;
            String md5;
            String id = this.readString(buf);
            String band = this.readString(buf);
            TrackFile file = AbcLibrary.getTrack(md5 = this.readString(buf));
            this.tracks[i] = new Track(id, band, md5, file != null ? file.track : null, true);
            this.tracks[i].playing = buf.readBoolean();
            this.tracks[i].playProg = buf.readInt();
            int playerCount = buf.readInt();
            for (x = 0; x < playerCount; ++x) {
                this.tracks[i].addPlayer(this.readString(buf));
            }
            playerCount = buf.readInt();
            for (x = 0; x < playerCount; ++x) {
                ResourceLocation key = buf.func_192575_l();
                int count = buf.readInt();
                HashSet<BlockPos> poses = new HashSet<BlockPos>();
                for (int k = 0; k < count; ++k) {
                    poses.add(buff.func_179259_c());
                }
                this.tracks[i].instrumentPlayers.put(key, poses);
            }
            playerCount = buf.readInt();
            for (x = 0; x < playerCount; ++x) {
                this.tracks[i].zombies.add(buf.readInt());
            }
        }
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            for (int i = 0; i < this.tracks.length; ++i) {
                Clef.eventHandlerClient.addTrack(this.tracks[i]);
            }
        });
    }
}

