/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play;

import java.util.HashSet;
import java.util.Set;
import me.ichun.mods.clef.common.util.abc.play.NotePlayThread;
import me.ichun.mods.clef.common.util.abc.play.NotesTickInfo;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.abc.play.components.Note;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrackTracker {
    private final Track track;
    private final Set<NotesTickInfo> masterSet = new HashSet<NotesTickInfo>();
    private int playProg;
    private boolean shutdown = false;

    public TrackTracker(Track track) {
        this.track = track;
    }

    public void startNewTick(int playProg) {
        this.shutdown = false;
        this.masterSet.clear();
        this.playProg = playProg;
        NotePlayThread.INSTANCE.ensurePresent(this);
    }

    public void addTickInfo(NotesTickInfo noteInfo) {
        if (noteInfo.notes.length != 5) {
            throw new IllegalArgumentException("Invalid sized array!" + noteInfo.notes.length);
        }
        this.masterSet.add(noteInfo);
    }

    public void runSubTick(int runTick) {
        for (NotesTickInfo noteInfo : this.masterSet) {
            Set<Note> forCurrentSubTick = noteInfo.notes[runTick];
            if (forCurrentSubTick == null) continue;
            for (Note toPlay : forCurrentSubTick) {
                int time = toPlay.playNote(this.track, this.playProg, noteInfo.instrument, noteInfo.notePos);
                if (!noteInfo.checkRest || time <= this.track.timeToSilence || toPlay.key == -1) continue;
                this.track.timeToSilence = time;
            }
        }
    }

    public boolean didNotStart() {
        return this.shutdown;
    }

    public void reset() {
        this.shutdown = true;
    }
}

