/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play.components;

import java.util.ArrayList;
import java.util.HashMap;
import me.ichun.mods.clef.common.util.abc.construct.Construct;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.abc.play.components.Note;
import me.ichun.mods.clef.common.util.abc.play.components.SingleNote;
import me.ichun.mods.clef.common.util.instrument.Instrument;

public class Chord
extends Note {
    public ArrayList<Note> notes = new ArrayList();

    @Override
    public int playNote(Track track, int currentProg, Instrument instrument, Object noteLocation) {
        int longest = 0;
        for (Note note : this.notes) {
            int dur = note.playNote(track, currentProg, instrument, noteLocation);
            if (dur <= longest) continue;
            longest = dur;
        }
        return longest;
    }

    @Override
    public boolean setup(double[] info, HashMap<Integer, Integer> keyAccidentals, HashMap<Integer, Integer> keySignature) {
        for (Note note : this.notes) {
            note.duration *= this.duration;
            note.setup(info, keyAccidentals, keySignature);
            if (note.key == -1) continue;
            this.key = note.key;
        }
        double tempDur = 1000.0;
        for (Note note : this.notes) {
            if (!(note instanceof SingleNote)) continue;
            SingleNote note1 = (SingleNote)note;
            for (Construct construct : note1.constructs) {
                if (construct.getType() != Construct.EnumConstructType.NOTE || !(note1.duration < tempDur)) continue;
                tempDur = note1.duration;
            }
        }
        float scaledDuration = (float)(info[0] * (info[1] / info[4]) * tempDur);
        this.durationInTicks = (int)scaledDuration;
        this.durationInPartialTicks = scaledDuration - (float)((int)scaledDuration);
        return true;
    }
}

