/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.block;

import coloredlights.ColoredLights;
import coloredlights.platform.Platform;
import coloredlights.registry.ModBlocks;
import coloredlights.registry.ModSprites;
import elucent.albedo.Albedo;
import elucent.albedo.lighting.Light;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemColored;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rzk.mc.lib.item.IItemProvider;
import rzk.mc.lib.platform.client.model.EnumSide;
import rzk.mc.lib.platform.client.model.util.block.ITexturedBlock;
import rzk.mc.lib.platform.client.textures.Icon;
import rzk.mc.lib.util.BlockProps;

public class BlockColoredLamp
extends BlockColored
implements IItemProvider,
ITexturedBlock {
    private final boolean powered;
    private final boolean inverted;

    public BlockColoredLamp(boolean powered, boolean inverted) {
        super(Material.field_151591_t);
        this.func_149711_c(0.3f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProps.POWERED, (Comparable)Boolean.valueOf(powered)));
        this.powered = powered;
        this.inverted = inverted;
        if (Loader.isModLoaded((String)"albedo") && Platform.isClient()) {
            Albedo.registerBlockHandler((Block)this, (pos, state, event) -> {
                if (this.isLit((IBlockState)state)) {
                    event.add(Light.builder().pos(pos).color(ColoredLights.DYE_HEX[((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a()], false).radius(15.0f).build());
                }
            });
        }
    }

    protected Block getOther(boolean powered) {
        if (powered && !this.inverted) {
            return ModBlocks.COLORED_LAMP_POWERED;
        }
        if (!powered && this.inverted) {
            return ModBlocks.COLORED_LAMP_INVERTED;
        }
        if (powered) {
            return ModBlocks.COLORED_LAMP_INVERTED_POWERED;
        }
        return ModBlocks.COLORED_LAMP;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && world.func_175640_z(pos) && !((Boolean)state.func_177229_b((IProperty)BlockProps.POWERED)).booleanValue()) {
            world.func_175656_a(pos, this.getOther(true).func_176223_P().func_177226_a((IProperty)field_176581_a, state.func_177229_b((IProperty)field_176581_a)));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K && world.func_175640_z(pos) && !((Boolean)state.func_177229_b((IProperty)BlockProps.POWERED)).booleanValue()) {
            world.func_175656_a(pos, this.getOther(true).func_176223_P().func_177226_a((IProperty)field_176581_a, state.func_177229_b((IProperty)field_176581_a)));
        } else if (!world.field_72995_K && !world.func_175640_z(pos) && ((Boolean)state.func_177229_b((IProperty)BlockProps.POWERED)).booleanValue()) {
            world.func_175656_a(pos, this.getOther(false).func_176223_P().func_177226_a((IProperty)field_176581_a, state.func_177229_b((IProperty)field_176581_a)));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.inverted) {
            return Item.func_150898_a((Block)ModBlocks.COLORED_LAMP_INVERTED);
        }
        return Item.func_150898_a((Block)ModBlocks.COLORED_LAMP);
    }

    public boolean isLit(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockProps.POWERED) != false && !this.inverted || (Boolean)state.func_177229_b((IProperty)BlockProps.POWERED) == false && this.inverted;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.isLit(state) && (!Loader.isModLoaded((String)"albedo") || Platform.isServer())) {
            return 15;
        }
        return super.getLightValue(state, world, pos);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isLit(state) && world.field_72995_K && world.func_175699_k(pos) == 15) {
            world.func_180500_c(EnumSkyBlock.BLOCK, pos);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176581_a, BlockProps.POWERED});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getTextureForState(IBlockState state, EnumSide side) {
        return ModSprites.COLORED_LAMP.getIcon(((EnumDyeColor)state.func_177229_b((IProperty)field_176581_a)).func_176765_a(), this.isLit(state) ? 1 : 0);
    }

    @Override
    public ItemBlock createItem() {
        if (!this.powered) {
            return new ItemColored((Block)this, true).func_150943_a(ColoredLights.DYE_NAMES);
        }
        return NO_ITEM;
    }
}

