/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.block;

import coloredlights.ColoredLights;
import coloredlights.platform.Platform;
import coloredlights.platform.client.particle.ParticleGlimmer;
import coloredlights.registry.ModBlocks;
import coloredlights.registry.ModItems;
import coloredlights.registry.ModSprites;
import coloredlights.tileentity.TilePneumeaCrop;
import elucent.albedo.Albedo;
import elucent.albedo.lighting.Light;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rzk.mc.lib.block.BlockCrop;
import rzk.mc.lib.item.IItemProvider;
import rzk.mc.lib.platform.client.model.ModelBase;
import rzk.mc.lib.platform.client.model.block.ModelBlockCross;
import rzk.mc.lib.platform.client.model.util.block.ICustomBlockModel;
import rzk.mc.lib.util.BlockProps;

public class BlockCropPneumea
extends BlockCrop
implements ITileEntityProvider,
IItemProvider,
ICustomBlockModel {
    private final boolean isShimmering;
    public static final AxisAlignedBB[] CROP_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 0.3, 0.6), new AxisAlignedBB(0.35, 0.0, 0.35, 0.65, 0.3, 0.65), new AxisAlignedBB(0.35, 0.0, 0.35, 0.65, 0.4, 0.65), new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.4, 0.7), new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.45, 0.7), new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.5, 0.7), new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7), new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.7, 0.7)};

    public BlockCropPneumea(boolean isShimmering) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BlockProps.COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)BlockProps.AGE, (Comparable)Integer.valueOf(0)));
        this.setDropAdditionalSeeds(false);
        this.isShimmering = isShimmering;
        if (isShimmering && Loader.isModLoaded((String)"albedo") && Platform.isClient()) {
            Albedo.registerBlockHandler((Block)this, (pos, state, event) -> event.add(Light.builder().pos(pos).color(ColoredLights.DYE_HEX[((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)).func_176765_a()], false).radius((float)((Integer)state.func_177229_b((IProperty)BlockProps.AGE)).intValue()).build()));
        }
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TilePneumeaCrop();
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CROP_AABB[(Integer)state.func_177229_b((IProperty)BlockProps.AGE)];
    }

    @Override
    public Block[] getSoilBlocks() {
        return new Block[]{Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150346_d};
    }

    @Override
    public void setAge(World world, BlockPos pos, IBlockState state, int age) {
        super.setAge(world, pos, state, age);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePneumeaCrop) {
            ((TilePneumeaCrop)tile).setAge(age);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePneumeaCrop) {
            return state.func_177226_a((IProperty)BlockProps.AGE, (Comparable)Integer.valueOf(((TilePneumeaCrop)tile).getAge()));
        }
        return state;
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(this.isShimmering ? ModItems.PNEUMEA_SEED_SHIMMERING : ModItems.PNEUMEA_SEED, 1, ((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)).func_176765_a());
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(this.isShimmering ? ModBlocks.PNEUMEA_FLOWER_SHIMMERING : ModBlocks.PNEUMEA_FLOWER, 1, ((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)).func_176765_a());
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)).func_176765_a();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.isShimmering) {
            if (!Loader.isModLoaded((String)"albedo") || Platform.isServer()) {
                return (Integer)state.func_177229_b((IProperty)BlockProps.AGE);
            }
            return 0;
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isShimmering) {
            if (world.field_72995_K && world.func_175699_k(pos) == ((Integer)state.func_177229_b((IProperty)BlockProps.AGE)).intValue()) {
                world.func_180500_c(EnumSkyBlock.BLOCK, pos);
            }
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            Color color = Color.getColor(null, ColoredLights.DYE_HEX[((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)).func_176765_a()]);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleGlimmer(world, d0, d1, d2, 1.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)).func_176765_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProps.COLOR, BlockProps.AGE});
    }

    @Override
    public ItemBlock createItem() {
        return NO_ITEM;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase getModelForState(IBlockState state) {
        return new ModelBlockCross((this.isShimmering ? ModSprites.PNEUMEA_CROP_SHIMMERING : ModSprites.PNEUMEA_CROP).getIcon(((EnumDyeColor)state.func_177229_b(BlockProps.COLOR)).func_176765_a(), (Integer)state.func_177229_b((IProperty)BlockProps.AGE)));
    }
}

