/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.block;

import coloredlights.ColoredLights;
import coloredlights.platform.Platform;
import coloredlights.platform.client.particle.ParticleGlimmer;
import coloredlights.registry.ModSprites;
import elucent.albedo.Albedo;
import elucent.albedo.lighting.Light;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rzk.mc.lib.block.BlockPlant;
import rzk.mc.lib.item.IItemProvider;
import rzk.mc.lib.platform.client.model.ModelBase;
import rzk.mc.lib.platform.client.model.block.ModelBlockCross;
import rzk.mc.lib.platform.client.model.util.block.ICustomBlockModel;
import rzk.mc.lib.platform.client.model.util.item.ITexturedItem;
import rzk.mc.lib.platform.client.textures.Icon;

public class BlockPneumeaFlower
extends BlockPlant
implements IItemProvider,
ICustomBlockModel {
    private final boolean isShimmering;
    protected static final AxisAlignedBB PNEUMEA_AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.7, 0.7);

    public BlockPneumeaFlower(boolean isShimmering) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        this.isShimmering = isShimmering;
        if (isShimmering && Loader.isModLoaded((String)"albedo") && Platform.isClient()) {
            Albedo.registerBlockHandler((Block)this, (pos, state, event) -> event.add(Light.builder().pos(pos).color(ColoredLights.DYE_HEX[((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a()], false).radius(7.0f).build()));
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PNEUMEA_AABB;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.isShimmering) {
            tooltip.add(TextFormatting.AQUA + "Congrats, you found a rare Shimmering Pneumea");
            tooltip.add(TextFormatting.AQUA + "These flowers are kept secret, try them out in the dark or at night");
        }
    }

    @Override
    public Block[] getSoilBlocks() {
        return new Block[]{Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150346_d};
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.isShimmering) {
            if (!Loader.isModLoaded((String)"albedo") || Platform.isServer()) {
                return 7;
            }
            return 0;
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isShimmering) {
            if (world.field_72995_K && world.func_175699_k(pos) == 7) {
                world.func_180500_c(EnumSkyBlock.BLOCK, pos);
            }
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            Color color = Color.getColor(null, ColoredLights.DYE_HEX[((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a()]);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleGlimmer(world, d0, d1, d2, 1.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.isShimmering) {
            for (EnumDyeColor color : EnumDyeColor.values()) {
                items.add((Object)new ItemStack((Block)this, 1, color.func_176765_a()));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockColored.field_176581_a});
    }

    @Override
    public ItemBlock createItem() {
        return new ItemBlockTextured(this, true).func_150943_a(ColoredLights.DYE_NAMES);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase getModelForState(IBlockState state) {
        return new ModelBlockCross((this.isShimmering ? ModSprites.PNEUMEA_CROP_SHIMMERING : ModSprites.PNEUMEA_CROP).getIcon(((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a(), 7));
    }

    public class ItemBlockTextured
    extends ItemColored
    implements ITexturedItem {
        public ItemBlockTextured(Block block, boolean hasSubtypes) {
            super(block, hasSubtypes);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Icon getTextureForStack(ItemStack stack) {
            return (BlockPneumeaFlower.this.isShimmering ? ModSprites.PNEUMEA_CROP_SHIMMERING : ModSprites.PNEUMEA_CROP).getIcon(stack.func_77960_j(), 7);
        }

        @Override
        public List<ItemStack> getValidStacks() {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int meta = 0; meta < 16; ++meta) {
                stacks.add(new ItemStack((Item)this, 1, meta));
            }
            return stacks;
        }
    }
}

