/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.container;

import coloredlights.tileentity.TileGrinder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerGrinder
extends Container {
    private final IInventory playerInventory;
    private final TileGrinder grinder;
    private int[] cachedFields;
    private int invSize;

    public ContainerGrinder(IInventory playerInventory, TileGrinder grinder) {
        this.playerInventory = playerInventory;
        this.grinder = grinder;
        IItemHandler inventory = (IItemHandler)grinder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.invSize = inventory.getSlots();
        this.func_75146_a((Slot)new SlotItemHandler(inventory, 0, 6, 54));
        this.func_75146_a((Slot)new SlotItemHandler(inventory, 1, 36, 34));
        this.func_75146_a((Slot)new SlotItemHandler(inventory, 2, 112, 34));
        this.func_75146_a((Slot)new SlotItemHandler(inventory, 3, 142, 34));
        this.addPlayerInventory(8, 84);
    }

    public void addPlayerInventory(int xPos, int yPos) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot(this.playerInventory, column + row * 9 + 9, xPos + column * 18, yPos + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot(this.playerInventory, column, xPos + column * 18, yPos + 58));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        for (int i = 0; i < this.grinder.getFieldCount(); ++i) {
            listener.func_71112_a((Container)this, i, this.cachedFields[i]);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        boolean allFieldsHaveChanged = false;
        boolean[] fieldHasChanged = new boolean[2];
        if (this.cachedFields == null) {
            this.cachedFields = new int[this.grinder.getFieldCount()];
            allFieldsHaveChanged = true;
        }
        for (int i = 0; i < this.cachedFields.length; ++i) {
            if (!allFieldsHaveChanged && this.cachedFields[i] == this.grinder.getField(i)) continue;
            this.cachedFields[i] = this.grinder.getField(i);
            fieldHasChanged[i] = true;
        }
        for (IContainerListener listener : this.field_75149_d) {
            for (int fieldID = 0; fieldID < this.grinder.getFieldCount(); ++fieldID) {
                if (!fieldHasChanged[fieldID]) continue;
                listener.func_71112_a((Container)this, fieldID, this.cachedFields[fieldID]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.grinder.setField(id, data);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int sourceSlotIndex) {
        ItemStack sourceStackCopy = ItemStack.field_190927_a;
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.func_75216_d()) {
            ItemStack sourceStack = sourceSlot.func_75211_c();
            sourceStackCopy = sourceStack.func_77946_l();
            if (sourceSlotIndex < this.invSize) {
                if (!this.func_75135_a(sourceStack, this.invSize, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
                sourceSlot.func_75220_a(sourceStack, sourceStackCopy);
            } else if (sourceSlotIndex != 1 && sourceSlotIndex != 0 && (((Slot)this.field_75151_b.get(0)).func_75214_a(sourceStack) ? !this.func_75135_a(sourceStack, 0, 1, false) : (((Slot)this.field_75151_b.get(1)).func_75214_a(sourceStack) ? !this.func_75135_a(sourceStack, 1, 2, false) : (sourceSlotIndex < this.invSize + 27 ? !this.func_75135_a(sourceStack, this.invSize + 27, this.field_75151_b.size(), false) : sourceSlotIndex < this.field_75151_b.size() && !this.func_75135_a(sourceStack, this.invSize, this.invSize + 27, false))))) {
                return ItemStack.field_190927_a;
            }
            if (sourceStack.func_190926_b()) {
                sourceSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                sourceSlot.func_75218_e();
            }
            if (sourceStack.func_190916_E() == sourceStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            return sourceSlot.func_190901_a(playerIn, sourceStack);
        }
        return sourceStackCopy;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.grinder.canInteractWith(player);
    }
}

