/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.item;

import coloredlights.ColoredLights;
import coloredlights.registry.ModItems;
import coloredlights.registry.ModSprites;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.apache.commons.lang3.text.WordUtils;
import rzk.mc.lib.platform.client.model.util.item.ITexturedItem;
import rzk.mc.lib.platform.client.textures.Icon;

public class ItemColorCard
extends Item
implements ITexturedItem {
    public static final List<String> nameColor = new ArrayList<String>();

    public ItemColorCard() {
        nameColor.add(TextFormatting.DARK_GRAY + WordUtils.capitalize((String)EnumDyeColor.BLACK.func_176762_d()));
        nameColor.add(TextFormatting.DARK_GRAY + WordUtils.capitalize((String)EnumDyeColor.GRAY.func_176762_d()));
        nameColor.add(TextFormatting.GRAY + WordUtils.capitalize((String)EnumDyeColor.SILVER.func_176762_d()));
        nameColor.add(TextFormatting.WHITE + WordUtils.capitalize((String)EnumDyeColor.WHITE.func_176762_d()));
        nameColor.add(TextFormatting.YELLOW + WordUtils.capitalize((String)EnumDyeColor.YELLOW.func_176762_d()));
        nameColor.add(TextFormatting.GOLD + WordUtils.capitalize((String)EnumDyeColor.ORANGE.func_176762_d()));
        nameColor.add(TextFormatting.DARK_RED + WordUtils.capitalize((String)EnumDyeColor.RED.func_176762_d()));
        nameColor.add(TextFormatting.LIGHT_PURPLE + WordUtils.capitalize((String)EnumDyeColor.PINK.func_176762_d()));
        nameColor.add(TextFormatting.GOLD + WordUtils.capitalize((String)EnumDyeColor.BROWN.func_176762_d()));
        nameColor.add(TextFormatting.DARK_GREEN + WordUtils.capitalize((String)EnumDyeColor.GREEN.func_176762_d()));
        nameColor.add(TextFormatting.GREEN + WordUtils.capitalize((String)EnumDyeColor.LIME.func_176762_d()));
        nameColor.add(TextFormatting.AQUA + WordUtils.capitalize((String)EnumDyeColor.CYAN.func_176762_d()));
        nameColor.add(TextFormatting.BLUE + WordUtils.capitalize((String)EnumDyeColor.LIGHT_BLUE.func_176762_d()));
        nameColor.add(TextFormatting.DARK_BLUE + WordUtils.capitalize((String)EnumDyeColor.BLUE.func_176762_d()));
        nameColor.add(TextFormatting.DARK_PURPLE + WordUtils.capitalize((String)EnumDyeColor.PURPLE.func_176762_d()));
        nameColor.add(TextFormatting.RED + WordUtils.capitalize((String)EnumDyeColor.MAGENTA.func_176762_d()));
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (!world.field_72995_K && player.func_70093_af()) {
                BlockPos pos = player.func_180425_c();
                player.openGui((Object)ColoredLights.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            if (!world.field_72995_K) {
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                ItemStack stack = player.field_71071_by.func_70448_g();
                int meta = stack.func_77960_j();
                EnumDyeColor color = EnumDyeColor.func_176764_b((int)meta);
                IItemHandler inventory = this.getInventory(stack);
                if (this.hasItems(inventory, meta, 1) || player.func_184812_l_()) {
                    Block blockTerracotta;
                    if ((block instanceof BlockColored || block instanceof BlockCarpet || block instanceof BlockStainedGlass || block instanceof BlockStainedGlassPane || block instanceof BlockConcretePowder) && state.func_177229_b((IProperty)BlockColored.field_176581_a) != color) {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)color));
                        if (!player.func_184812_l_()) {
                            this.consume(inventory, meta);
                        }
                    } else if (block instanceof BlockGlazedTerracotta && !block.func_149739_a().endsWith(WordUtils.capitalize((String)color.func_176762_d())) && (blockTerracotta = Block.func_149684_b((String)(color.func_176610_l() + "_glazed_terracotta"))) != null) {
                        world.func_175656_a(pos, blockTerracotta.func_176223_P().func_177226_a((IProperty)BlockGlazedTerracotta.field_185512_D, state.func_177229_b((IProperty)BlockGlazedTerracotta.field_185512_D)));
                        if (!player.func_184812_l_()) {
                            this.consume(inventory, meta);
                        }
                    }
                } else {
                    return EnumActionResult.FAIL;
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && target instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)target;
            int meta = stack.func_77960_j();
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)meta);
            IItemHandler inventory = this.getInventory(player.field_71071_by.func_70448_g());
            if (!sheep.func_70892_o() && sheep.func_175509_cj() != color && (this.hasItems(inventory, meta, 1) || player.func_184812_l_())) {
                sheep.func_175512_b(color);
                if (!player.func_184812_l_()) {
                    this.consume(inventory, meta);
                }
            }
            return true;
        }
        return false;
    }

    public IItemHandler getInventory(ItemStack stack) {
        if (stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return EmptyHandler.INSTANCE;
    }

    public boolean hasItems(IItemHandler inventory, int meta, int amount) {
        ItemStack stack = inventory.getStackInSlot(ColorCardStorageProvider.getSlotForColor(EnumDyeColor.func_176764_b((int)meta)));
        return !stack.func_190926_b() && stack.func_190916_E() >= amount;
    }

    public void consume(IItemHandler inventory, int meta) {
        inventory.extractItem(ColorCardStorageProvider.getSlotForColor(EnumDyeColor.func_176764_b((int)meta)), 1, false);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Color: " + nameColor.get(ColorCardStorageProvider.getSlotForColor(EnumDyeColor.func_176764_b((int)stack.func_77960_j()))));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ColorCardStorageProvider(stack);
    }

    @Override
    public Icon getTextureForStack(ItemStack stack) {
        return ModSprites.COLOR_CARD.getIcon(stack.func_77960_j());
    }

    @Override
    public List<ItemStack> getValidStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int meta = 0; meta < EnumDyeColor.values().length; ++meta) {
            stacks.add(new ItemStack((Item)this, 1, meta));
        }
        return stacks;
    }

    public static class ColorCardStorageProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        ItemStackHandler inventory;
        ItemStack stack;

        public ColorCardStorageProvider(ItemStack stack) {
            this.stack = stack;
            this.inventory = new ItemStackHandler(16){

                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    if (stack.func_77973_b() == ModItems.COLORED_DUST) {
                        int meta = stack.func_77960_j();
                        return ColorCardStorageProvider.getSlotForColor(EnumDyeColor.func_176764_b((int)meta)) == slot;
                    }
                    return false;
                }
            };
        }

        public static int getSlotForColor(EnumDyeColor color) {
            switch (color) {
                case BLACK: {
                    return 0;
                }
                case GRAY: {
                    return 1;
                }
                case SILVER: {
                    return 2;
                }
                case WHITE: {
                    return 3;
                }
                case YELLOW: {
                    return 4;
                }
                case ORANGE: {
                    return 5;
                }
                case RED: {
                    return 6;
                }
                case PINK: {
                    return 7;
                }
                case BROWN: {
                    return 8;
                }
                case GREEN: {
                    return 9;
                }
                case LIME: {
                    return 10;
                }
                case CYAN: {
                    return 11;
                }
                case LIGHT_BLUE: {
                    return 12;
                }
                case BLUE: {
                    return 13;
                }
                case PURPLE: {
                    return 14;
                }
                case MAGENTA: {
                    return 15;
                }
            }
            return 0;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.inventory.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.inventory.deserializeNBT(nbt);
        }
    }
}

