/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.recipe;

import coloredlights.ColoredLights;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class GrinderRecipes {
    public static final Map<ItemStack, Recipe> RECIPES_GRINDER = new HashMap<ItemStack, Recipe>();

    public static Recipe getRecipe(ItemStack input) {
        for (Map.Entry<ItemStack, Recipe> entry : RECIPES_GRINDER.entrySet()) {
            if (!entry.getKey().func_77969_a(input)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean hasRecipe(ItemStack input) {
        return GrinderRecipes.getRecipe(input) != null;
    }

    public static void addRecipe(Recipe recipe) {
        if (!GrinderRecipes.hasRecipe(recipe.input)) {
            RECIPES_GRINDER.put(recipe.input, recipe);
        } else {
            ColoredLights.LOGGER.info("Recipe already exists for ItemStack: " + recipe.input);
        }
    }

    public static void addRecipe(int energy, ItemStack input, ItemStack output, ItemStack outputSecondary) {
        GrinderRecipes.addRecipe(new Recipe(energy, input, output, outputSecondary));
    }

    public static void addRecipe(int energy, ItemStack input, ItemStack output) {
        GrinderRecipes.addRecipe(energy, input, output, ItemStack.field_190927_a);
    }

    public static boolean removeRecipe(ItemStack input) {
        for (Map.Entry<ItemStack, Recipe> entry : RECIPES_GRINDER.entrySet()) {
            if (!entry.getKey().func_77969_a(input)) continue;
            RECIPES_GRINDER.remove(entry.getKey());
            return true;
        }
        ColoredLights.LOGGER.info("Recipe does not exist for ItemStack: " + input);
        return false;
    }

    public static class Recipe {
        private final int energy;
        private final ItemStack input;
        private final ItemStack output;
        private final ItemStack outputSecondary;

        public Recipe(int energy, ItemStack input, ItemStack output, ItemStack outputSecondary) {
            this.energy = energy;
            this.input = input;
            this.output = output;
            this.outputSecondary = outputSecondary;
        }

        public int getEnergy() {
            return this.energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public ItemStack getOutputSecondary() {
            return this.outputSecondary;
        }

        public boolean hasSecondaryOutput() {
            return !this.outputSecondary.func_190926_b();
        }
    }
}

