/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.registry;

import coloredlights.ColoredLights;
import coloredlights.recipe.GrinderRecipes;
import coloredlights.registry.ModBlocks;
import coloredlights.registry.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ModRecipes {
    public static void registerRecipes() {
        ModRecipes.registerCraftingRecipes();
        ModRecipes.registerGrinderRecipes();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            if (recipe.func_77571_b().func_77973_b() != Items.field_151100_aR) continue;
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(Arrays.asList(ingredient.func_193365_a()));
                for (ItemStack itemStack : ingredient.func_193365_a()) {
                    if (itemStack.func_77973_b() != ModItems.COLORED_DUST) continue;
                    list.remove(itemStack);
                }
                recipe.func_192400_c().set(recipe.func_192400_c().indexOf((Object)ingredient), (Object)Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[0])));
            }
        }
    }

    public static void registerCraftingRecipes() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ModRecipes.addShapedRecipe("colored_lamp_" + color.func_176610_l(), new ItemStack(ModBlocks.COLORED_LAMP, 1, color.func_176765_a()), "GDG", "GDG", "GRG", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('D'), new ItemStack(ModItems.COLORED_DUST_GLOWING, 1, color.func_176765_a()), Character.valueOf('R'), Items.field_151137_ax);
            ModRecipes.addShapedRecipe("colored_lamp_inverted_" + color.func_176610_l(), new ItemStack(ModBlocks.COLORED_LAMP_INVERTED, 1, color.func_176765_a()), "GDG", "GDG", "GRG", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('D'), new ItemStack(ModItems.COLORED_DUST_GLOWING, 1, color.func_176765_a()), Character.valueOf('R'), Blocks.field_150429_aA);
            ModRecipes.addShapelessRecipe("colored_dust_glowing_" + color.func_176610_l(), new ItemStack(ModItems.COLORED_DUST_GLOWING, 4, color.func_176765_a()), Items.field_151114_aO, Items.field_151137_ax, new ItemStack(ModItems.COLORED_DUST, 1, color.func_176765_a()));
        }
        ModRecipes.addShapelessRecipe("colored_dust_orange", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.ORANGE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.YELLOW.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_magenta_0", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.MAGENTA.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.PURPLE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.PINK.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_magenta_1", new ItemStack(ModItems.COLORED_DUST, 3, EnumDyeColor.MAGENTA.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLUE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.PINK.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_magenta_2", new ItemStack(ModItems.COLORED_DUST, 3, EnumDyeColor.MAGENTA.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.PURPLE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_magenta_3", new ItemStack(ModItems.COLORED_DUST, 4, EnumDyeColor.MAGENTA.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLUE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_light_blue", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.LIGHT_BLUE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLUE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_lime", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.LIME.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.GREEN.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_pink", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.PINK.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_gray", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.GRAY.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLACK.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_light_gray_0", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.SILVER.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.GRAY.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_light_gray_1", new ItemStack(ModItems.COLORED_DUST, 3, EnumDyeColor.SILVER.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLACK.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.WHITE.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_cyan", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.CYAN.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLUE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.GREEN.func_176765_a()));
        ModRecipes.addShapelessRecipe("colored_dust_purple", new ItemStack(ModItems.COLORED_DUST, 2, EnumDyeColor.PURPLE.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLUE.func_176765_a()));
        ModRecipes.addShapedRecipe("grinder", new ItemStack(ModBlocks.GRINDER), "IPI", "GRG", "CFC", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('G'), Items.field_151145_ak, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('F'), Blocks.field_150460_al);
        ModRecipes.addShapedRecipe("color_card", new ItemStack(ModItems.COLOR_CARD), "ICI", "RGB", "IDI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('R'), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.RED.func_176765_a()), Character.valueOf('G'), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.GREEN.func_176765_a()), Character.valueOf('B'), new ItemStack(ModItems.COLORED_DUST, 1, EnumDyeColor.BLUE.func_176765_a()), Character.valueOf('D'), Items.field_151045_i);
        ModRecipes.addShapelessRecipe("alpha_sapling", new ItemStack(ModBlocks.ALPHA_SAPLING, 4), new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack(Blocks.field_150345_g, 1, 5));
    }

    public static void registerGrinderRecipes() {
        int DEFAULT_ENERGY = 100;
        for (EnumDyeColor color : EnumDyeColor.values()) {
            int meta = color.func_176765_a();
            for (ItemStack dye : CraftingHelper.getIngredient((Object)ColoredLights.DYE_ORES[meta]).func_193365_a()) {
                if (dye.func_77973_b() == ModItems.COLORED_DUST) continue;
                GrinderRecipes.addRecipe(100, dye, new ItemStack(ModItems.COLORED_DUST, 2, meta));
            }
            if (meta != 0) {
                GrinderRecipes.addRecipe(100, new ItemStack(Blocks.field_150325_L, 1, meta), new ItemStack(ModItems.COLORED_DUST, 1, meta), new ItemStack(Items.field_151007_F, 4));
                GrinderRecipes.addRecipe(100, new ItemStack(Blocks.field_150404_cg, 3, meta), new ItemStack(ModItems.COLORED_DUST, 2, meta), new ItemStack(Items.field_151007_F, 8));
            }
            GrinderRecipes.addRecipe(100, new ItemStack(Items.field_151104_aV, 1, meta), new ItemStack(ModItems.COLORED_DUST, 2, meta), new ItemStack(Items.field_151007_F, 12));
            GrinderRecipes.addRecipe(100, new ItemStack(ModBlocks.PNEUMEA_FLOWER, 1, meta), new ItemStack(ModItems.COLORED_DUST, 2, meta), new ItemStack(ModItems.PNEUMEA_SEED, 1));
        }
        GrinderRecipes.addRecipe(100, new ItemStack(Blocks.field_150325_L, 1, 0), new ItemStack(Items.field_151007_F, 4));
        GrinderRecipes.addRecipe(100, new ItemStack(Blocks.field_150404_cg, 3, 0), new ItemStack(Items.field_151007_F, 8));
    }

    public static void addShapedRecipe(String name, ItemStack output, Object ... objs) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("coloredlights", name), null, (ItemStack)output, (Object[])objs);
    }

    public static void addShapelessRecipe(String name, ItemStack output, Object ... objs) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (Object obj : objs) {
            ingredients.add(CraftingHelper.getIngredient((Object)obj));
        }
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("coloredlights", name), null, (ItemStack)output, (Ingredient[])ingredients.toArray(new Ingredient[0]));
    }
}

