/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.registry;

import coloredlights.ColoredLights;
import coloredlights.registry.ModBlocks;
import coloredlights.registry.ModItems;
import coloredlights.registry.ModRecipes;
import coloredlights.registry.ModTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import rzk.mc.lib.item.IItemProvider;

public class Registry {
    public static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final List<Item> ITEMS = new ArrayList<Item>();

    public static Block registerBlock(String modid, Block block, String name) {
        BLOCKS.add(((Block)block.setRegistryName(modid, name)).func_149663_c(name));
        if (block instanceof IItemProvider && ((IItemProvider)block).createItem() != IItemProvider.NO_ITEM) {
            Registry.registerItem(modid, (Item)((IItemProvider)block).createItem(), name);
        }
        return block;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
        ModTiles.registerTileEntities();
    }

    public static Item registerItem(String modid, Item item, String name) {
        ITEMS.add(((Item)item.setRegistryName(modid, name)).func_77655_b(name));
        return item;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.registerRecipes();
        for (EnumDyeColor color : EnumDyeColor.values()) {
            OreDictionary.registerOre((String)ColoredLights.DYE_ORES[color.func_176765_a()], (ItemStack)new ItemStack(ModItems.COLORED_DUST, 1, color.func_176765_a()));
        }
    }
}

