/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.tileentity;

import coloredlights.recipe.GrinderRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import rzk.mc.lib.util.BlockProps;

public class TileGrinder
extends TileEntity
implements ITickable,
IWorldNameable {
    public ItemStackHandler fuelInventory = new ItemStackHandler(){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return TileGrinder.this.getEnergyForStack(stack) > 0;
        }

        protected void onContentsChanged(int slot) {
            TileGrinder.this.func_70296_d();
        }
    };
    public ItemStackHandler inputInventory = new ItemStackHandler(){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            TileGrinder.this.func_70296_d();
        }
    };
    public ItemStackHandler outputInventory = new ItemStackHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        protected void onContentsChanged(int slot) {
            TileGrinder.this.func_70296_d();
        }
    };
    private boolean isGrinding;
    public final int processMax;
    public final int processPerTick = this.processMax / 100;
    public final int energyCapacity;
    public int process = 0;
    public int energyStored = 0;

    public TileGrinder() {
        this.processMax = 100;
        this.energyCapacity = 20000;
    }

    public void func_73660_a() {
        this.grind();
        this.handleFuel();
    }

    public void handleFuel() {
        int energy;
        ItemStack fuel = this.fuelInventory.getStackInSlot(0);
        if (!fuel.func_190926_b() && (energy = this.getEnergyForStack(fuel)) > 0 && this.energyStored + energy <= this.energyCapacity) {
            this.fuelInventory.extractItem(0, 1, false);
            this.energyStored += energy;
            this.func_70296_d();
        }
    }

    public int getEnergyPerProcess(ItemStack input) {
        return input.func_190926_b() ? Integer.MAX_VALUE : GrinderRecipes.getRecipe(input).getEnergy() * this.processPerTick / this.processMax;
    }

    public boolean hasFuel(ItemStack input) {
        return this.energyStored >= this.getEnergyPerProcess(input);
    }

    public boolean canGrind(ItemStack input) {
        if (input.func_190926_b() || !GrinderRecipes.hasRecipe(input) || !this.hasFuel(input)) {
            return false;
        }
        GrinderRecipes.Recipe recipe = GrinderRecipes.getRecipe(input);
        if (this.inputInventory.extractItem(0, recipe.getInput().func_190916_E(), true).func_190926_b() || input.func_190916_E() < recipe.getInput().func_190916_E()) {
            return false;
        }
        if (!this.outputInventory.insertItem(0, recipe.getOutput().func_77946_l(), true).func_190926_b()) {
            return false;
        }
        return !recipe.hasSecondaryOutput() || this.outputInventory.insertItem(1, recipe.getOutputSecondary().func_77946_l(), true).func_190926_b();
    }

    public void grind() {
        ItemStack input = this.inputInventory.getStackInSlot(0);
        if (this.canGrind(input)) {
            this.isGrinding = true;
            this.updateBlockState();
            GrinderRecipes.Recipe recipe = GrinderRecipes.getRecipe(input);
            if (this.process >= this.processMax) {
                this.process = 0;
                this.inputInventory.extractItem(0, recipe.getInput().func_190916_E(), false);
                this.outputInventory.insertItem(0, recipe.getOutput().func_77946_l(), false);
                if (recipe.hasSecondaryOutput()) {
                    this.outputInventory.insertItem(1, recipe.getOutputSecondary().func_77946_l(), false);
                }
            } else {
                this.process += this.processPerTick;
                this.energyStored -= this.getEnergyPerProcess(input);
            }
            this.func_70296_d();
        } else if (this.isGrinding) {
            this.process = 0;
            this.isGrinding = false;
            this.updateBlockState();
            this.func_70296_d();
        }
    }

    public void updateBlockState() {
        if ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockProps.STATE) != this.isGrinding) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockProps.STATE, (Comparable)Boolean.valueOf(this.isGrinding)));
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int getEnergyForStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151137_ax) {
            return 1000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
            return 10000;
        }
        return 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("process", this.process);
        compound.func_74768_a("energyStored", this.energyStored);
        compound.func_74782_a("fuelInv", (NBTBase)this.fuelInventory.serializeNBT());
        compound.func_74782_a("inputInv", (NBTBase)this.inputInventory.serializeNBT());
        compound.func_74782_a("outputInv", (NBTBase)this.outputInventory.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.process = compound.func_74762_e("process");
        this.energyStored = compound.func_74762_e("energyStored");
        this.fuelInventory.deserializeNBT(compound.func_74775_l("fuelInv"));
        this.inputInventory.deserializeNBT(compound.func_74775_l("inputInv"));
        this.outputInventory.deserializeNBT(compound.func_74775_l("outputInv"));
    }

    public String func_70005_c_() {
        return "tile.grinder.name";
    }

    public boolean func_145818_k_() {
        return this.func_70005_c_() != null;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != this.func_145838_q()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.fuelInventory, this.inputInventory, this.outputInventory}));
            }
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.fuelInventory, this.inputInventory, this.outputInventory}));
            }
            switch (facing) {
                case UP: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inputInventory);
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.fuelInventory);
                }
                case DOWN: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.outputInventory);
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.process;
            }
            case 1: {
                return this.energyStored;
            }
        }
        return 0;
    }

    public void setField(int id, int data) {
        switch (id) {
            case 0: {
                this.process = data;
                break;
            }
            case 1: {
                this.energyStored = data;
            }
        }
    }

    public int getFieldCount() {
        return 2;
    }
}

