/*
 * Decompiled with CFR 0.152.
 */
package coloredlights.worldgen;

import coloredlights.registry.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import rzk.mc.lib.util.BlockProps;

public class WorldGenPneumeaFlower
implements IWorldGenerator {
    private int minHeight = 60;
    private int maxHeight = 80;

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.generator(new WorldGeneratorPneumea(ModBlocks.PNEUMEA_FLOWER, EnumDyeColor.func_176764_b((int)rand.nextInt(16)), 7, this.minHeight, this.maxHeight), world, rand, chunkX, chunkZ, rand.nextInt(1000), this.minHeight, this.maxHeight);
            this.generator(new WorldGeneratorPneumea(ModBlocks.PNEUMEA_FLOWER_SHIMMERING, EnumDyeColor.func_176764_b((int)rand.nextInt(16)), 4, this.minHeight, this.maxHeight), world, rand, chunkX, chunkZ, rand.nextInt(10000), this.minHeight, this.maxHeight);
        }
    }

    private void generator(WorldGenerator worldGenerator, World world, Random rand, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (chance < 15) {
            int x = chunkX * 16;
            int y = minHeight;
            int z = chunkZ * 16;
            worldGenerator.func_180709_b(world, rand, new BlockPos(x, y, z));
            if (chance < 1) {
                worldGenerator.func_180709_b(world, rand, new BlockPos(x, y, z));
            }
        }
    }

    public static class WorldGeneratorPneumea
    extends WorldGenerator {
        private Block flower;
        private IBlockState state;
        private int maxAmount;
        private int minHeight;
        private int maxHeight;

        public WorldGeneratorPneumea(Block flower, EnumDyeColor color, int maxAmount, int minHeight, int maxHeight) {
            this.flower = flower;
            this.state = flower.func_176223_P().func_177226_a(BlockProps.COLOR, (Comparable)color);
            this.maxAmount = maxAmount;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            for (int i = 0; i < this.maxAmount; ++i) {
                BlockPos pos = position.func_177982_a(rand.nextInt(10) + 1, position.func_177956_o(), rand.nextInt(10) + 1);
                boolean set = false;
                for (int height = this.maxHeight; !set && height >= this.minHeight && height <= this.maxHeight; --height) {
                    if (!worldIn.func_175623_d(pos = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())) || worldIn.field_73011_w.func_177495_o() && pos.func_177956_o() >= 255 || !this.flower.func_176196_c(worldIn, pos)) continue;
                    set = true;
                    worldIn.func_180501_a(pos, this.state, 18);
                }
            }
            return true;
        }
    }
}

