/*
 * Decompiled with CFR 0.152.
 */
package rzk.mc.lib.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import rzk.mc.lib.block.BlockPlant;
import rzk.mc.lib.util.BlockProps;

public class BlockCrop
extends BlockPlant
implements IGrowable {
    public static final AxisAlignedBB[] CROP_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public final int maxAge = 7;
    public boolean dropAdditionalSeeds = true;

    public BlockCrop() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockProps.AGE, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(0.0f);
    }

    protected float getGrowthChance(Block block, World world, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState state = world.func_180495_p(pos.func_177977_b());
                if (this.canSustainPlant(state)) {
                    f1 = 1.0f;
                    if (state.func_177230_c().isFertile(world, pos.func_177977_b())) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = block == world.func_180495_p(blockpos3).func_177230_c() || block == world.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = block == world.func_180495_p(blockpos1).func_177230_c() || block == world.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = block == world.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || block == world.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CROP_AABB[(Integer)state.func_177229_b((IProperty)BlockProps.AGE)];
    }

    public void setAge(World world, BlockPos pos, IBlockState state, int age) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockProps.AGE, (Comparable)Integer.valueOf(age)));
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float chance;
        int currentAge;
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175697_a(pos, 1) && world.func_175671_l(pos.func_177984_a()) >= 9 && (currentAge = ((Integer)state.func_177229_b((IProperty)BlockProps.AGE)).intValue()) < 7 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / (chance = this.getGrowthChance(this, world, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.setAge(world, pos, state, currentAge + 1);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
        }
    }

    public ItemStack getSeed(IBlockState state) {
        return new ItemStack((Block)this);
    }

    public ItemStack getCrop(IBlockState state) {
        return new ItemStack((Block)this);
    }

    public void setDropAdditionalSeeds(boolean dropAdditionalSeeds) {
        this.dropAdditionalSeeds = dropAdditionalSeeds;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, 0);
        if (this.dropAdditionalSeeds) {
            Random rand;
            int currentAge = (Integer)state.func_177229_b((IProperty)BlockProps.AGE);
            Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            if (currentAge >= 7) {
                for (int i = 0; i < 3 + fortune; ++i) {
                    if (rand.nextInt(14) > currentAge) continue;
                    drops.add((Object)this.getSeed(state));
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ((Integer)state.func_177229_b((IProperty)BlockProps.AGE) >= 7 ? this.getCrop(state) : this.getSeed(state)).func_77973_b();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.getSeed(state);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)BlockProps.AGE) < 7;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.setAge(world, pos, state, Math.max((Integer)state.func_177229_b((IProperty)BlockProps.AGE) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5), 7));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProps.AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockProps.AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProps.AGE});
    }
}

