/*
 * Decompiled with CFR 0.152.
 */
package rzk.mc.lib.platform.client.model;

import coloredlights.registry.Registry;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rzk.mc.lib.platform.client.model.ModelBase;
import rzk.mc.lib.platform.client.model.ModelHelper;
import rzk.mc.lib.platform.client.model.block.ModelBlock;
import rzk.mc.lib.platform.client.model.item.ModelItem;
import rzk.mc.lib.platform.client.model.util.block.ICustomBlockModel;
import rzk.mc.lib.platform.client.model.util.block.ITexturedBlock;
import rzk.mc.lib.platform.client.model.util.item.ICustomItemModel;
import rzk.mc.lib.platform.client.model.util.item.ICustomItemTransform;
import rzk.mc.lib.platform.client.model.util.item.IStackItem;
import rzk.mc.lib.platform.client.model.util.item.ITexturedItem;

public class ModelBaker {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModelBake(ModelBakeEvent event) {
        ModelBaker.bakeBlockModels(event);
        ModelBaker.bakeItemModels(event);
    }

    public static void bakeBlockModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (Block block : Registry.BLOCKS) {
            if (!(block instanceof ITexturedBlock) && !(block instanceof ICustomBlockModel)) continue;
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                ModelBase model = block instanceof ICustomBlockModel ? ((ICustomBlockModel)block).getModelForState(state) : new ModelBlock(state, (ITexturedBlock)block);
                registry.func_82595_a((Object)ModelBaker.getModelResourceLocation(state), (Object)model);
                ModelResourceLocation inventory = ModelBaker.getModelResourceLocation(Item.func_150898_a((Block)block), block.func_176201_c(state));
                registry.func_82595_a((Object)inventory, (Object)model);
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)inventory);
            }
            registry.func_82595_a((Object)ModelBaker.getModelResourceLocation(Item.func_150898_a((Block)block)), (Object)(block instanceof ICustomBlockModel ? ((ICustomBlockModel)block).getModelForState(block.func_176223_P()) : new ModelBlock(block.func_176223_P(), (ITexturedBlock)block)));
        }
    }

    public static void bakeItemModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (Item item : Registry.ITEMS) {
            if (!(item instanceof ITexturedItem) && !(item instanceof ICustomItemModel)) continue;
            List<ItemStack> stacks = ((IStackItem)item).getValidStacks();
            for (ItemStack stack : stacks) {
                ModelBase model;
                ModelBase modelBase = model = item instanceof ICustomItemModel ? ((ICustomItemModel)item).getModelForStack(stack) : new ModelItem(stack);
                if (item instanceof ICustomItemTransform && ((ICustomItemTransform)item).hasCustomTransform(stack)) {
                    model.setTransforms(ModelHelper.getTransformsMap(((ICustomItemTransform)item).getCustomTransform(stack)));
                }
                ModelResourceLocation inventory = ModelBaker.getModelResourceLocation(item, stack.func_77960_j());
                registry.func_82595_a((Object)inventory, (Object)model);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77960_j(), (ModelResourceLocation)inventory);
            }
            ItemStack stack = new ItemStack(item, 1, 0);
            registry.func_82595_a((Object)ModelBaker.getModelResourceLocation(item), (Object)(item instanceof ICustomItemModel ? ((ICustomItemModel)item).getModelForStack(stack) : new ModelItem(stack)));
        }
    }

    public static ModelResourceLocation getModelResourceLocation(IBlockState state) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), new DefaultStateMapper().func_178131_a((Map)state.func_177228_b()));
    }

    public static ModelResourceLocation getModelResourceLocation(Item item, int meta) {
        return new ModelResourceLocation(Item.field_150901_e.func_177774_c((Object)item) + (meta != -1 ? "_" + meta : ""), "inventory");
    }

    public static ModelResourceLocation getModelResourceLocation(Item item) {
        return ModelBaker.getModelResourceLocation(item, -1);
    }
}

