/*
 * Decompiled with CFR 0.152.
 */
package rzk.mc.lib.platform.client.model;

import com.google.common.collect.ImmutableMap;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelHelper {
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS_BLOCK = ModelHelper.getTransformsMap(new ResourceLocation("minecraft", "models/block/block"));
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS_ITEM = ModelHelper.getTransformsMap(new ResourceLocation("minecraft", "models/item/generated"));
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS_ITEM_HANDHELD = ModelHelper.getTransformsMap(new ResourceLocation("minecraft", "models/item/handheld"));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ItemCameraTransforms getTransforms(ResourceLocation location) {
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json"));){
            ItemCameraTransforms itemCameraTransforms = ModelBlock.func_178307_a((Reader)new InputStreamReader(resource.func_110527_b())).func_181682_g();
            return itemCameraTransforms;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemCameraTransforms.field_178357_a;
        }
    }

    public static ItemCameraTransforms getTransforms(String json) {
        try {
            return ModelBlock.func_178307_a((Reader)new StringReader(json)).func_181682_g();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemCameraTransforms.field_178357_a;
        }
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransformsMap(ResourceLocation location) {
        return PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)ModelHelper.getTransforms(location));
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransformsMap(String json) {
        return PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)ModelHelper.getTransforms(json));
    }
}

